/*
 * Decompiled with CFR 0.152.
 */
package hdi;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public enum MetricType {
    NUMBER_OF_LINES("Service Count", "lineCount", "lineCnt"),
    NUMBER_OF_CLAIMS("Claim Count", "count", "claimCnt"),
    NUMBER_OF_PAYMENTS("Claim Count", "count", "paymentCnt"),
    NUMBER_OF_PROVIDERS("Provider Count", null, null),
    NUMBER_OF_SUBSCRIBERS("Patient Count", null, null),
    BILLED("Charge Amt", "total", "chargeAmt"),
    AVG_BILLED("Avg Charge Amt", "avg", "chargeAmtAvg"),
    MAX_BILLED("Max Charge Amt", "max", "chargeAmtMax"),
    PAID("Paid Amt", "total", "paymentAmt"),
    ADJUSTMENTS_TOTAL("Adjustment Amt", "total", "adjustmentAmt"),
    AVG_PAID("Avg Paid Amt", "avg", "paymentAmtAvg"),
    NUMBER_OF_FILES("File Count", null, null),
    TIME_FRAME("Service Dates", null, null),
    PERIOD("Period", "period", "period");

    private final String title;
    private final String fieldName;
    private final String metricFieldName;

    public static List<String> getActiveLabels() {
        ArrayList<String> labels = new ArrayList<String>();
        for (MetricType val : MetricType.values()) {
            if (val.fieldName == null) continue;
            labels.add(val.title);
        }
        return labels;
    }

    public static List<String> toLabels(List<MetricType> metricTypes) {
        ArrayList<String> labels = new ArrayList<String>();
        for (MetricType val : metricTypes) {
            if (val.fieldName == null) continue;
            labels.add(val.title);
        }
        return labels;
    }

    public boolean isCount() {
        return StringUtils.containsIgnoreCase((CharSequence)this.name(), (CharSequence)"number");
    }

    public static MetricType findByLabel(String label) {
        ArrayList labels = new ArrayList();
        for (MetricType val : MetricType.values()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)label, (CharSequence)val.title)) continue;
            return val;
        }
        return null;
    }

    @Generated
    public String title() {
        return this.title;
    }

    @Generated
    public String fieldName() {
        return this.fieldName;
    }

    @Generated
    public String metricFieldName() {
        return this.metricFieldName;
    }

    @Generated
    private MetricType(String title, String fieldName, String metricFieldName) {
        this.title = title;
        this.fieldName = fieldName;
        this.metricFieldName = metricFieldName;
    }
}

