/*
 * Decompiled with CFR 0.152.
 */
package hdi;

import hdi.edi.fileinfo.FileInfo;
import hdi.edi.parser.EdiParser;
import hdi.edi.parser.EdiParsingResults;
import hdi.edi.parser.EdiSeg;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public interface TestFilesLocations {
    public static final String CLAIMS_BASE_DIR = "../clinsight/data_files/claims/in";
    public static final String EDI_277_BASE_DIR = "../clinsight/data_files/277";
    public static final String EDI_278_BASE_DIR = "../clinsight/data_files/278";
    public static final String EDI_271_BASE_DIR = "../clinsight/data_files/271";
    public static final String EDI_834_BASE_DIR = "../clinsight/data_files/834";
    public static final String EDI_810_BASE_DIR = "../clinsight/data_files/810";
    public static final File GENERATED_FILES_DIR = new File("../clinsight/data_files/claims/in", "generated");
    public static final File MISC_TEST_FILES_DIR = new File("../clinsight/data_files/claims/in", "misc_test_files");
    public static final File COMPREHENSIVE_TEST_FILES = new File("../clinsight/data_files/claims/in", "comprehensive_test_files");
    public static final String EDI_INST_TEST_FILE_NAME = "837I.02012020.090121.dat";
    public static final File EDI_INST_TEST_FILE = new File(COMPREHENSIVE_TEST_FILES, "837I.02012020.090121.dat");
    public static final File EDI_INST_COMPREH_FILE = new File(COMPREHENSIVE_TEST_FILES, "inst_comprehensive.dat");
    public static final File EDI_INST_MULTIPLE_NOTES = new File(COMPREHENSIVE_TEST_FILES, "inst_multiple_notes.dat");
    public static final String EDI_PROF_TEST_FILE_NAME = "prof_comprehensive.dat";
    public static final File EDI_PROF_TEST_FILE;
    public static final File EDI_837P_UT_TEST_FILE;
    public static final String EDI_DENT_TEST_FILE_NAME = "837D-all-fields.dat";
    public static final File EDI_DENT_TEST_FILE;
    public static final File HCFA_UB_DIR;
    public static final File HCFA_TEST_FILE;
    public static final File INVALID_DIR;
    public static final File NOT_EDI_FILE;
    public static final File UNEXPECTED_SEGMENTS_FILE;
    public static final File TOO_MANY_ISSUES_FILE;
    public static final File EXAMPLES_835_D;
    public static final File FILES_WITH_ISSUES_DIR;
    public static final File BAD_DIAG_FILE;
    public static final File BAD_PROC_FILE;
    public static final File INST_BAD_PTP_FILE;
    public static final File INST_BAD_MUE_FILE;
    public static final File INVALID_QUALIFIER_FILE;
    public static final File INVALID_SEGNAME_FILE;
    public static final File EDI_MULTI_CLAIM_DIR;
    public static final File EDI_MULTI_CLAIM_FILE;
    public static final File EDI_MULTI_PAYMENT_FILE;
    public static final File EDI_MULTI_TRAN_FILE;
    public static final File X12_EXAMPLES_835_837_DIR;
    public static final File EDI_SPEC_EXAMPLES_DIR;
    public static final File PROF_SPEC_EXAMPLES_DIR;
    public static final File PROF_SPEC_HOME_INFUSION_FILE;
    public static final File PROF_SPEC_PROPERTY_CASUALTY_FILE;
    public static final File PROF_SPEC_COB_FILE;
    public static final File PROF_SPEC_COMMERCIAL_FILE;
    public static final File PROF_SPEC_RESUB_REPLACEMENT_FILE;
    public static final File PROF_SPEC_AMBULANCE_FILE;
    public static final File EDI_835_TEST_FILE;
    public static final File PAYMENT_UT_DIR;
    public static final String EDI_835_UT_TEST_FILE_NAME = "negotiated_discount.dat";
    public static final File EDI_835_UT_TEST_FILE;
    public static final File EDI_835_PLB_TEST_FILE;
    public static final File EDI_835_DOLLARS_SEPARATE_TEST_FILE;
    public static final File EDI_835_NOT_COVERED_INPATIENT_TEST_FILE;
    public static final File EDI_835_MOA_TEST_FILE;
    public static final File EDI_835_MIA_TEST_FILE;
    public static final File EDI_837P_MIA_MOA_TEST_FILE;
    public static final String EDI_834_ALL_FIELDS_FILE_NAME = "834-all-fields.edi";
    public static final File EDI_834_ALL_FIELDS_FILE;
    public static final String EDI_277CA_ALL_FIELDS_FILE_NAME = "277CA-all-fields.edi";
    public static final File EDI_277CA_ALL_FIELDS_FILE;
    public static final File EDI_277CA_MULTI_TRAN_FILE;
    public static final File EDI_277CA_RECEIVER_REJECTED_FILE;
    public static final File EDI_277_MULTI_TRAN_FILE;
    public static final String CODE_SETS_BASE_DIR = "./data_files/codesets";
    public static final File DIAG_DIR;
    public static final File PROVIDER_TAXONOMY_DIR;
    public static final File RBCS_DIR;
    public static final File RBCS_TAXONOMY_FILE;
    public static final File CARC_RARC_DIR;
    public static final File PROC_DIR;
    public static final File CPT_CODE_SET_FILE;
    public static final File HCPC_CODE_SET_FILE;
    public static final File ICD_PCS_CODE_SET_FILE;
    public static final File ICD9_PCS_CODE_SET_FILE;
    public static final File UB_DIR;
    public static final File NDC_DIR;
    public static final File NDC_PRODUCT_TEST_FILE;
    public static final File OCC_CODE_SET_FILE;
    public static final File OCC_SPAN_CODE_SET_FILE;
    public static final String PROC_RULES_BASE_DIR = "./data_files/codeeditrule";
    public static final File PTP_DIR;
    public static final File PTP_TEST_DIR;
    public static final File MUE_DIR;
    public static final File AGE_GENDER_DIR;
    public static final File PTP_FILE;
    public static final File MUE_FILE;
    public static final File AGE_FILE;
    public static final File GENDER_FILE;
    public static final File OPEN_EDI_DIR;
    public static final File OPEN_EDI_ALL_SCHEMAS_DIR;
    public static final String EDI_FILES_DIR = "./data_files/edi-hipaa";
    public static final File NCPDP_FILES_DIR;
    public static final File NCPDP_TEST_FILE;
    public static final File NCPDP_TELCO_DUR_FILE;
    public static final File NCPDP_TELCO_COB_FILE;

    default public EdiParsingResults parseEdi(File file) {
        try (EdiParser parser = new EdiParser(new FileInfo(file)).isStrictMode(true).isSplitMode(true);){
            EdiParsingResults ediParsingResults = parser.parse();
            return ediParsingResults;
        }
    }

    default public EdiParsingResults parseEdi(File file, boolean isStrictMode, boolean isSplitMode) {
        try (EdiParser parser = new EdiParser(new FileInfo(file)).isStrictMode(isStrictMode).isSplitMode(isSplitMode);){
            EdiParsingResults ediParsingResults = parser.parse();
            return ediParsingResults;
        }
    }

    default public EdiParsingResults parseEdi(String ediText) {
        return this.parseEdi(ediText, false);
    }

    default public EdiParsingResults parseEdi(String ediText, boolean isFragmentMode, boolean isSplitMode) {
        try (EdiParser parser = new EdiParser(new FileInfo(ediText)).isStrictMode(false).isSplitMode(isSplitMode).isFragmentMode(isFragmentMode);){
            EdiParsingResults ediParsingResults = parser.parseAll();
            return ediParsingResults;
        }
    }

    default public EdiParsingResults parseEdi(String ediText, boolean isFragmentMode) {
        return this.parseEdi(ediText, isFragmentMode, false);
    }

    default public void dumpEDI(File file, boolean isSplitMode) {
        try (EdiParser parser = new EdiParser(new FileInfo(file)).isStrictMode(true).isSplitMode(isSplitMode);){
            EdiParsingResults results = parser.parse();
            System.err.println(EdiSeg.toFormattedStringWithChildren(results.segs()));
        }
    }

    default public List<EdiParsingResults> parseInChunks(File file, int batchSize) {
        return this.parseInChunks(file, batchSize, true);
    }

    default public List<EdiParsingResults> parseInChunks(File file, int batchSize, boolean isSplitMode) {
        ArrayList<EdiParsingResults> resultsList = new ArrayList<EdiParsingResults>();
        try (EdiParser parser = new EdiParser(file).isSplitMode(isSplitMode);){
            EdiParsingResults results;
            int batchI = 0;
            do {
                results = parser.parse(batchSize);
                resultsList.add(new EdiParsingResults(results));
                if (++batchI <= 1000) continue;
                break;
            } while (!results.isDone());
        }
        return resultsList;
    }

    default public void printChunks(List<EdiParsingResults> resultsList) {
        int batchI = 0;
        for (EdiParsingResults results : resultsList) {
            System.err.println("*** Batch" + batchI++ + " ***");
            System.err.println(EdiSeg.toFormattedStringWithChildren(results.segs()));
        }
    }

    static {
        EDI_837P_UT_TEST_FILE = EDI_PROF_TEST_FILE = new File(COMPREHENSIVE_TEST_FILES, EDI_PROF_TEST_FILE_NAME);
        EDI_DENT_TEST_FILE = new File(COMPREHENSIVE_TEST_FILES, EDI_DENT_TEST_FILE_NAME);
        HCFA_UB_DIR = new File(CLAIMS_BASE_DIR, "pit_ub_hcfa");
        HCFA_TEST_FILE = new File(HCFA_UB_DIR, "CCNN-TerminalStatus-HCFA-CCNNC-20190315.txt");
        INVALID_DIR = new File(CLAIMS_BASE_DIR, "invalid");
        NOT_EDI_FILE = new File(INVALID_DIR, "not_edi.dat");
        UNEXPECTED_SEGMENTS_FILE = new File(INVALID_DIR, "unexpected_segments.dat");
        TOO_MANY_ISSUES_FILE = new File(INVALID_DIR, "837p_too_many_issues.dat");
        EXAMPLES_835_D = new File(CLAIMS_BASE_DIR, "examples_835_837d");
        FILES_WITH_ISSUES_DIR = new File(CLAIMS_BASE_DIR, "files_with_issues");
        BAD_DIAG_FILE = new File(FILES_WITH_ISSUES_DIR, "template/inst_bad_prin_diag.dat");
        BAD_PROC_FILE = new File(FILES_WITH_ISSUES_DIR, "template/inst_bad_proc.dat");
        INST_BAD_PTP_FILE = new File(FILES_WITH_ISSUES_DIR, "inst_ptp.dat");
        INST_BAD_MUE_FILE = new File(FILES_WITH_ISSUES_DIR, "mue_test.dat");
        INVALID_QUALIFIER_FILE = new File(FILES_WITH_ISSUES_DIR, "invalid_qualifier_837p.dat");
        INVALID_SEGNAME_FILE = new File(FILES_WITH_ISSUES_DIR, "837p_invalid_line.dat");
        EDI_MULTI_CLAIM_DIR = new File(CLAIMS_BASE_DIR, "multiclaim");
        EDI_MULTI_CLAIM_FILE = new File(EDI_MULTI_CLAIM_DIR, "837p_multiclaim.dat");
        EDI_MULTI_PAYMENT_FILE = new File(EDI_MULTI_CLAIM_DIR, "835_multi.dat");
        EDI_MULTI_TRAN_FILE = new File(EDI_MULTI_CLAIM_DIR, "multi_tran.dat");
        X12_EXAMPLES_835_837_DIR = new File("../clinsight/data_files/x12examples");
        EDI_SPEC_EXAMPLES_DIR = new File(CLAIMS_BASE_DIR, "spec_examples");
        PROF_SPEC_EXAMPLES_DIR = new File(EDI_SPEC_EXAMPLES_DIR, "prof");
        PROF_SPEC_HOME_INFUSION_FILE = new File(PROF_SPEC_EXAMPLES_DIR, "home-infusion-ndc.dat");
        PROF_SPEC_PROPERTY_CASUALTY_FILE = new File(MISC_TEST_FILES_DIR, "accident.dat");
        PROF_SPEC_COB_FILE = new File(PROF_SPEC_EXAMPLES_DIR, "cob-payera-payerb.dat");
        PROF_SPEC_COMMERCIAL_FILE = new File(PROF_SPEC_EXAMPLES_DIR, "commercial.dat");
        PROF_SPEC_RESUB_REPLACEMENT_FILE = new File(PROF_SPEC_EXAMPLES_DIR, "commercial-replacement.dat");
        PROF_SPEC_AMBULANCE_FILE = new File(PROF_SPEC_EXAMPLES_DIR, "ambulance.dat");
        EDI_835_TEST_FILE = new File(EDI_SPEC_EXAMPLES_DIR, "payment/835.edi");
        PAYMENT_UT_DIR = new File(CLAIMS_BASE_DIR, "835_ut");
        EDI_835_UT_TEST_FILE = new File(PAYMENT_UT_DIR, EDI_835_UT_TEST_FILE_NAME);
        EDI_835_PLB_TEST_FILE = new File(MISC_TEST_FILES_DIR, "835-plb.dat");
        EDI_835_DOLLARS_SEPARATE_TEST_FILE = new File(EDI_SPEC_EXAMPLES_DIR, "payment/dollars_data_separate.dat");
        EDI_835_NOT_COVERED_INPATIENT_TEST_FILE = new File(PAYMENT_UT_DIR, "not_covered_inpatient.edi");
        EDI_835_MOA_TEST_FILE = new File(MISC_TEST_FILES_DIR, "835-moa.dat");
        EDI_835_MIA_TEST_FILE = new File(MISC_TEST_FILES_DIR, "835-mia.dat");
        EDI_837P_MIA_MOA_TEST_FILE = new File(MISC_TEST_FILES_DIR, "837p-mia-moa.dat");
        EDI_834_ALL_FIELDS_FILE = new File(EDI_834_BASE_DIR, EDI_834_ALL_FIELDS_FILE_NAME);
        EDI_277CA_ALL_FIELDS_FILE = new File(EDI_277_BASE_DIR, EDI_277CA_ALL_FIELDS_FILE_NAME);
        EDI_277CA_MULTI_TRAN_FILE = new File(EDI_277_BASE_DIR, "277CA-multi-tran.edi");
        EDI_277CA_RECEIVER_REJECTED_FILE = new File(EDI_277_BASE_DIR, "277CA-receiver-rejected.edi");
        EDI_277_MULTI_TRAN_FILE = new File(EDI_277_BASE_DIR, "multitran-277.dat");
        DIAG_DIR = new File(CODE_SETS_BASE_DIR, "dx");
        PROVIDER_TAXONOMY_DIR = new File(CODE_SETS_BASE_DIR, "taxonomy");
        RBCS_DIR = new File(CODE_SETS_BASE_DIR, "rbcs");
        RBCS_TAXONOMY_FILE = new File(RBCS_DIR, "2021_RBCS_Taxonomy.csv");
        CARC_RARC_DIR = new File(CODE_SETS_BASE_DIR, "carc_rarc");
        PROC_DIR = new File(CODE_SETS_BASE_DIR, "proc");
        CPT_CODE_SET_FILE = new File(PROC_DIR, "cpt/OPTUM_CPT_BASE_COVERAGE_2021_01.TAB");
        HCPC_CODE_SET_FILE = new File(PROC_DIR, "hcpcs/HCPC2021_04_CONTR_ANWEB.txt");
        ICD_PCS_CODE_SET_FILE = new File(PROC_DIR, "icdpcs/icd10pcs_order_2021.txt");
        ICD9_PCS_CODE_SET_FILE = new File(PROC_DIR, "icdpcs/zCMS32_DESC_LONG_SG.txt");
        UB_DIR = new File(CODE_SETS_BASE_DIR, "UB");
        NDC_DIR = new File(CODE_SETS_BASE_DIR, "ndc");
        NDC_PRODUCT_TEST_FILE = new File(NDC_DIR, "ndc_product_test.txt");
        OCC_CODE_SET_FILE = new File(UB_DIR, "OPTUM_UB04_OCCURRENCE_SPAN_CODES_2020_11.txt");
        OCC_SPAN_CODE_SET_FILE = new File(UB_DIR, "OPTUM_UB04_OCCURRENCE_DATE_CODES_2020_11.txt");
        PTP_DIR = new File(PROC_RULES_BASE_DIR, "ptp");
        PTP_TEST_DIR = new File(PROC_RULES_BASE_DIR, "ptp-test");
        MUE_DIR = new File(PROC_RULES_BASE_DIR, "mue");
        AGE_GENDER_DIR = new File(PROC_RULES_BASE_DIR, "age_gender");
        PTP_FILE = new File(PTP_TEST_DIR, "ccipra-v281r0-f1.csv");
        MUE_FILE = new File(MUE_DIR, "MCR_MUE_PractitionerServices_Eff_04-01-2022.csv");
        AGE_FILE = new File(AGE_GENDER_DIR, "Age_CY22Q1.csv");
        GENDER_FILE = new File(AGE_GENDER_DIR, "Gender_CY22Q1.csv");
        OPEN_EDI_DIR = new File("./schemas");
        OPEN_EDI_ALL_SCHEMAS_DIR = new File("./schemas_all");
        NCPDP_FILES_DIR = new File(CLAIMS_BASE_DIR, "ncpdp");
        NCPDP_TEST_FILE = new File(NCPDP_FILES_DIR, "b1_ncpdp_test.dat");
        NCPDP_TELCO_DUR_FILE = new File(NCPDP_FILES_DIR, "b1_telco_durpps.dat");
        NCPDP_TELCO_COB_FILE = new File(NCPDP_FILES_DIR, "b1_telco_cob.dat");
    }
}

