/*
 * Decompiled with CFR 0.152.
 */
package hdi.edi;

import hdi.edi.fileinfo.FileInfo;
import hdi.edi.parser.EdiSeg;
import hdi.edi.stats.IngestStats;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.springframework.data.annotation.PersistenceCreator;
import org.springframework.data.annotation.Transient;

public class EdiHolder {
    private String id;
    private FileInfo fileInfo;
    private IngestStats stats = new IngestStats();
    @Transient
    private final List<EdiSeg> ediSegs = new ArrayList<EdiSeg>();

    @PersistenceCreator
    public EdiHolder(IngestStats stats) {
        this.stats = stats;
    }

    public EdiHolder(String id) {
        this.setIdFromUrl(id);
    }

    private void setIdFromUrl(String url) {
        this.id = URLEncoder.encode(url, StandardCharsets.UTF_8);
    }

    public String fileName() {
        return this.fileInfo.name();
    }

    public String fileNameWithTranType() {
        Object s = this.fileName();
        if (this.stats.mainTransactionType() != null) {
            s = (String)s + " (" + this.stats.mainTransactionType().description() + ")";
        }
        return s;
    }

    @Generated
    public String id() {
        return this.id;
    }

    @Generated
    public FileInfo fileInfo() {
        return this.fileInfo;
    }

    @Generated
    public IngestStats stats() {
        return this.stats;
    }

    @Generated
    public List<EdiSeg> ediSegs() {
        return this.ediSegs;
    }

    @Generated
    public String toString() {
        return "EdiHolder(id=" + this.id() + ", fileInfo=" + String.valueOf(this.fileInfo()) + ", stats=" + String.valueOf(this.stats()) + ")";
    }

    @Generated
    public EdiHolder fileInfo(FileInfo fileInfo) {
        this.fileInfo = fileInfo;
        return this;
    }
}

