/*
 * Decompiled with CFR 0.152.
 */
package hdi.edi;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import hdi.edi.dict.annotations.ObjType;
import hdi.edi.dict.annotations.Prop;
import hdi.edi.edient.EdiEntity;
import hdi.edi.fileinfo.FileInfo;
import hdi.edi.objmapper.EdiObjectMapper;
import hdi.edi.objmapper.annotations.EdiElt;
import hdi.edi.parser.EdiParsingResults;
import hdi.edi.parser.EdiSeg;
import hdi.edi.parser.SegmentType;
import hdi.edi.parser.TransactionType;
import hdi.model.DateTimePeriod;
import hdi.model.Quantity;
import hdi.model.Reference;
import hdi.model.enumtype.ClaimOrEncounterIdentifierType;
import hdi.model.enumtype.DateType;
import hdi.model.enumtype.IdentificationType;
import hdi.model.enumtype.ReferenceType;
import hdi.model.orgperson.OrgOrPerson;
import hdi.model.payment.PaymentMethodType;
import hdi.model.payment.TransactionHandlingType;
import hdi.util.CollectionUtils;
import hdi.util.FormattingUtils;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.annotation.Transient;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
public class EdiTransaction
implements EdiEntity {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EdiTransaction.class);
    @EdiElt.Exclude
    private String id = ObjectId.get().toHexString();
    @Transient
    @EdiElt.Exclude
    @JsonIgnore
    private List<EdiSeg> ediSegs = new ArrayList<EdiSeg>();
    @Transient
    @EdiElt.Exclude
    public static final EdiObjectMapper<EdiTransaction> mapper = new EdiObjectMapper();
    @EdiElt(pos=2, seg="ST")
    @Prop(edi={"ST02"}, minWidth=4, maxWidth=9)
    private String controlNumber;
    private String groupControlNumber;
    @Prop(desc={"Transaction type translated to string constant, PROF for 837P, INST for 837I, etc."}, ignoreForEdiGen=true, edi={"ST01", "ST03"})
    private TransactionType transactionType;
    @EdiElt(value={"production_date"})
    @Prop(dateType={DateType.PRODUCTION}, tran={TransactionType.PAYMENT})
    private LocalDate productionDate;
    @EdiElt(pos=1, seg="BHT", tran={TransactionType.PROF, TransactionType.INST, TransactionType.DENTAL, TransactionType.CLAIM_ACK})
    private String hierarchicalStructureCode;
    @Prop(edi={"837:BHT02", "277:BHT02", "834:BGN01"}, tran={TransactionType.PROF, TransactionType.INST, TransactionType.DENTAL, TransactionType.CLAIM_ACK, TransactionType.MEMBER_COVERAGE})
    @EdiElt(pos=2, seg="BHT")
    private String purposeCode;
    @Prop(edi={"837:BHT03", "277:BHT03", "834:BGN02"}, tran={TransactionType.PROF, TransactionType.INST, TransactionType.DENTAL, TransactionType.CLAIM_ACK, TransactionType.MEMBER_COVERAGE})
    @EdiElt(value={"originator_application_transaction_id", "transaction_set_reference_number"})
    private String originatorApplicationTransactionId;
    @EdiElt(value={"transaction_set_creation_date", "creation_date", "creationDate"})
    @Prop(edi={"837:BHT04", "277:BHT04", "834:BGN03"}, tran={TransactionType.PROF, TransactionType.INST, TransactionType.DENTAL, TransactionType.CLAIM_ACK, TransactionType.MEMBER_COVERAGE})
    private LocalDate creationDate;
    @EdiElt(value={"transaction_set_creation_time"})
    @Prop(edi={"837:BHT05", "277:BHT05", "834:BGN04"}, tran={TransactionType.PROF, TransactionType.INST, TransactionType.DENTAL, TransactionType.CLAIM_ACK, TransactionType.MEMBER_COVERAGE})
    private LocalTime creationTime;
    @EdiElt(value={"transaction_type_code"})
    @Prop(edi={"BHT06"}, tran={TransactionType.PROF, TransactionType.INST, TransactionType.DENTAL})
    private ClaimOrEncounterIdentifierType claimOrEncounterIdentifierType;
    @EdiElt(pos=6, seg="BGN")
    @Prop(edi={"BGN06"}, tran={TransactionType.MEMBER_COVERAGE})
    private String originalTransactionSetReferenceNumber;
    @Prop(edi={"BGN08"}, tran={TransactionType.MEMBER_COVERAGE})
    @EdiElt(pos=8, seg="BGN")
    private String actionCode;
    @EdiElt(pos=1, seg="BPR", tran={TransactionType.PAYMENT}, isRequired=true)
    private TransactionHandlingType transactionHandlingType;
    @EdiElt(pos=2, seg="BPR", tran={TransactionType.PAYMENT}, isRequired=true)
    private BigDecimal totalPaymentAmount;
    @Prop(edi={"BPR03"}, tran={TransactionType.PAYMENT}, isRequired=true)
    private String creditOrDebitFlagCode;
    @EdiElt(pos=4, seg="BPR", tran={TransactionType.PAYMENT}, isRequired=true, desc="Payment method type: ACH, CHECK, WIRE_TRANSFER, NON_PAYMENT")
    private PaymentMethodType paymentMethodType;
    @EdiElt(pos=5, seg="BPR", tran={TransactionType.PAYMENT})
    private String paymentFormatCode;
    @EdiElt(pos=7, seg="BPR", tran={TransactionType.PAYMENT})
    private String senderBankRoutingNumber;
    @EdiElt(pos=9, seg="BPR", tran={TransactionType.PAYMENT})
    private String senderAccountNumber;
    @EdiElt(pos=10, seg="BPR", tran={TransactionType.PAYMENT})
    @Prop(edi={"BPR10"}, tran={TransactionType.PAYMENT}, maxWidth=10, minWidth=10, desc={"If provided, should be identical to payerIdentifier"})
    private String originatingCompanyId;
    @Prop(edi={"BPR11,TRN04"}, tran={TransactionType.PAYMENT}, maxWidth=9, minWidth=9)
    private String originatingCompanySupplementalCode;
    @EdiElt(pos=13, seg="BPR", tran={TransactionType.PAYMENT})
    private String receiverBankRoutingNumber;
    @EdiElt(pos=15, seg="BPR", tran={TransactionType.PAYMENT})
    private String receiverAccountNumber;
    @EdiElt(pos=16, seg="BPR", tran={TransactionType.PAYMENT}, isRequired=true)
    private LocalDate paymentDate;
    @Prop(edi={"TRN02"}, tran={TransactionType.PAYMENT}, isRequired=true)
    private String checkOrEftTraceNumber;
    @Prop(edi={"TRN03"}, tran={TransactionType.PAYMENT}, maxWidth=10, minWidth=10, desc={"This must be a 1 followed by the payer's EIN or TIN. This ID will be used as the identifier in the payer object if no other identifier was provided"}, isRequired=true)
    private String payerIdentifier;
    @EdiElt.Exclude
    @Prop(edi={"TRN02"}, tran={TransactionType.CLAIM_ACK})
    private String traceIdentifier;
    @Prop(refType={ReferenceType.RECEIVER_IDENTIFICATION_NUMBER}, tran={TransactionType.PAYMENT}, desc={"Receiver's identifier when different from payee (e.g., a clearinghouse)"})
    private String receiverIdentifier;
    @JsonIgnore
    private LocalDateTime createTimestamp = LocalDateTime.now();
    @EdiElt(pos=1, seg="ST")
    private String transactionSetIdentifierCode;
    @EdiElt(pos=3, seg="ST")
    private String implementationConventionReference;
    @JsonIgnore
    @EdiElt(value={"member_group_or_policy_number"}, seg="REF")
    private String masterPolicyNumber;
    @Prop(objType=ObjType.DATE, tran={TransactionType.MEMBER_COVERAGE})
    private List<DateTimePeriod> fileEffectiveDates;
    @Prop(objType=ObjType.QUANTITY, tran={TransactionType.MEMBER_COVERAGE})
    private List<Quantity> controlTotals;
    @EdiElt.Exclude
    @Prop(dateType={DateType.RECEIVED}, tran={TransactionType.CLAIM_ACK})
    private LocalDate receiptDate;
    @EdiElt.Exclude
    @Prop(dateType={DateType.PROCESS}, tran={TransactionType.CLAIM_ACK})
    private LocalDate processDate;
    @EdiElt.Exclude
    @Transient
    @JsonIgnore
    private EdiSeg seg;
    @Prop(objType=ObjType.FILE_INFO)
    private FileInfo fileInfo;
    @EdiElt.Exclude
    @Prop(desc={"837:Submitter or sender of this transaction", "277:Information source name"}, objType=ObjType.PARTY_ID_NAME, tran={TransactionType.PROF, TransactionType.INST, TransactionType.DENTAL, TransactionType.CLAIM_ACK})
    private OrgOrPerson sender;
    @EdiElt.Exclude
    @Prop(desc={"Receiver of this transaction"}, objType=ObjType.PARTY_ID_NAME, tran={TransactionType.PROF, TransactionType.INST, TransactionType.DENTAL})
    private OrgOrPerson receiver;

    public EdiTransaction(TransactionType transactionType) {
        this.transactionType(transactionType);
        this.setBhtDefaults();
    }

    public EdiTransaction(EdiTransaction other) {
        this.id = other.id;
        this.ediSegs = new ArrayList<EdiSeg>(other.ediSegs);
        this.controlNumber = other.controlNumber;
        this.groupControlNumber = other.groupControlNumber;
        this.transactionType = other.transactionType;
        this.productionDate = other.productionDate;
        this.transactionHandlingType = other.transactionHandlingType;
        this.hierarchicalStructureCode = other.hierarchicalStructureCode;
        this.purposeCode = other.purposeCode;
        this.receiverBankRoutingNumber = other.receiverBankRoutingNumber;
        this.senderBankRoutingNumber = other.senderBankRoutingNumber;
        this.paymentFormatCode = other.paymentFormatCode;
        this.senderAccountNumber = other.senderAccountNumber;
        this.originatingCompanyId = other.originatingCompanyId;
        this.originatingCompanySupplementalCode = other.originatingCompanySupplementalCode;
        this.originatorApplicationTransactionId = other.originatorApplicationTransactionId;
        this.creationDate = other.creationDate;
        this.creationTime = other.creationTime;
        this.claimOrEncounterIdentifierType = other.claimOrEncounterIdentifierType;
        this.originalTransactionSetReferenceNumber = other.originalTransactionSetReferenceNumber;
        this.actionCode = other.actionCode;
        this.totalPaymentAmount = other.totalPaymentAmount;
        this.creditOrDebitFlagCode = other.creditOrDebitFlagCode;
        this.paymentMethodType = other.paymentMethodType;
        this.receiverAccountNumber = other.receiverAccountNumber;
        this.paymentDate = other.paymentDate;
        this.checkOrEftTraceNumber = other.checkOrEftTraceNumber;
        this.payerIdentifier = other.payerIdentifier;
        this.receiverIdentifier = other.receiverIdentifier;
        this.traceIdentifier = other.traceIdentifier;
        this.createTimestamp = other.createTimestamp;
        this.transactionSetIdentifierCode = other.transactionSetIdentifierCode;
        this.implementationConventionReference = other.implementationConventionReference;
        this.masterPolicyNumber = other.masterPolicyNumber;
        this.fileEffectiveDates = other.fileEffectiveDates != null ? new ArrayList<DateTimePeriod>(other.fileEffectiveDates) : null;
        this.controlTotals = other.controlTotals != null ? new ArrayList<Quantity>(other.controlTotals) : null;
        this.receiptDate = other.receiptDate;
        this.processDate = other.processDate;
        this.seg = other.seg != null ? EdiSeg.cloneKeySegInfo(other.seg) : null;
        this.fileInfo = other.fileInfo != null ? new FileInfo(other.fileInfo) : null;
        this.sender = other.sender;
        this.receiver = other.receiver;
    }

    public LocalDateTime getCreationDateTime() {
        if (this.creationDate == null) {
            return null;
        }
        LocalTime timeToUse = this.creationTime;
        if (timeToUse == null) {
            timeToUse = LocalTime.of(0, 0, 0);
        }
        return LocalDateTime.of(this.creationDate, timeToUse);
    }

    @Override
    public void populateFromSegInitial(EdiSeg seg, EdiParsingResults results) {
        mapper.populate(this, seg);
        if (seg.type() == SegmentType.ST) {
            this.transactionType = TransactionType.fromStElements(this.transactionSetIdentifierCode, this.implementationConventionReference);
        }
        if (results != null) {
            this.fileInfo = new FileInfo(results.fileInfo());
            this.fileInfo.fileSource(null);
            this.fileInfo.id(null);
        }
        this.seg = EdiSeg.cloneKeySegInfo(seg);
    }

    @Override
    public void populateFromSeg(EdiSeg seg, EdiParsingResults ediParsingResults) {
        Reference ref;
        EdiEntity ent = seg.entity();
        if (this.seg.isParentOf(seg) && seg.isInType(SegmentType.DTM, SegmentType.BHT, SegmentType.BGN, SegmentType.BPR, SegmentType.TRN, SegmentType.GS, SegmentType.REF)) {
            mapper.populate(this, seg);
        }
        if (this.transactionType == TransactionType.MEMBER_COVERAGE && this.seg.isParentOf(seg) && "0000".equals(seg.loop())) {
            if (ent instanceof DateTimePeriod) {
                DateTimePeriod dt = (DateTimePeriod)ent;
                this.fileEffectiveDates = CollectionUtils.addWithInit(this.fileEffectiveDates, dt);
            } else if (ent instanceof Quantity) {
                Quantity q = (Quantity)ent;
                this.controlTotals = CollectionUtils.addWithInit(this.controlTotals, q);
            }
        } else if ((this.transactionType.isClaim() || this.transactionType == TransactionType.PAYMENT) && seg.isInType(SegmentType.NM1, SegmentType.N1)) {
            if (ent instanceof OrgOrPerson) {
                OrgOrPerson namedEntity = (OrgOrPerson)ent;
                if (StringUtils.startsWithIgnoreCase((CharSequence)seg.loop(), (CharSequence)"1000A")) {
                    this.sender = namedEntity;
                    if (this.payerIdentifier != null && this.transactionType == TransactionType.PAYMENT && this.sender.primaryIdentifier() == null) {
                        this.sender.identifier(this.payerIdentifier);
                        this.sender.identificationType(IdentificationType.PAYOR_ID);
                    }
                } else if (StringUtils.startsWithIgnoreCase((CharSequence)seg.loop(), (CharSequence)"1000B")) {
                    this.receiver = namedEntity;
                }
            }
        } else if (this.transactionType == TransactionType.CLAIM_ACK) {
            if (seg.isInLoop("2100A") && ent instanceof OrgOrPerson) {
                OrgOrPerson party;
                this.sender = party = (OrgOrPerson)ent;
            } else if (seg.isInLoop("2200A")) {
                if (ent instanceof DateTimePeriod) {
                    DateTimePeriod dt = (DateTimePeriod)ent;
                    if (dt.type() == DateType.RECEIVED) {
                        this.receiptDate = dt.date();
                    } else if (dt.type() == DateType.PROCESS) {
                        this.processDate = dt.date();
                    }
                } else if (seg.isInType(SegmentType.TRN) && seg.eltByPosition(2) != null) {
                    this.traceIdentifier = seg.eltByPosition(2).stringVal();
                }
            }
        } else if (this.transactionType == TransactionType.PAYMENT && ent instanceof Reference && (ref = (Reference)ent).type() == ReferenceType.RECEIVER_IDENTIFICATION_NUMBER) {
            this.receiverIdentifier = ref.identification();
        }
    }

    public String ediVersion() {
        if (this.implementationConventionReference != null) {
            return StringUtils.substringBefore((String)this.implementationConventionReference, (String)"X");
        }
        return null;
    }

    public String summaryStringAsParent() {
        String s = "Transaction";
        s = FormattingUtils.concat(s, this.controlNumber, " ");
        s = FormattingUtils.concat(s, "Type:", " ");
        s = FormattingUtils.concat(s, this.transactionType.description(), " ");
        String tranCreateTime = FormattingUtils.formatDateTimeShort(this.getCreationDateTime());
        if (tranCreateTime != null) {
            s = FormattingUtils.concat(s, "Created:", " ");
            s = FormattingUtils.concat(s, tranCreateTime, " ");
        }
        return s;
    }

    public EdiTransaction transactionType(TransactionType transactionType) {
        this.transactionType = transactionType;
        this.transactionSetIdentifierCode = StringUtils.left((String)transactionType.ediCode(), (int)3);
        this.implementationConventionReference = transactionType.implementationConventionReference();
        return this;
    }

    private void setBhtDefaults() {
        this.creationDate = LocalDate.now();
        this.creationTime = LocalTime.now();
        this.hierarchicalStructureCode = "0019";
        this.purposeCode = "00";
        this.claimOrEncounterIdentifierType = ClaimOrEncounterIdentifierType.CHARGEABLE;
        this.originatorApplicationTransactionId = this.id;
    }

    @Generated
    public String id() {
        return this.id;
    }

    @JsonIgnore
    @Generated
    public List<EdiSeg> ediSegs() {
        return this.ediSegs;
    }

    @Generated
    public String controlNumber() {
        return this.controlNumber;
    }

    @Generated
    public String groupControlNumber() {
        return this.groupControlNumber;
    }

    @Generated
    public TransactionType transactionType() {
        return this.transactionType;
    }

    @Generated
    public LocalDate productionDate() {
        return this.productionDate;
    }

    @Generated
    public String hierarchicalStructureCode() {
        return this.hierarchicalStructureCode;
    }

    @Generated
    public String purposeCode() {
        return this.purposeCode;
    }

    @Generated
    public String originatorApplicationTransactionId() {
        return this.originatorApplicationTransactionId;
    }

    @Generated
    public LocalDate creationDate() {
        return this.creationDate;
    }

    @Generated
    public LocalTime creationTime() {
        return this.creationTime;
    }

    @Generated
    public ClaimOrEncounterIdentifierType claimOrEncounterIdentifierType() {
        return this.claimOrEncounterIdentifierType;
    }

    @Generated
    public String originalTransactionSetReferenceNumber() {
        return this.originalTransactionSetReferenceNumber;
    }

    @Generated
    public String actionCode() {
        return this.actionCode;
    }

    @Generated
    public TransactionHandlingType transactionHandlingType() {
        return this.transactionHandlingType;
    }

    @Generated
    public BigDecimal totalPaymentAmount() {
        return this.totalPaymentAmount;
    }

    @Generated
    public String creditOrDebitFlagCode() {
        return this.creditOrDebitFlagCode;
    }

    @Generated
    public PaymentMethodType paymentMethodType() {
        return this.paymentMethodType;
    }

    @Generated
    public String paymentFormatCode() {
        return this.paymentFormatCode;
    }

    @Generated
    public String senderBankRoutingNumber() {
        return this.senderBankRoutingNumber;
    }

    @Generated
    public String senderAccountNumber() {
        return this.senderAccountNumber;
    }

    @Generated
    public String originatingCompanyId() {
        return this.originatingCompanyId;
    }

    @Generated
    public String originatingCompanySupplementalCode() {
        return this.originatingCompanySupplementalCode;
    }

    @Generated
    public String receiverBankRoutingNumber() {
        return this.receiverBankRoutingNumber;
    }

    @Generated
    public String receiverAccountNumber() {
        return this.receiverAccountNumber;
    }

    @Generated
    public LocalDate paymentDate() {
        return this.paymentDate;
    }

    @Generated
    public String checkOrEftTraceNumber() {
        return this.checkOrEftTraceNumber;
    }

    @Generated
    public String payerIdentifier() {
        return this.payerIdentifier;
    }

    @Generated
    public String traceIdentifier() {
        return this.traceIdentifier;
    }

    @Generated
    public String receiverIdentifier() {
        return this.receiverIdentifier;
    }

    @JsonIgnore
    @Generated
    public LocalDateTime createTimestamp() {
        return this.createTimestamp;
    }

    @Generated
    public String transactionSetIdentifierCode() {
        return this.transactionSetIdentifierCode;
    }

    @Generated
    public String implementationConventionReference() {
        return this.implementationConventionReference;
    }

    @JsonIgnore
    @Generated
    public String masterPolicyNumber() {
        return this.masterPolicyNumber;
    }

    @Generated
    public List<DateTimePeriod> fileEffectiveDates() {
        return this.fileEffectiveDates;
    }

    @Generated
    public List<Quantity> controlTotals() {
        return this.controlTotals;
    }

    @Generated
    public LocalDate receiptDate() {
        return this.receiptDate;
    }

    @Generated
    public LocalDate processDate() {
        return this.processDate;
    }

    @JsonIgnore
    @Generated
    public EdiSeg seg() {
        return this.seg;
    }

    @Generated
    public FileInfo fileInfo() {
        return this.fileInfo;
    }

    @Generated
    public OrgOrPerson sender() {
        return this.sender;
    }

    @Generated
    public OrgOrPerson receiver() {
        return this.receiver;
    }

    @Generated
    public EdiTransaction controlNumber(String controlNumber) {
        this.controlNumber = controlNumber;
        return this;
    }

    @Generated
    public EdiTransaction groupControlNumber(String groupControlNumber) {
        this.groupControlNumber = groupControlNumber;
        return this;
    }

    @Generated
    public EdiTransaction productionDate(LocalDate productionDate) {
        this.productionDate = productionDate;
        return this;
    }

    @Generated
    public EdiTransaction hierarchicalStructureCode(String hierarchicalStructureCode) {
        this.hierarchicalStructureCode = hierarchicalStructureCode;
        return this;
    }

    @Generated
    public EdiTransaction purposeCode(String purposeCode) {
        this.purposeCode = purposeCode;
        return this;
    }

    @Generated
    public EdiTransaction originatorApplicationTransactionId(String originatorApplicationTransactionId) {
        this.originatorApplicationTransactionId = originatorApplicationTransactionId;
        return this;
    }

    @Generated
    public EdiTransaction creationDate(LocalDate creationDate) {
        this.creationDate = creationDate;
        return this;
    }

    @Generated
    public EdiTransaction creationTime(LocalTime creationTime) {
        this.creationTime = creationTime;
        return this;
    }

    @Generated
    public EdiTransaction claimOrEncounterIdentifierType(ClaimOrEncounterIdentifierType claimOrEncounterIdentifierType) {
        this.claimOrEncounterIdentifierType = claimOrEncounterIdentifierType;
        return this;
    }

    @Generated
    public EdiTransaction originalTransactionSetReferenceNumber(String originalTransactionSetReferenceNumber) {
        this.originalTransactionSetReferenceNumber = originalTransactionSetReferenceNumber;
        return this;
    }

    @Generated
    public EdiTransaction actionCode(String actionCode) {
        this.actionCode = actionCode;
        return this;
    }

    @Generated
    public EdiTransaction transactionHandlingType(TransactionHandlingType transactionHandlingType) {
        this.transactionHandlingType = transactionHandlingType;
        return this;
    }

    @Generated
    public EdiTransaction totalPaymentAmount(BigDecimal totalPaymentAmount) {
        this.totalPaymentAmount = totalPaymentAmount;
        return this;
    }

    @Generated
    public EdiTransaction creditOrDebitFlagCode(String creditOrDebitFlagCode) {
        this.creditOrDebitFlagCode = creditOrDebitFlagCode;
        return this;
    }

    @Generated
    public EdiTransaction paymentMethodType(PaymentMethodType paymentMethodType) {
        this.paymentMethodType = paymentMethodType;
        return this;
    }

    @Generated
    public EdiTransaction paymentFormatCode(String paymentFormatCode) {
        this.paymentFormatCode = paymentFormatCode;
        return this;
    }

    @Generated
    public EdiTransaction senderBankRoutingNumber(String senderBankRoutingNumber) {
        this.senderBankRoutingNumber = senderBankRoutingNumber;
        return this;
    }

    @Generated
    public EdiTransaction senderAccountNumber(String senderAccountNumber) {
        this.senderAccountNumber = senderAccountNumber;
        return this;
    }

    @Generated
    public EdiTransaction originatingCompanyId(String originatingCompanyId) {
        this.originatingCompanyId = originatingCompanyId;
        return this;
    }

    @Generated
    public EdiTransaction originatingCompanySupplementalCode(String originatingCompanySupplementalCode) {
        this.originatingCompanySupplementalCode = originatingCompanySupplementalCode;
        return this;
    }

    @Generated
    public EdiTransaction receiverBankRoutingNumber(String receiverBankRoutingNumber) {
        this.receiverBankRoutingNumber = receiverBankRoutingNumber;
        return this;
    }

    @Generated
    public EdiTransaction receiverAccountNumber(String receiverAccountNumber) {
        this.receiverAccountNumber = receiverAccountNumber;
        return this;
    }

    @Generated
    public EdiTransaction paymentDate(LocalDate paymentDate) {
        this.paymentDate = paymentDate;
        return this;
    }

    @Generated
    public EdiTransaction checkOrEftTraceNumber(String checkOrEftTraceNumber) {
        this.checkOrEftTraceNumber = checkOrEftTraceNumber;
        return this;
    }

    @Generated
    public EdiTransaction payerIdentifier(String payerIdentifier) {
        this.payerIdentifier = payerIdentifier;
        return this;
    }

    @Generated
    public EdiTransaction traceIdentifier(String traceIdentifier) {
        this.traceIdentifier = traceIdentifier;
        return this;
    }

    @Generated
    public EdiTransaction receiverIdentifier(String receiverIdentifier) {
        this.receiverIdentifier = receiverIdentifier;
        return this;
    }

    @JsonIgnore
    @Generated
    public EdiTransaction createTimestamp(LocalDateTime createTimestamp) {
        this.createTimestamp = createTimestamp;
        return this;
    }

    @JsonIgnore
    @Generated
    public EdiTransaction masterPolicyNumber(String masterPolicyNumber) {
        this.masterPolicyNumber = masterPolicyNumber;
        return this;
    }

    @Generated
    public EdiTransaction fileEffectiveDates(List<DateTimePeriod> fileEffectiveDates) {
        this.fileEffectiveDates = fileEffectiveDates;
        return this;
    }

    @Generated
    public EdiTransaction controlTotals(List<Quantity> controlTotals) {
        this.controlTotals = controlTotals;
        return this;
    }

    @Generated
    public EdiTransaction receiptDate(LocalDate receiptDate) {
        this.receiptDate = receiptDate;
        return this;
    }

    @Generated
    public EdiTransaction processDate(LocalDate processDate) {
        this.processDate = processDate;
        return this;
    }

    @JsonIgnore
    @Generated
    public EdiTransaction seg(EdiSeg seg) {
        this.seg = seg;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EdiTransaction)) {
            return false;
        }
        EdiTransaction other = (EdiTransaction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.id();
        String other$id = other.id();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$controlNumber = this.controlNumber();
        String other$controlNumber = other.controlNumber();
        if (this$controlNumber == null ? other$controlNumber != null : !this$controlNumber.equals(other$controlNumber)) {
            return false;
        }
        TransactionType this$transactionType = this.transactionType();
        TransactionType other$transactionType = other.transactionType();
        return !(this$transactionType == null ? other$transactionType != null : !((Object)((Object)this$transactionType)).equals((Object)other$transactionType));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EdiTransaction;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.id();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $controlNumber = this.controlNumber();
        result = result * 59 + ($controlNumber == null ? 43 : $controlNumber.hashCode());
        TransactionType $transactionType = this.transactionType();
        result = result * 59 + ($transactionType == null ? 43 : ((Object)((Object)$transactionType)).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "EdiTransaction(id=" + this.id() + ", controlNumber=" + this.controlNumber() + ", groupControlNumber=" + this.groupControlNumber() + ", transactionType=" + String.valueOf((Object)this.transactionType()) + ", productionDate=" + String.valueOf(this.productionDate()) + ", hierarchicalStructureCode=" + this.hierarchicalStructureCode() + ", purposeCode=" + this.purposeCode() + ", originatorApplicationTransactionId=" + this.originatorApplicationTransactionId() + ", claimOrEncounterIdentifierType=" + String.valueOf(this.claimOrEncounterIdentifierType()) + ", originalTransactionSetReferenceNumber=" + this.originalTransactionSetReferenceNumber() + ", actionCode=" + this.actionCode() + ", transactionHandlingType=" + String.valueOf(this.transactionHandlingType()) + ", totalPaymentAmount=" + String.valueOf(this.totalPaymentAmount()) + ", creditOrDebitFlagCode=" + this.creditOrDebitFlagCode() + ", paymentMethodType=" + String.valueOf(this.paymentMethodType()) + ", paymentFormatCode=" + this.paymentFormatCode() + ", senderBankRoutingNumber=" + this.senderBankRoutingNumber() + ", senderAccountNumber=" + this.senderAccountNumber() + ", originatingCompanyId=" + this.originatingCompanyId() + ", originatingCompanySupplementalCode=" + this.originatingCompanySupplementalCode() + ", receiverBankRoutingNumber=" + this.receiverBankRoutingNumber() + ", receiverAccountNumber=" + this.receiverAccountNumber() + ", paymentDate=" + String.valueOf(this.paymentDate()) + ", checkOrEftTraceNumber=" + this.checkOrEftTraceNumber() + ", payerIdentifier=" + this.payerIdentifier() + ", traceIdentifier=" + this.traceIdentifier() + ", receiverIdentifier=" + this.receiverIdentifier() + ", createTimestamp=" + String.valueOf(this.createTimestamp()) + ", transactionSetIdentifierCode=" + this.transactionSetIdentifierCode() + ", implementationConventionReference=" + this.implementationConventionReference() + ", masterPolicyNumber=" + this.masterPolicyNumber() + ", fileEffectiveDates=" + String.valueOf(this.fileEffectiveDates()) + ", controlTotals=" + String.valueOf(this.controlTotals()) + ", receiptDate=" + String.valueOf(this.receiptDate()) + ", processDate=" + String.valueOf(this.processDate()) + ", fileInfo=" + String.valueOf(this.fileInfo()) + ", sender=" + String.valueOf(this.sender()) + ", receiver=" + String.valueOf(this.receiver()) + ", getCreationDateTime=" + String.valueOf(this.getCreationDateTime()) + ")";
    }

    @Generated
    public EdiTransaction() {
    }

    @Generated
    public EdiTransaction id(String id) {
        this.id = id;
        return this;
    }

    @JsonIgnore
    @Generated
    public EdiTransaction ediSegs(List<EdiSeg> ediSegs) {
        this.ediSegs = ediSegs;
        return this;
    }

    @Generated
    public EdiTransaction transactionSetIdentifierCode(String transactionSetIdentifierCode) {
        this.transactionSetIdentifierCode = transactionSetIdentifierCode;
        return this;
    }

    @Generated
    public EdiTransaction implementationConventionReference(String implementationConventionReference) {
        this.implementationConventionReference = implementationConventionReference;
        return this;
    }

    @Generated
    public EdiTransaction fileInfo(FileInfo fileInfo) {
        this.fileInfo = fileInfo;
        return this;
    }

    @Generated
    public EdiTransaction sender(OrgOrPerson sender) {
        this.sender = sender;
        return this;
    }

    @Generated
    public EdiTransaction receiver(OrgOrPerson receiver) {
        this.receiver = receiver;
        return this;
    }
}

