/*
 * Decompiled with CFR 0.152.
 */
package hdi.edi.cli;

import hdi.edi.cli.CliException;
import hdi.edi.cli.CliVersionProvider;
import hdi.edi.cli.PrintExceptionMessageHandler;
import hdi.edi.converter.EdiFileConverter;
import hdi.edi.converter.NamedWriter;
import hdi.edi.converter.OutputFormat;
import hdi.edi.parser.TransactionType;
import hdi.license.CliLicenseReader;
import java.io.File;
import java.util.Arrays;
import java.util.concurrent.Callable;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="ediconvert", mixinStandardHelpOptions=true, sortOptions=false, usageHelpAutoWidth=true, versionProvider=CliVersionProvider.class, footer={"\nSee https://datainsight.health/docs/ediconvert-cli for more details"}, description={"Converts X12 EDI files to JSON or CSV"})
public class CliMain
implements Callable<Integer> {
    private final CliLicenseReader licenseReader = new CliLicenseReader();
    @CommandLine.Parameters(index="0", paramLabel="EDI File or Directory", description={"X12 EDI file or a directory (folder) containing X12 EDI files. It can contain '*' and '?' wildcards to match multiple files. Enclose in single quotes on Windows or '\"' on Linux if using wildcards."})
    private String ediFileOrDir;
    @CommandLine.Option(names={"-p", "--patterns"}, description={"File name patterns to match in the directory, e.g., '*.edi'. You can specify multiple comma-delimited patterns, e.g., '*837*.edi, *837*.txt'. Defaults to '*' (all files) if 'EDI File or Directory' is a directory. Enclose in single quotes on Windows or '\"' on Linux."})
    private String filePatterns;
    @CommandLine.Option(names={"-r", "--recurse"}, description={"Recursively search for matching files in all subdirectories"})
    private boolean isRecursive;
    @CommandLine.Option(names={"-o", "--out"}, description={"Output file or existing directory where to save output files. The file will be created if it doesn't exist. For a directory, the output file name will be the EDI file name plus the extension, depending on the output format. If omitted, the converter will output to the console (standard out), which can be piped or streamed."})
    private File outFile;
    @CommandLine.Option(names={"-m", "--mode"}, description={"Output format. Acceptable values: ${COMPLETION-CANDIDATES}. Defaults to '${DEFAULT-VALUE}'."}, defaultValue="json")
    private OutputFormat outputFormat;
    @CommandLine.Option(names={"-l", "--jsonl", "--ndjson"}, description={"Use JSON lines a.k.a. NDJSON (https://github.com/ndjson/ndjson-spec). There is no enclosing array. Instead, each JSON object is terminated by a new line. Use it for large files or for streaming. If not set, the resulting file can contain a large array of JSON objects."}, hidden=true)
    private boolean isJsonLines;
    @CommandLine.Option(names={"-s", "--csv"}, description={"Convert to CSV format (JSON is the default)"}, hidden=true)
    private boolean isCsv;
    @CommandLine.Option(names={"--format-json"}, description={"Format JSON with indentation and new lines. Ignored for CSV and JSONL."})
    private boolean formatJson;
    @CommandLine.Option(names={"--out-parsing-warnings"}, description={"Write EDI parsing warnings to the output file as 'warning' objects. If not set, parsing warnings are written to the log and standard output. See https://datainsight.health/docs/ediconvert-api/user-guide/#error-handling for more details."})
    private boolean isSerializeParsingWarnings;
    @CommandLine.Option(names={"--max-warnings"}, description={"The maximum number of parsing warnings per file before stopping and raising an error. Defaults to 100. Set to -1 to suppress raising the 'too many warnings' error; the converter will process the entire file."})
    private Integer maxWarnings;
    @CommandLine.Option(names={"--chunk-size"}, description={"The number of EDI transactions or claims/payments/members for 837/835/834 that will be parsed and converted at once. This option determines the memory footprint and can be used for fine-tuning. Defaults to 50. Higher value improves performance but consumes more memory."})
    private Integer chunkSize;
    @CommandLine.Option(names={"--split-tran"}, description={"Do not parse the entire transaction. Instead, parse by claims (CLM or CLP segments, 837/835) or members (INS segment, 834). This is the default for 835, 837, and 835 transactions, which can be large. Ignored for all other transaction types. Defaults to 'true'"}, negatable=true, defaultValue="true", fallbackValue="true")
    private boolean isSplitMode;
    @CommandLine.Option(names={"--progress-chunk-size"}, description={"How often to log progress. By default, the conversion progress is logged every 1000 items (claims, members, transactions)"})
    private Integer loggingChunkSize;
    @CommandLine.Option(names={"-q", "--quiet", "--suppress-progress"}, description={"Suppress logging file names and conversion progress to the console; use this option when converting to standard out"})
    private boolean isSuppressShowProgress = false;
    @CommandLine.Option(names={"--out-segments"}, description={"Convert to the X12 EDI loop and segment tree instead of the list of claims, payments, and other objects. JSON or JSONL only. It can be slow for large transactions."})
    private boolean asSegments = false;
    @CommandLine.ArgGroup(validate=false, heading="Options for CSV conversion:%n")
    private CsvOptions csvOptions;
    static boolean isSuppressExitForTesting;
    static int lastExitCode;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer call() {
        this.licenseReader.checkLicense();
        if (this.isCsv) {
            this.outputFormat = OutputFormat.CSV;
        }
        if (this.isJsonLines) {
            this.outputFormat = OutputFormat.JSONL;
        }
        if (!this.outputFormat.isCsvOrExcel() && this.asSegments) {
            this.isSplitMode = false;
        }
        EdiFileConverter converter = new EdiFileConverter(this.outputFormat).isFormatJson(this.formatJson).isSplitMode(this.isSplitMode).isShowProgress(!this.isSuppressShowProgress).isSerializeParsingIssues(this.isSerializeParsingWarnings).asSegments(this.asSegments);
        if (this.chunkSize != null) {
            converter.chunkSize(this.chunkSize);
        }
        if (this.loggingChunkSize != null) {
            converter.loggingChunkSize(this.loggingChunkSize);
        }
        if (this.maxWarnings != null) {
            converter.maxNumberOfIssues(this.maxWarnings);
        }
        String schemaName = null;
        boolean isSingleCsv = false;
        if (this.csvOptions != null) {
            if (!this.outputFormat.isCsvOrExcel()) {
                throw new CliException("You can specify CSV-specific options, such as --csv-schema-name and --single-csv only when the output format is CSV or Excel. You entered: %s", new Object[]{this.outputFormat});
            }
            converter.csvConversionSchemaFileName(this.csvOptions.csvConversionSchemaFileName);
            schemaName = this.csvOptions.csvConversionSchemaName;
            isSingleCsv = this.csvOptions.isSingleCsv;
        }
        NamedWriter stdOut = null;
        if (this.outFile == null) {
            stdOut = NamedWriter.stdOut();
            if (schemaName == null) {
                schemaName = "lines-with-header-repeat-first-row";
            }
        }
        if (schemaName == null) {
            schemaName = isSingleCsv ? "lines-with-header-repeat-first-row" : "default";
        }
        converter.csvConversionSchemaName(schemaName);
        if (this.csvOptions != null && StringUtils.isNotBlank((CharSequence)this.csvOptions.transactionTypeFilter)) {
            converter.transactionTypeFilter(this.getTransactionTypeFilter(this.csvOptions.transactionTypeFilter));
        }
        File ediFileOrDirFile = new File(this.unquote(this.ediFileOrDir));
        this.filePatterns = this.unquote(this.filePatterns);
        try {
            converter.convertFiles(ediFileOrDirFile, this.filePatterns, this.isRecursive, this.outFile, stdOut);
        }
        finally {
            if (stdOut != null) {
                stdOut.writer().flush();
            }
        }
        return 0;
    }

    private String unquote(String ediFileOrDir) {
        ediFileOrDir = StringUtils.strip((String)ediFileOrDir);
        ediFileOrDir = StringUtils.strip((String)ediFileOrDir, (String)"\"'");
        return ediFileOrDir;
    }

    private TransactionType getTransactionTypeFilter(String transactionTypeFilter) {
        TransactionType tranType = TransactionType.fromEdiCode(transactionTypeFilter);
        if (tranType == null || !tranType.isCsvSupported()) {
            throw new CliException("You can only specify %s as the values for the '--tran-type' option. You entered: %s ", TransactionType.getListOfCsvSupportedEdiCodes(), transactionTypeFilter);
        }
        return tranType;
    }

    public static void main(String[] args) {
        int exitCode;
        Logger log = LoggerFactory.getLogger(CliMain.class);
        log.debug("** Starting EDI converter with the following command line parameters:\n {}", Arrays.asList(args));
        lastExitCode = exitCode = new CommandLine((Object)new CliMain()).setExecutionExceptionHandler((CommandLine.IExecutionExceptionHandler)new PrintExceptionMessageHandler()).setCaseInsensitiveEnumValuesAllowed(true).execute(args);
        if (exitCode != 0 && !isSuppressExitForTesting) {
            System.exit(exitCode);
        }
    }

    static {
        System.setProperty("logback.configurationFile", "logback-cli.xml");
    }

    static class CsvOptions {
        @CommandLine.Option(names={"--csv-schema-name"}, description={"Name of the 'schema' (configuration) in the CSV config file, such as 'key-fields'. The schema determines the layout of the CSV file. See https://datainsight.health/docs/csv/schemas for the list of schemas."})
        private String csvConversionSchemaName;
        @CommandLine.Option(names={"--csv-config", "--csv-schema-file"}, description={"Name of the file containing CSV conversion schemas in the 'conf' directory. Defaults to 'conf/csv_conversion.yaml'."})
        private String csvConversionSchemaFileName;
        @CommandLine.Option(names={"--tran-type"}, description={"Convert only the files that contain transactions of this type. All other files will be ignored. Acceptable values: 835, 837P, 837I, 837D, 834."})
        private String transactionTypeFilter;
        @CommandLine.Option(names={"--single-csv"}, description={"Convert all EDI files into a single CSV file containing the claim-level and the service line-level fields (837/835). If not provided, the converter will convert claim-level and line-level data into separate files. Same as providing '--csv-schema-name=single-file'. A single file is the default for 834."})
        private boolean isSingleCsv;

        CsvOptions() {
        }
    }
}

