/*
 * Decompiled with CFR 0.152.
 */
package hdi.edi.cli;

import hdi.license.CliLicenseReader;
import hdi.license.LicenseInfo;
import java.util.ArrayList;
import picocli.CommandLine;

public class CliVersionProvider
implements CommandLine.IVersionProvider {
    private final CliLicenseReader licenseReader = new CliLicenseReader();

    public String[] getVersion() {
        ArrayList<Object> infoLines = new ArrayList<Object>();
        String version = CliVersionProvider.class.getPackage().getImplementationVersion();
        if (version == null) {
            version = "Unknown";
        }
        infoLines.add("${COMMAND-FULL-NAME} " + version);
        LicenseInfo licenseInfo = this.licenseReader.readLicense();
        Object licenseInfoStr = licenseInfo == null ? "License file not found!" : (licenseInfo.isExpired() ? "License expired on " + String.valueOf(licenseInfo.expiration()) + "! Request your license at https://datainsight.health/products/license-request" : "License expires on " + String.valueOf(licenseInfo.expiration()) + " in " + licenseInfo.expirationInDays() + " days");
        infoLines.add(licenseInfoStr);
        if (licenseInfo != null && licenseInfo.licenseFile() != null) {
            String licenseFileStr = "License file: " + licenseInfo.licenseFile().getPath();
            infoLines.add(licenseFileStr);
        }
        return infoLines.toArray(new String[0]);
    }
}

