/*
 * Decompiled with CFR 0.152.
 */
package hdi.edi.converter;

import com.fasterxml.jackson.databind.JsonNode;
import hdi.edi.cli.CliException;
import hdi.edi.codecollector.CodeEntityResolver;
import hdi.edi.converter.ClaimPaymentParsingState;
import hdi.edi.converter.JsonObjectSerializer;
import hdi.edi.converter.NamedWriter;
import hdi.edi.converter.OutputFormat;
import hdi.edi.csv.CsvConversionContext;
import hdi.edi.csv.CsvConversionException;
import hdi.edi.csv.CsvConverter;
import hdi.edi.csv.SchemaHolder;
import hdi.edi.fileinfo.FileInfo;
import hdi.edi.legacyparser.LegacyEdiParser;
import hdi.edi.parser.EdiParser;
import hdi.edi.parser.EdiParserException;
import hdi.edi.parser.EdiParsingResults;
import hdi.edi.parser.ParsingIssue;
import hdi.edi.parser.TransactionType;
import hdi.model.ErrorInfo;
import hdi.model.RootObjContainer;
import hdi.util.FileScanner;
import hdi.util.FilesUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EdiFileConverter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EdiFileConverter.class);
    public static final int DEFAULT_CHUNK_SIZE_TRAN = 20;
    public static final int DEFAULT_CHUNK_SIZE_SPLIT = 50;
    public static final int DEFAULT_LOGGING_CHUNK_SIZE = 1000;
    public static final String CLI_FILE_ONLY_LOGGER = "hdi.edi.converter.CliFileOnlyLogger";
    private int chunkSize = 0;
    private int loggingChunkSize = 1000;
    private int logEveryNChunks;
    private int maxOutputLines = 10000;
    private final OutputFormat outputFormat;
    private boolean isSplitMode = true;
    private boolean isFormatJson = false;
    private boolean isShowProgress = true;
    private boolean isSerializeParsingIssues = false;
    private int maxNumberOfIssues = 100;
    private boolean asSegments = false;
    private boolean isSerializeTransactions = false;
    private SchemaHolder schemaHolder;
    private String csvConversionSchemaFileName;
    private String csvConversionSchemaName;
    private CsvConversionContext conversionContext;
    private final List<String> csvListNames = List.of();
    private CodeEntityResolver codeResolver;
    private Logger cliLogger = LoggerFactory.getLogger(EdiFileConverter.class);
    private TransactionType transactionTypeFilter;
    private int chunkI = 0;

    public EdiFileConverter(OutputFormat outputFormat) {
        this.outputFormat = outputFormat;
    }

    public String convertFileToString(File ediFile) {
        StringWriter writer = new StringWriter();
        this.convertFile(ediFile, new NamedWriter(writer));
        return writer.toString();
    }

    public void convertFile(File ediFile, File outFileOrDir) {
        this.convertFiles(ediFile, null, false, outFileOrDir, null);
    }

    public void convertFile(File ediFile, NamedWriter namedWriter) {
        this.convertFiles(ediFile, null, false, null, namedWriter);
    }

    public void convertFiles(File ediFileOrDir, String patterns, boolean isRecursive, File outFileOrDir) {
        this.convertFiles(ediFileOrDir, patterns, isRecursive, outFileOrDir, null);
    }

    public void convertFiles(File ediFileOrDir, String patterns, boolean isRecursive, NamedWriter namedWriter) {
        this.convertFiles(ediFileOrDir, patterns, isRecursive, null, namedWriter);
    }

    public void convertFiles(File ediFileOrDir, String patterns, boolean isRecursive, File outFileOrDir, NamedWriter namedWriter) {
        Collection<File> files;
        if (outFileOrDir == null && namedWriter == null) {
            throw new IllegalArgumentException("You must provide output file or writer");
        }
        if (outFileOrDir == null && this.outputFormat == OutputFormat.EXCEL) {
            throw new CsvConversionException("You must provide output file when converting to Excel.", new Object[0]);
        }
        this.setDefaultChunkSizeIfNeeded();
        FilesUtils.DirAndPatterns dirAndPatterns = FilesUtils.inferPatternsFromInputFileOrDir(ediFileOrDir);
        if (dirAndPatterns != null) {
            ediFileOrDir = dirAndPatterns.dir();
            patterns = dirAndPatterns.patterns();
        }
        if (!ediFileOrDir.exists()) {
            throw new CliException("File or directory %s does not exist", ediFileOrDir.getAbsolutePath());
        }
        if (StringUtils.isBlank((CharSequence)patterns) && ediFileOrDir.isDirectory()) {
            patterns = "*";
        }
        if (!this.isShowProgress) {
            LegacyEdiParser.parsingIssuesLogger = this.cliLogger = LoggerFactory.getLogger((String)CLI_FILE_ONLY_LOGGER);
        }
        if (StringUtils.isNotBlank((CharSequence)patterns)) {
            if (!ediFileOrDir.isDirectory()) {
                throw new CliException("You must provide directory when specifying patterns. You provided path to the file: %s", ediFileOrDir.getAbsolutePath());
            }
            this.cliLogger.info("Scanning '{}' for files matching '{}'", (Object)ediFileOrDir.getPath(), (Object)patterns);
            files = FileScanner.scanFiles(ediFileOrDir.getAbsolutePath(), patterns, isRecursive);
            if (files.isEmpty()) {
                throw new CliException("Did not file any files matching '%s' in '%s'", patterns, ediFileOrDir.getAbsolutePath());
            }
        } else {
            files = List.of(ediFileOrDir);
        }
        if (this.outputFormat.isCsvOrExcel()) {
            this.convertFilesToCsv(files, outFileOrDir, namedWriter);
        } else {
            this.convertFilesToJson(files, outFileOrDir, namedWriter);
        }
    }

    private void setDefaultChunkSizeIfNeeded() {
        this.chunkSize = this.chunkSize();
        this.logEveryNChunks = this.chunkSize >= this.loggingChunkSize ? 1 : this.loggingChunkSize / this.chunkSize;
    }

    public int chunkSize() {
        int effectiveChunkSize = this.chunkSize;
        if (effectiveChunkSize == 0) {
            effectiveChunkSize = this.isSplitMode ? 50 : 20;
        }
        return effectiveChunkSize;
    }

    public void convertFilesToCsv(Collection<File> ediFiles, File outFileOrDir, NamedWriter namedWriter) {
        this.setDefaultChunkSizeIfNeeded();
        if (this.schemaHolder == null) {
            this.schemaHolder = this.csvConversionSchemaFileName == null ? SchemaHolder.loadSchemas() : SchemaHolder.loadSchemas(this.csvConversionSchemaFileName);
        }
        if (this.csvConversionSchemaName == null) {
            this.csvConversionSchemaName = namedWriter != null ? "lines-with-header-repeat-first-row" : "default";
        }
        if (this.isSingleOutput(outFileOrDir)) {
            if (namedWriter != null) {
                this.conversionContext = new CsvConversionContext(null, namedWriter.writer(), this.csvListNames, this.csvConversionSchemaName);
            } else {
                File outFile = this.determineOutputFile(ediFiles.iterator().next(), outFileOrDir);
                this.conversionContext = new CsvConversionContext(outFile, null, this.csvListNames, this.csvConversionSchemaName);
            }
            this.logStartCsvConversion(ediFiles, outFileOrDir, namedWriter);
            this.performCsvConversion(ediFiles, outFileOrDir, namedWriter);
        } else {
            if (!outFileOrDir.isDirectory()) {
                throw new CliException("The output must be an existing directory when converting to %s. You provided: %s", new Object[]{this.outputFormat, outFileOrDir.getAbsolutePath()});
            }
            this.logStartCsvConversion(ediFiles, outFileOrDir, namedWriter);
            for (File ediFile : ediFiles) {
                File outFile = this.determineOutputFile(ediFile, outFileOrDir);
                this.conversionContext = new CsvConversionContext(outFile, null, this.csvListNames, this.csvConversionSchemaName);
                this.performCsvConversion(List.of(ediFile), outFile, null);
            }
        }
    }

    private void logStartCsvConversion(Collection<File> ediFiles, File outFileOrDir, NamedWriter namedWriter) {
        this.cliLogger.info("Converting {} file(s) to {} using '{}' schema", new Object[]{ediFiles.size(), this.getDestinationStringForLogging(outFileOrDir, namedWriter), this.csvConversionSchemaName});
    }

    private String getDestinationStringForLogging(File outFileOrDir, NamedWriter namedWriter) {
        return outFileOrDir != null ? outFileOrDir.getPath() : namedWriter.name();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performCsvConversion(Collection<File> ediFiles, File outFileOrDir, NamedWriter namedWriter) throws IOException {
        StopWatch sw = StopWatch.createStarted();
        RootObjContainer claimPaymentContainer = new RootObjContainer();
        try {
            if (ediFiles.size() == 1) {
                this.cliLogger.info("Converting {} to {}", (Object)ediFiles.iterator().next().getPath(), (Object)this.getDestinationStringForLogging(outFileOrDir, namedWriter));
            }
            this.cliLogger.debug("Conversion schema file: {}", (Object)this.schemaHolder.schemaFile().getPath());
            for (File ediFile : ediFiles) {
                if (ediFiles.size() > 1) {
                    this.logStartFileProcessing(ediFile);
                }
                claimPaymentContainer.clearWithCounts();
                this.convertFileToCsv(ediFile, this.conversionContext, claimPaymentContainer);
                this.logProcessedFile(claimPaymentContainer.counts(), ediFile, sw);
            }
        }
        finally {
            if (this.conversionContext.converter() != null) {
                this.conversionContext.converter().outputMgr().close();
            }
        }
    }

    private void convertFileToCsv(File ediFile, CsvConversionContext conversionContext, RootObjContainer rootEntityContainer) {
        int chunkI = 0;
        CsvConverter converter = conversionContext.converter();
        try (EdiParser ediParser = new EdiParser(ediFile).isSplitMode(this.isSplitMode).maxNumberOfIssues(this.maxNumberOfIssues);){
            boolean isDone;
            do {
                ClaimPaymentParsingState state = this.parseChunk(rootEntityContainer, ediParser, this.chunkSize);
                isDone = state.isDone();
                if (state.rootEntityContainer().isEmpty()) continue;
                if (chunkI == 0) {
                    TransactionType fileTransactionType = rootEntityContainer.getRootEntityTransactionType();
                    if (this.transactionTypeFilter != null && this.transactionTypeFilter != fileTransactionType) {
                        this.cliLogger.info("File {} contains transactions of type {}, skipping because of the transaction filter {}", new Object[]{ediFile.getName(), fileTransactionType.ediCode(), this.transactionTypeFilter.ediCode()});
                        rootEntityContainer.clearWithCounts();
                        return;
                    }
                    if (converter == null) {
                        TransactionType transactionType = rootEntityContainer.getRootEntityTransactionType();
                        converter = conversionContext.initConverter(this.schemaHolder, this.outputFormat, transactionType);
                    }
                    if (fileTransactionType != converter.schema().transactionTypeInUse()) {
                        this.cliLogger.warn("File {} contains transactions of type {}, but previous files contained {}. Skipping this file", new Object[]{ediFile.getName(), fileTransactionType.ediCode(), converter.schema().transactionTypeInUse().ediCode()});
                        rootEntityContainer.clearWithCounts();
                        return;
                    }
                }
                this.convertChunkToCsv(rootEntityContainer, conversionContext);
                this.logProcessedChunk(rootEntityContainer.counts());
                ++chunkI;
            } while (!isDone);
            if (!rootEntityContainer.isEmpty() && converter != null) {
                this.convertChunkToCsv(rootEntityContainer, conversionContext);
            }
        }
    }

    private void convertChunkToCsv(RootObjContainer rootEntityContainer, CsvConversionContext conversionContext) {
        conversionContext.converter().convert(rootEntityContainer.getOneOfRootEntities());
        if (this.isSerializeParsingIssues && rootEntityContainer.containsParsingIssues()) {
            this.convertParsingIssuesToCsv(conversionContext, rootEntityContainer);
        }
        rootEntityContainer.clear();
    }

    private void convertParsingIssuesToCsv(CsvConversionContext conversionContext, RootObjContainer rootEntityContainer) {
        if (conversionContext != null && conversionContext.converter() != null && conversionContext.converter().outputMgr() != null) {
            String listName = conversionContext.converter().schema().getListNamesForOutput().get(0);
            for (ParsingIssue parsingIssue : rootEntityContainer.parsingIssues()) {
                conversionContext.converter().outputMgr().writeRow(listName, List.of(parsingIssue.toFormattedStringForCsv()));
            }
        } else {
            log.warn("Conversion context or outputMgr is null, unable to serialize parsing issues to CSV.");
        }
    }

    public void convertFilesToJson(Collection<File> ediFiles, File outFileOrDir, NamedWriter providedNamedWriter) {
        block28: {
            this.setDefaultChunkSizeIfNeeded();
            if (this.isSingleOutput(outFileOrDir)) {
                try (NamedWriter nameAndWriter = this.openOutputForJson(null, outFileOrDir, providedNamedWriter);
                     JsonObjectSerializer serializer = new JsonObjectSerializer(nameAndWriter.writer(), this.outputFormat == OutputFormat.JSONL, this.isFormatJson);){
                    RootObjContainer rootObjContainer = new RootObjContainer();
                    this.cliLogger.info("Converting {} file(s) to {}", (Object)ediFiles.size(), (Object)nameAndWriter.name());
                    serializer.writeStart();
                    for (File ediFile : ediFiles) {
                        StopWatch sw = StopWatch.createStarted();
                        EdiParser ediParser = this.createEdiParser(ediFile);
                        try {
                            ClaimPaymentParsingState state;
                            boolean isDone;
                            this.logStartFileProcessing(ediFile);
                            rootObjContainer.clearWithCounts();
                            while (!(isDone = (state = this.parseChunkForJson(rootObjContainer, ediParser, this.chunkSize, serializer)).isDone())) {
                            }
                            if (!rootObjContainer.isEmpty()) {
                                this.serialize(rootObjContainer, serializer);
                            }
                            this.logProcessedFile(rootObjContainer.counts(), ediFile, sw);
                            rootObjContainer.clearCounts();
                        }
                        finally {
                            if (ediParser == null) continue;
                            ediParser.close();
                        }
                    }
                    serializer.writeEnd();
                    break block28;
                }
            }
            for (File ediFile : ediFiles) {
                NamedWriter nameAndWriter = this.openOutputForJson(ediFile, outFileOrDir, providedNamedWriter);
                try {
                    StopWatch sw = StopWatch.createStarted();
                    this.cliLogger.info("Converting {} to {}", (Object)ediFile.getPath(), (Object)nameAndWriter.name());
                    RootObjContainer rootObjContainer = this.convertFileToJson(ediFile, nameAndWriter.writer());
                    this.logProcessedFile(rootObjContainer.counts(), ediFile, sw);
                }
                finally {
                    if (nameAndWriter == null) continue;
                    nameAndWriter.close();
                }
            }
        }
    }

    private ClaimPaymentParsingState parseChunkForJson(RootObjContainer rootObjContainer, EdiParser ediParser, int chunkSize, JsonObjectSerializer serializer) throws IOException {
        ClaimPaymentParsingState state;
        try {
            state = this.parseChunk(rootObjContainer, ediParser, chunkSize);
        }
        catch (Exception e) {
            this.serializeException(e, ediParser, serializer);
            serializer.writeEnd();
            throw e;
        }
        if (!state.rootEntityContainer().isEmpty()) {
            this.serialize(rootObjContainer, serializer);
            if (!state.isDone()) {
                this.logProcessedChunk(rootObjContainer.counts());
            }
        }
        return state;
    }

    private RootObjContainer convertFileToJson(File ediFile, Writer writer) {
        RootObjContainer rootObjContainer = new RootObjContainer();
        try (EdiParser ediParser = this.createEdiParser(ediFile);
             JsonObjectSerializer serializer = new JsonObjectSerializer(writer, this.outputFormat == OutputFormat.JSONL, this.isFormatJson);){
            ClaimPaymentParsingState state;
            boolean isDone;
            serializer.writeStart();
            while (!(isDone = (state = this.parseChunkForJson(rootObjContainer, ediParser, this.chunkSize, serializer)).isDone())) {
            }
            if (!rootObjContainer.isEmpty()) {
                this.serialize(rootObjContainer, serializer);
            }
            serializer.writeEnd();
        }
        return rootObjContainer;
    }

    private boolean isSingleOutput(File outFileOrDir) {
        return outFileOrDir == null || !outFileOrDir.isDirectory() || !outFileOrDir.exists();
    }

    private NamedWriter openOutputForJson(File ediFile, File outFileOrDir, NamedWriter namedWriter) {
        if (namedWriter != null) {
            return namedWriter;
        }
        File outFile = this.determineOutputFile(ediFile, outFileOrDir);
        File parentDir = outFileOrDir.getParentFile();
        if (parentDir != null) {
            FileUtils.forceMkdir((File)parentDir);
        }
        BufferedWriter writer = Files.newBufferedWriter(outFile.toPath(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        String fileName = outFile.getPath();
        return new NamedWriter(fileName, writer);
    }

    private EdiParser createEdiParser(File ediFile) {
        return new EdiParser(ediFile).isSplitMode(this.isSplitMode).codeResolver(this.codeResolver).maxNumberOfIssues(this.maxNumberOfIssues);
    }

    private File determineOutputFile(File ediFile, File outputFileOrDir) {
        File outFile = outputFileOrDir;
        if (outputFileOrDir.isDirectory()) {
            String outFileName = FilenameUtils.getBaseName((String)ediFile.getAbsolutePath());
            outFile = new File(outputFileOrDir, outFileName + this.getExt());
        } else {
            String ext = FilenameUtils.getExtension((String)outFile.getName());
            if (StringUtils.isBlank((CharSequence)ext)) {
                outFile = new File(outFile.getAbsolutePath() + this.getExt());
            }
        }
        return outFile;
    }

    private String getExt() {
        return "." + this.outputFormat.extension();
    }

    private ClaimPaymentParsingState parseChunk(RootObjContainer rootObjContainer, EdiParser ediParser, int chunkSize) {
        EdiParsingResults ediParsingResults = ediParser.parse(chunkSize);
        RootObjContainer rootObjContainerForChunk = RootObjContainer.fromParsingResults(ediParsingResults, this.asSegments);
        rootObjContainer.add(rootObjContainerForChunk);
        return new ClaimPaymentParsingState(rootObjContainerForChunk, ediParsingResults);
    }

    private void serialize(RootObjContainer rootObjContainer, JsonObjectSerializer serializer) throws IOException {
        if (this.isSerializeTransactions) {
            this.serializeArray(rootObjContainer.ediTransactions(), serializer);
        }
        this.serializeArray(rootObjContainer.rootObjs(), serializer);
        this.serializeArray(rootObjContainer.claims(), serializer);
        this.serializeArray(rootObjContainer.coverages(), serializer);
        this.serializeArray(rootObjContainer.statuses(), serializer);
        if (rootObjContainer.segments() != null) {
            for (JsonNode jsonNode : rootObjContainer.segments()) {
                serializer.serialize(jsonNode);
            }
        }
        if (this.isSerializeParsingIssues && rootObjContainer.parsingIssues() != null) {
            this.serializeParsingIssues(serializer, rootObjContainer.parsingIssues());
        }
        rootObjContainer.clear();
        serializer.flush();
    }

    private void serializeArray(Collection<?> rootObjs, JsonObjectSerializer serializer) throws IOException {
        if (rootObjs != null) {
            for (Object cp : rootObjs) {
                serializer.serialize(cp);
            }
        }
    }

    private void serializeException(Exception exception, EdiParser ediParser, JsonObjectSerializer serializer) throws IOException {
        EdiParserException parserException;
        FileInfo fileInfo;
        FileInfo fileInfo2 = fileInfo = ediParser != null ? ediParser.fileInfo() : null;
        if (exception instanceof EdiParserException && (parserException = (EdiParserException)exception).hasIssues()) {
            this.serializeParsingIssues(serializer, parserException.issues());
        } else {
            this.serializeErrorInfo(new ErrorInfo(exception), serializer, fileInfo);
        }
    }

    private void serializeParsingIssues(JsonObjectSerializer serializer, List<ParsingIssue> parsingIssues) throws IOException {
        for (ParsingIssue parsingIssue : parsingIssues) {
            ErrorInfo errorInfo = parsingIssue.toErrorInfo();
            this.serializeErrorInfo(errorInfo, serializer, null);
        }
    }

    private void serializeErrorInfo(ErrorInfo errorInfo, JsonObjectSerializer serializer, FileInfo fileInfo) throws IOException {
        if (fileInfo != null) {
            errorInfo.fileName(fileInfo.name());
        }
        serializer.serialize(errorInfo);
    }

    private void logProcessedChunk(RootObjContainer.Counts totalCounts) {
        if (!totalCounts.isEmpty()) {
            ++this.chunkI;
            if (this.chunkI % this.logEveryNChunks == 0) {
                Object msg = this.createLogMessage(totalCounts);
                msg = (String)msg + " ...";
                this.cliLogger.info((String)msg);
            }
        }
    }

    private void logStartFileProcessing(File ediFile) {
        this.cliLogger.info("Converting {}", (Object)ediFile.getPath());
    }

    private void logProcessedFile(RootObjContainer.Counts totalCounts, File ediFile, StopWatch sw) {
        Object msg = this.createLogMessage(totalCounts);
        if (ediFile != null) {
            msg = (String)msg + " from " + ediFile.getName();
        }
        msg = (String)msg + " in {}";
        this.cliLogger.info((String)msg, (Object)sw);
    }

    private String createLogMessage(RootObjContainer.Counts totalCounts) {
        String msg = "Converted";
        Object countMsg = "";
        countMsg = (String)countMsg + String.format(" %d transaction(s)", totalCounts.tranCount());
        if (totalCounts.claimCount() > 0) {
            countMsg = (String)countMsg + String.format(" %d claim(s)", totalCounts.claimCount());
        }
        if (totalCounts.paymentCount() > 0) {
            countMsg = (String)countMsg + String.format(" %d payment(s)", totalCounts.paymentCount());
        }
        if (totalCounts.providerAdjustmentCount() > 0) {
            countMsg = (String)countMsg + String.format(" %d provider adjustment(s)", totalCounts.providerAdjustmentCount());
        }
        if (totalCounts.coverageCount() > 0) {
            countMsg = (String)countMsg + String.format(" %d member(s)", totalCounts.coverageCount());
        }
        if (totalCounts.statusCount() > 0) {
            countMsg = (String)countMsg + String.format(" %d status(es)", totalCounts.statusCount());
        }
        if (StringUtils.isBlank((CharSequence)countMsg)) {
            countMsg = " 0 items";
        }
        return msg + (String)countMsg;
    }

    @Generated
    public EdiFileConverter chunkSize(int chunkSize) {
        this.chunkSize = chunkSize;
        return this;
    }

    @Generated
    public EdiFileConverter loggingChunkSize(int loggingChunkSize) {
        this.loggingChunkSize = loggingChunkSize;
        return this;
    }

    @Generated
    public EdiFileConverter maxOutputLines(int maxOutputLines) {
        this.maxOutputLines = maxOutputLines;
        return this;
    }

    @Generated
    public int maxOutputLines() {
        return this.maxOutputLines;
    }

    @Generated
    public EdiFileConverter isSplitMode(boolean isSplitMode) {
        this.isSplitMode = isSplitMode;
        return this;
    }

    @Generated
    public EdiFileConverter isFormatJson(boolean isFormatJson) {
        this.isFormatJson = isFormatJson;
        return this;
    }

    @Generated
    public boolean isFormatJson() {
        return this.isFormatJson;
    }

    @Generated
    public EdiFileConverter isShowProgress(boolean isShowProgress) {
        this.isShowProgress = isShowProgress;
        return this;
    }

    @Generated
    public boolean isShowProgress() {
        return this.isShowProgress;
    }

    @Generated
    public EdiFileConverter isSerializeParsingIssues(boolean isSerializeParsingIssues) {
        this.isSerializeParsingIssues = isSerializeParsingIssues;
        return this;
    }

    @Generated
    public boolean isSerializeParsingIssues() {
        return this.isSerializeParsingIssues;
    }

    @Generated
    public EdiFileConverter maxNumberOfIssues(int maxNumberOfIssues) {
        this.maxNumberOfIssues = maxNumberOfIssues;
        return this;
    }

    @Generated
    public int maxNumberOfIssues() {
        return this.maxNumberOfIssues;
    }

    @Generated
    public EdiFileConverter asSegments(boolean asSegments) {
        this.asSegments = asSegments;
        return this;
    }

    @Generated
    public boolean asSegments() {
        return this.asSegments;
    }

    @Generated
    public EdiFileConverter isSerializeTransactions(boolean isSerializeTransactions) {
        this.isSerializeTransactions = isSerializeTransactions;
        return this;
    }

    @Generated
    public boolean isSerializeTransactions() {
        return this.isSerializeTransactions;
    }

    @Generated
    public EdiFileConverter schemaHolder(SchemaHolder schemaHolder) {
        this.schemaHolder = schemaHolder;
        return this;
    }

    @Generated
    public String csvConversionSchemaFileName() {
        return this.csvConversionSchemaFileName;
    }

    @Generated
    public EdiFileConverter csvConversionSchemaFileName(String csvConversionSchemaFileName) {
        this.csvConversionSchemaFileName = csvConversionSchemaFileName;
        return this;
    }

    @Generated
    public String csvConversionSchemaName() {
        return this.csvConversionSchemaName;
    }

    @Generated
    public EdiFileConverter csvConversionSchemaName(String csvConversionSchemaName) {
        this.csvConversionSchemaName = csvConversionSchemaName;
        return this;
    }

    @Generated
    public CsvConversionContext conversionContext() {
        return this.conversionContext;
    }

    @Generated
    public EdiFileConverter codeResolver(CodeEntityResolver codeResolver) {
        this.codeResolver = codeResolver;
        return this;
    }

    @Generated
    public EdiFileConverter transactionTypeFilter(TransactionType transactionTypeFilter) {
        this.transactionTypeFilter = transactionTypeFilter;
        return this;
    }
}

