/*
 * Decompiled with CFR 0.152.
 */
package hdi.edi.converter;

import java.util.Locale;
import lombok.Generated;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.EnumUtils;

public enum OutputFormat {
    CSV("csv", "text/csv"),
    EXCEL("xlsx", "application/application/vnd.ms-excel"),
    JSON("json", "application/json"),
    JSONL("jsonl", "application/x-ndjson");

    private final String extension;
    private final String contentType;

    public boolean isCsvOrExcel() {
        return this == CSV || this == EXCEL;
    }

    public boolean isJson() {
        return this == JSON || this == JSONL;
    }

    public static OutputFormat fromString(String format) {
        if (format == null) {
            return null;
        }
        return (OutputFormat)EnumUtils.getEnum(OutputFormat.class, (String)format.toUpperCase());
    }

    public String replaceFilenameExtension(String filename) {
        return FilenameUtils.getBaseName((String)filename) + "." + this.extension.toLowerCase(Locale.ROOT);
    }

    @Generated
    public String extension() {
        return this.extension;
    }

    @Generated
    public String contentType() {
        return this.contentType;
    }

    @Generated
    private OutputFormat(String extension, String contentType) {
        this.extension = extension;
        this.contentType = contentType;
    }
}

