/*
 * Decompiled with CFR 0.152.
 */
package hdi.edi.csv;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import hdi.codeent.CodeEntity;
import hdi.codeent.PrimaryCodeType;
import hdi.edi.csv.ClaimCsv;
import hdi.edi.csv.CsvUtils;
import hdi.edi.csv.PaymentLineCsv;
import hdi.edi.dict.annotations.EdiObj;
import hdi.edi.dict.annotations.ObjType;
import hdi.edi.dict.annotations.Prop;
import hdi.edi.parser.TransactionType;
import hdi.model.Attachment;
import hdi.model.PlaceOfServiceType;
import hdi.model.ServiceLine;
import hdi.model.enumtype.AmountType;
import hdi.model.enumtype.ProcType;
import hdi.model.enumtype.ReferenceType;
import hdi.model.enumtype.UnitType;
import hdi.model.orgperson.EntityRole;
import hdi.model.orgperson.OrgOrPerson;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import lombok.Generated;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@EdiObj(loop={"2400"})
public class ClaimLineCsv {
    @Prop(refType={ReferenceType.PROVIDER_CONTROL_NUMBER})
    private String controlNumber;
    @Prop(edi={"SV201"}, tran={TransactionType.INST}, objType=ObjType.REV_CODE, isRequired=true)
    private CodeEntity revenueCode;
    @Prop(edi={"837P:SV101", "837I:SV202", "837D:SV302"}, objType=ObjType.PROCEDURE, procType={ProcType.HCPCS, ProcType.ADA, ProcType.ABC, ProcType.HIEC})
    private CodeEntity procedure;
    @Prop(masterClass=ServiceLine.class)
    private BigDecimal chargeAmount;
    @Prop(edi={"837P:SV103", "837I:SV204", "837D:SV304"}, isRequired=true)
    private UnitType unitType;
    @Prop(edi={"837P:SV104", "837I:SV205", "837D:SV305"}, isRequired=true)
    private BigDecimal unitCount;
    @Prop(edi={"SV105"}, tran={TransactionType.PROF})
    private PlaceOfServiceType placeOfService;
    @Prop(edi={"SV105"}, tran={TransactionType.PROF})
    private String placeOfServiceCode;
    @Prop(edi={"SV207"}, tran={TransactionType.INST})
    private BigDecimal nonCoveredAmount;
    @Prop(edi={"SV107"}, tran={TransactionType.PROF}, objType=ObjType.INTEGER, isRequired=true)
    private List<Integer> diagPointers;
    @Prop(edi={"SV109"}, tran={TransactionType.PROF})
    private String emergencyIndicator;
    @Prop(edi={"SV111"}, tran={TransactionType.PROF})
    private String epsdtIndicator;
    @Prop(edi={"SV112"}, tran={TransactionType.PROF})
    private String familyPlanningIndicator;
    @Prop(edi={"SV115"}, tran={TransactionType.PROF})
    private String copayStatusCode;
    @Prop(masterClass=PaymentLineCsv.class)
    private LocalDate serviceDateFrom;
    @Prop(masterClass=PaymentLineCsv.class)
    private LocalDate serviceDateTo;
    @Prop(masterClass=ServiceLine.class)
    private LocalDate prescriptionDate;
    @Prop(masterClass=ServiceLine.class)
    private LocalDate beginTherapyDate;
    @Prop(masterClass=ServiceLine.class)
    private LocalDate lastSeenDate;
    @Prop(masterClass=ServiceLine.class)
    private LocalDate testPerformedDate;
    @Prop(masterClass=ServiceLine.class)
    private LocalDate lastXRayDate;
    @Prop(masterClass=ServiceLine.class)
    private LocalDate initialTreatmentDate;
    @Prop(refType={ReferenceType.PRIOR_AUTHORIZATION_NUMBER}, tran={TransactionType.PROF})
    private String priorAuthorization;
    @Prop(refType={ReferenceType.REFERRAL_NUMBER}, tran={TransactionType.PROF})
    private String referralNumber;
    @Prop(refType={ReferenceType.REPRICED_LINE_REFERENCE_NUMBER})
    private String repricedReferenceNumber;
    @Prop(refType={ReferenceType.ADJUSTED_REPRICED_LINE_REFERENCE_NUMBER})
    private String adjustedRepricedReferenceNumber;
    @Prop(tran={TransactionType.INST}, amtType=AmountType.SERVICE_TAX)
    private BigDecimal serviceTaxAmount;
    @Prop(tran={TransactionType.INST}, amtType=AmountType.MISC_TAX)
    private BigDecimal facilityTaxAmount;
    @Prop(masterClass=ServiceLine.class, fieldName="lineNote")
    private String note;
    @Prop(edi={"NTE02"})
    private String thirdPartyNote;
    @Prop(edi={"LIN03"}, objType=ObjType.DRUG)
    private CodeEntity drug;
    @Prop(edi={"CTP04"})
    private BigDecimal drugQuantity;
    @Prop(edi={"CTP05-1"})
    private UnitType drugUnitType;
    @Prop(refType={ReferenceType.PHARMACY_PRESCRIPTION_NUMBER})
    private String prescriptionNumber;
    @Prop(edi={"PWK"}, objType=ObjType.ATTACHMENT)
    private List<Attachment> attachments;
    @Prop(tran={TransactionType.INST}, masterClass=ClaimCsv.class)
    private OrgOrPerson operatingPhysician;
    @Prop(tran={TransactionType.INST}, masterClass=ClaimCsv.class)
    private OrgOrPerson otherOperatingPhysician;
    @Prop(masterClass=ClaimCsv.class)
    private OrgOrPerson renderingProvider;
    @Prop(tran={TransactionType.PROF}, entityRole=EntityRole.PURCHASE_SERVICE, objType=ObjType.PARTY)
    private OrgOrPerson purchasedServiceProvider;
    @Prop(tran={TransactionType.PROF}, entityRole=EntityRole.SERVICE_FACILITY, objType=ObjType.PARTY)
    private OrgOrPerson serviceFacility;
    @Prop(tran={TransactionType.PROF}, masterClass=ClaimCsv.class)
    private OrgOrPerson supervisingProvider;
    @Prop(masterClass=ClaimCsv.class)
    private OrgOrPerson referringProvider;
    @Prop(tran={TransactionType.PROF}, entityRole=EntityRole.ORDERING, objType=ObjType.PARTY)
    private OrgOrPerson orderingProvider;
    @Prop(tran={TransactionType.PROF}, masterClass=ClaimCsv.class)
    private OrgOrPerson ambulancePickUp;
    @Prop(tran={TransactionType.PROF}, masterClass=ClaimCsv.class)
    private OrgOrPerson ambulanceDropOff;

    public ClaimLineCsv() {
        this(new ServiceLine());
    }

    public ClaimLineCsv(ServiceLine line) {
        this.chargeAmount = line.chargeAmount();
        this.unitCount = line.unitCount();
        this.unitType = line.unitType();
        this.placeOfService = line.placeOfServiceType();
        this.placeOfServiceCode = line.placeOfServiceCode();
        this.emergencyIndicator = line.emergencyIndicator();
        this.epsdtIndicator = line.epsdtIndicator();
        this.familyPlanningIndicator = line.familyPlanningIndicator();
        this.copayStatusCode = line.copayStatusCode();
        this.serviceDateFrom = line.serviceDateFrom();
        this.serviceDateTo = line.serviceDateTo();
        this.prescriptionDate = line.prescriptionDate();
        this.beginTherapyDate = line.beginTherapyDate();
        this.lastSeenDate = line.lastSeenDate();
        this.lastXRayDate = line.lastXRayDate();
        this.testPerformedDate = line.testPerformedDate();
        this.revenueCode = CsvUtils.prepCodeEnt(line.revenueCode(), PrimaryCodeType.UB04_REVENUE_CODE);
        this.procedure = CsvUtils.prepCodeEnt(line.procedure(), PrimaryCodeType.PROCEDURE);
        this.controlNumber = line.sourceLineId();
        this.drug = CsvUtils.prepCodeEnt(line.drug(), PrimaryCodeType.DRUG);
        this.drugQuantity = line.drugQuantity();
        this.drugUnitType = line.drugUnitType();
        this.prescriptionNumber = line.prescriptionNumber();
        EntityRole providerRole = EntityRole.OPERATING;
        this.operatingPhysician = CsvUtils.prepProvider(line, providerRole);
        providerRole = EntityRole.OTHER_OPERATING;
        this.otherOperatingPhysician = CsvUtils.prepProvider(line, providerRole);
        this.renderingProvider = CsvUtils.prepProvider(line, EntityRole.RENDERING);
        this.purchasedServiceProvider = CsvUtils.prepProvider(line, EntityRole.PURCHASE_SERVICE);
        this.serviceFacility = CsvUtils.prepProvider(line, EntityRole.SERVICE_FACILITY);
        this.supervisingProvider = CsvUtils.prepProvider(line, EntityRole.SUPERVISING);
        this.referringProvider = CsvUtils.prepProvider(line, EntityRole.REFERRING);
        this.orderingProvider = CsvUtils.prepProvider(line, EntityRole.ORDERING);
        this.ambulancePickUp = CsvUtils.prepProvider(line, EntityRole.PICKUP_ADDRESS);
        this.ambulanceDropOff = CsvUtils.prepProvider(line, EntityRole.DROP_OFF_LOCATION);
        this.diagPointers = CsvUtils.prepList(line.diagPointers(), null);
        this.nonCoveredAmount = line.nonCoveredAmount();
        this.priorAuthorization = line.priorAuthorization();
        this.referralNumber = line.referralNumber();
        this.repricedReferenceNumber = line.repricedReferenceNumber();
        this.adjustedRepricedReferenceNumber = line.adjustedRepricedReferenceNumber();
        this.serviceTaxAmount = line.serviceTaxAmount();
        this.facilityTaxAmount = line.facilityTaxAmount();
        this.note = line.lineNote();
        this.thirdPartyNote = line.thirdPartyNote();
        this.attachments = CsvUtils.prepList(line.attachments(), new Attachment());
    }

    @Generated
    public String toString() {
        return "ClaimLineCsv(controlNumber=" + this.controlNumber + ", revenueCode=" + String.valueOf(this.revenueCode) + ", procedure=" + String.valueOf(this.procedure) + ", chargeAmount=" + String.valueOf(this.chargeAmount) + ", unitType=" + String.valueOf(this.unitType) + ", unitCount=" + String.valueOf(this.unitCount) + ", placeOfService=" + String.valueOf((Object)this.placeOfService) + ", placeOfServiceCode=" + this.placeOfServiceCode + ", nonCoveredAmount=" + String.valueOf(this.nonCoveredAmount) + ", diagPointers=" + String.valueOf(this.diagPointers) + ", emergencyIndicator=" + this.emergencyIndicator + ", epsdtIndicator=" + this.epsdtIndicator + ", familyPlanningIndicator=" + this.familyPlanningIndicator + ", copayStatusCode=" + this.copayStatusCode + ", serviceDateFrom=" + String.valueOf(this.serviceDateFrom) + ", serviceDateTo=" + String.valueOf(this.serviceDateTo) + ", prescriptionDate=" + String.valueOf(this.prescriptionDate) + ", beginTherapyDate=" + String.valueOf(this.beginTherapyDate) + ", lastSeenDate=" + String.valueOf(this.lastSeenDate) + ", testPerformedDate=" + String.valueOf(this.testPerformedDate) + ", lastXRayDate=" + String.valueOf(this.lastXRayDate) + ", initialTreatmentDate=" + String.valueOf(this.initialTreatmentDate) + ", priorAuthorization=" + this.priorAuthorization + ", referralNumber=" + this.referralNumber + ", repricedReferenceNumber=" + this.repricedReferenceNumber + ", adjustedRepricedReferenceNumber=" + this.adjustedRepricedReferenceNumber + ", serviceTaxAmount=" + String.valueOf(this.serviceTaxAmount) + ", facilityTaxAmount=" + String.valueOf(this.facilityTaxAmount) + ", note=" + this.note + ", thirdPartyNote=" + this.thirdPartyNote + ", drug=" + String.valueOf(this.drug) + ", drugQuantity=" + String.valueOf(this.drugQuantity) + ", drugUnitType=" + String.valueOf(this.drugUnitType) + ", prescriptionNumber=" + this.prescriptionNumber + ", attachments=" + String.valueOf(this.attachments) + ", operatingPhysician=" + String.valueOf(this.operatingPhysician) + ", otherOperatingPhysician=" + String.valueOf(this.otherOperatingPhysician) + ", renderingProvider=" + String.valueOf(this.renderingProvider) + ", purchasedServiceProvider=" + String.valueOf(this.purchasedServiceProvider) + ", serviceFacility=" + String.valueOf(this.serviceFacility) + ", supervisingProvider=" + String.valueOf(this.supervisingProvider) + ", referringProvider=" + String.valueOf(this.referringProvider) + ", orderingProvider=" + String.valueOf(this.orderingProvider) + ", ambulancePickUp=" + String.valueOf(this.ambulancePickUp) + ", ambulanceDropOff=" + String.valueOf(this.ambulanceDropOff) + ")";
    }
}

