/*
 * Decompiled with CFR 0.152.
 */
package hdi.edi.csv;

import hdi.edi.converter.NamedWriter;
import hdi.edi.converter.OutputFormat;
import hdi.edi.csv.ConversionSchema;
import hdi.edi.csv.CsvConversionException;
import hdi.edi.csv.CsvConverter;
import hdi.edi.csv.CsvOutputMgr;
import hdi.edi.csv.ExcelOutputMgr;
import hdi.edi.csv.OutputMgr;
import hdi.edi.csv.SchemaHolder;
import hdi.edi.parser.TransactionType;
import java.io.File;
import java.io.Writer;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;

public class CsvConversionContext {
    private CsvConverter converter;
    private final File outputFile;
    private final Writer writer;
    @NonNull
    private List<String> listNames;
    private final String schemaName;

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CsvConverter initConverter(SchemaHolder schemaHolder, OutputFormat outputFormat, TransactionType transactionType) {
        void var5_8;
        ConversionSchema schema;
        if (this.writer != null) {
            schema = schemaHolder.findSchema(this.schemaName, transactionType, this.listNames);
            if (schema.getListNamesForOutput().size() > 1) {
                throw new CsvConversionException("Using conversion schema %s will produce multiple files. You can only use a single output file schema, such as %s with a Writer.", this.schemaName, "lines-with-header-repeat-first-row");
            }
            if (outputFormat != OutputFormat.CSV) throw new CsvConversionException("Output format %s is not supported for single output", new Object[]{outputFormat});
            CsvOutputMgr csvOutputMgr = CsvOutputMgr.createForWriters(schema, List.of(new NamedWriter(schema.getListNamesForOutput().get(0), this.writer)));
        } else {
            schema = schemaHolder.findSchema(this.schemaName, transactionType, this.listNames);
            if (outputFormat == OutputFormat.CSV) {
                CsvOutputMgr csvOutputMgr = CsvOutputMgr.createForFiles(schema, this.outputFile);
            } else {
                if (outputFormat != OutputFormat.EXCEL) throw new CsvConversionException("Output format %s is not supported", new Object[]{outputFormat});
                ExcelOutputMgr excelOutputMgr = new ExcelOutputMgr(schema, this.outputFile);
            }
        }
        this.converter = new CsvConverter(schema, (OutputMgr)var5_8);
        return this.converter;
    }

    @Generated
    public CsvConversionContext(File outputFile, Writer writer, @NonNull List<String> listNames, String schemaName) {
        if (listNames == null) {
            throw new NullPointerException("listNames is marked non-null but is null");
        }
        this.outputFile = outputFile;
        this.writer = writer;
        this.listNames = listNames;
        this.schemaName = schemaName;
    }

    @Generated
    public CsvConverter converter() {
        return this.converter;
    }
}

