/*
 * Decompiled with CFR 0.152.
 */
package hdi.edi.csv;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import hdi.edi.csv.ClaimCsv;
import hdi.edi.csv.ConversionSchema;
import hdi.edi.csv.CsvConversionResults;
import hdi.edi.csv.JsonToCsvConverter;
import hdi.edi.csv.OutputMgr;
import hdi.edi.csv.PaymentCsv;
import hdi.model.claim.Claim;
import hdi.model.coverage.MemberCoverage;
import hdi.model.payment.Payment;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.bson.types.ObjectId;

public class CsvConverter {
    public static final ObjectMapper JSON_SERIALIZER_FOR_CSV = new ObjectMapper().configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false).configure(SerializationFeature.INDENT_OUTPUT, false).configure(SerializationFeature.FLUSH_AFTER_WRITE_VALUE, false).configure(SerializationFeature.CLOSE_CLOSEABLE, false).disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS).setSerializationInclusion(JsonInclude.Include.ALWAYS).registerModule((Module)new JavaTimeModule());
    private final OutputMgr outputMgr;
    private final JsonToCsvConverter converter;
    private final ConversionSchema schema;
    private boolean isSuppressIdGeneration = false;

    public CsvConverter(ConversionSchema schema, OutputMgr outputMgr) {
        this.schema = schema;
        this.outputMgr = outputMgr;
        this.converter = new JsonToCsvConverter(schema);
        if (schema.isOutputHeaders()) {
            this.writeHeaders();
        }
    }

    public void convert(List<?> objsToConvert) {
        this.performConversion(objsToConvert);
    }

    private void performConversion(List<?> objsToConvert) {
        for (Object obj : objsToConvert) {
            this.writeRows(this.convertClaimOrPayment(this.converter, obj));
        }
    }

    private void writeHeaders() {
        for (Map.Entry<String, List<Object>> headersAndName : this.schema.headers().entrySet()) {
            this.outputMgr.writeRow(headersAndName.getKey(), headersAndName.getValue());
        }
    }

    private void writeRows(CsvConversionResults csvConversionResults) {
        Map<String, List<List<Object>>> lists = csvConversionResults.getLists();
        for (Map.Entry<String, List<List<Object>>> listAndName : lists.entrySet()) {
            String name = listAndName.getKey();
            if (!this.schema.isValidListName(name)) continue;
            this.outputMgr.writeRows(name, listAndName.getValue());
        }
    }

    private CsvConversionResults convertClaimOrPayment(JsonToCsvConverter converter, Object rootEntity) {
        Object objForJson;
        if (rootEntity instanceof Claim) {
            Claim claim = (Claim)rootEntity;
            ClaimCsv claimCsv = new ClaimCsv(claim, claim.transactionType());
            if (!this.isSuppressIdGeneration) {
                claimCsv.id(ObjectId.get().toHexString());
            }
            objForJson = claimCsv;
        } else if (rootEntity instanceof Payment) {
            Payment payment = (Payment)rootEntity;
            PaymentCsv paymentCsv = new PaymentCsv(payment);
            if (!this.isSuppressIdGeneration) {
                paymentCsv.id(ObjectId.get().toHexString());
            }
            objForJson = paymentCsv;
        } else if (rootEntity instanceof MemberCoverage) {
            MemberCoverage memberCoverage = (MemberCoverage)rootEntity;
            if (!this.isSuppressIdGeneration) {
                memberCoverage.id(ObjectId.get().toHexString());
            }
            memberCoverage.prepForCsv();
            objForJson = memberCoverage;
        } else {
            throw new IllegalArgumentException("Only claims or payments please");
        }
        JsonNode rootNode = JSON_SERIALIZER_FOR_CSV.valueToTree(objForJson);
        return converter.convertJson((ObjectNode)rootNode);
    }

    @Generated
    public OutputMgr outputMgr() {
        return this.outputMgr;
    }

    @Generated
    public ConversionSchema schema() {
        return this.schema;
    }

    @Generated
    public CsvConverter isSuppressIdGeneration(boolean isSuppressIdGeneration) {
        this.isSuppressIdGeneration = isSuppressIdGeneration;
        return this;
    }
}

