/*
 * Decompiled with CFR 0.152.
 */
package hdi.edi.csv;

import hdi.edi.csv.ConversionSchema;
import hdi.edi.csv.OutputMgr;
import hdi.edi.parser.TransactionType;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.WorkbookUtil;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelOutputMgr
implements Closeable,
OutputMgr {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExcelOutputMgr.class);
    private final OutputStream outputStream;
    private Workbook workbook;
    private ConversionSchema schema;
    private File outputFile = null;
    private final Map<String, Sheet> sheets = new HashMap<String, Sheet>();
    private CellStyle amountStyle;
    private CellStyle intStyle;
    private CellStyle textStyle;
    private CellStyle dateStyle;

    public ExcelOutputMgr(ConversionSchema schema, File file) {
        FileUtils.forceMkdirParent((File)file);
        this.outputFile = file;
        this.outputStream = Files.newOutputStream(file.toPath(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        this.init(schema);
    }

    public ExcelOutputMgr(ConversionSchema schema, OutputStream outputStream) {
        this.outputStream = outputStream;
        this.init(schema);
    }

    private void init(ConversionSchema schema) {
        this.schema = schema;
        SXSSFWorkbook streamingWb = new SXSSFWorkbook();
        streamingWb.setCompressTempFiles(true);
        this.workbook = streamingWb;
        this.createFormats(this.workbook);
    }

    private void createFormats(Workbook workbook) {
        DataFormat format = workbook.createDataFormat();
        this.amountStyle = workbook.createCellStyle();
        this.amountStyle.setDataFormat(format.getFormat("#,##0.00"));
        this.intStyle = workbook.createCellStyle();
        this.intStyle.setDataFormat(format.getFormat("#,##0"));
        this.textStyle = workbook.createCellStyle();
        this.textStyle.setDataFormat(format.getFormat("@"));
        this.dateStyle = workbook.createCellStyle();
        this.dateStyle.setDataFormat((short)14);
    }

    @Override
    public void writeRow(String listName, List<Object> row) {
        String sheetName = this.getSheetName(listName);
        Sheet sheet = this.sheets.get(listName);
        if (sheet == null) {
            sheet = this.workbook.createSheet(sheetName);
            this.sheets.put(listName, sheet);
        }
        int rowI = sheet.getLastRowNum() + 1;
        Row excelRow = sheet.createRow(rowI);
        int columnI = 0;
        for (Object val : row) {
            this.populateCell(listName, val, excelRow, columnI);
            ++columnI;
        }
    }

    private void populateCell(String listName, Object val, Row excelRow, int columnI) {
        Cell cell = null;
        if (val == null) {
            cell = excelRow.createCell(columnI, CellType.BLANK);
        } else if (val instanceof Number) {
            Number number = (Number)val;
            cell = excelRow.createCell(columnI, CellType.NUMERIC);
            cell.setCellValue(number.doubleValue());
            if (number instanceof BigDecimal) {
                if (this.isAmount(listName, columnI)) {
                    cell.setCellStyle(this.amountStyle);
                }
            } else if (number instanceof Integer) {
                cell.setCellStyle(this.intStyle);
            }
        } else if (val instanceof Boolean) {
            Boolean boolVal = (Boolean)val;
            cell = excelRow.createCell(columnI, CellType.BOOLEAN);
            cell.setCellValue(boolVal.booleanValue());
        } else {
            if (val instanceof String) {
                LocalDate d;
                String stringVal = (String)val;
                if (this.isDate(listName, columnI) && (d = this.parseDate(stringVal)) != null) {
                    cell = excelRow.createCell(columnI);
                    cell.setCellValue(d);
                    cell.setCellStyle(this.dateStyle);
                }
            }
            if (cell == null) {
                cell = excelRow.createCell(columnI, CellType.STRING);
                cell.setCellValue(val.toString());
                cell.setCellStyle(this.textStyle);
            }
        }
    }

    private LocalDate parseDate(String stringVal) {
        if (stringVal == null) {
            return null;
        }
        try {
            return LocalDate.parse(stringVal);
        }
        catch (Exception e) {
            return null;
        }
    }

    private boolean isAmount(String listName, int columnI) {
        String header = this.getHeaderName(listName, columnI);
        if (header != null) {
            return StringUtils.endsWithAny((CharSequence)header.toLowerCase(), (CharSequence[])new CharSequence[]{"amount", "amt"});
        }
        return false;
    }

    private boolean isDate(String listName, int columnI) {
        String header = this.getHeaderName(listName, columnI);
        if (header != null) {
            return StringUtils.endsWithAny((CharSequence)header.toLowerCase(), (CharSequence[])new CharSequence[]{"date", "datefrom", "dateto"});
        }
        return false;
    }

    private String getHeaderName(String listName, int columnI) {
        Object header;
        List<Object> listHeaders = this.schema.headers().get(listName);
        if (listHeaders != null && listHeaders.size() > columnI && (header = listHeaders.get(columnI)) instanceof String) {
            String stringHeader = (String)header;
            return stringHeader;
        }
        return null;
    }

    @Override
    public void writeRows(String listName, List<List<Object>> rows) {
        for (List<Object> row : rows) {
            this.writeRow(listName, row);
        }
    }

    @Override
    public void close() throws IOException {
        String fileName = this.outputFile != null ? this.outputFile.getName() : "'Output Stream'";
        log.info("Writing generated Excel data to the output file {}", (Object)fileName);
        this.workbook.write(this.outputStream);
        this.workbook.close();
        this.outputStream.close();
    }

    private String getSheetName(String listName) {
        Object sheetName = listName;
        if (StringUtils.equalsIgnoreCase((CharSequence)listName, (CharSequence)"Main")) {
            sheetName = this.getMainListName((String)sheetName);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)listName, (CharSequence)"Lines")) {
            if (this.sheets.isEmpty()) {
                String mainListName = this.getMainListName((String)sheetName);
                sheetName = mainListName + " and Service Lines";
            } else {
                sheetName = "Service Lines";
            }
        }
        return WorkbookUtil.createSafeSheetName((String)sheetName);
    }

    private String getMainListName(String sheetName) {
        TransactionType tran = this.schema.transactionTypeInUse();
        if (tran.isClaim()) {
            sheetName = "Claims";
        } else if (tran == TransactionType.PAYMENT) {
            sheetName = "Payments";
        }
        return sheetName;
    }

    @Generated
    public ConversionSchema schema() {
        return this.schema;
    }
}

