/*
 * Decompiled with CFR 0.152.
 */
package hdi.edi.csv;

import hdi.edi.csv.ListConversionSchema;
import hdi.util.GlobUtils;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;

public class ListConversionMeta {
    private final String name;
    private final ListConversionSchema listSchema;
    private final Set<String> excludedFieldPatterns;
    private final Set<String> includedFieldPatterns;
    private final Set<String> excludedFields = new HashSet<String>();
    private final Set<String> includedFields = new HashSet<String>();
    private final Set<String> repeatedFields = new HashSet<String>();
    private final BitSet repeatedAllRowsIndexes = new BitSet();
    private String prefix;

    public boolean isIncluded(String path, boolean isHeader) {
        if (!this.includedFieldPatterns.isEmpty()) {
            return this.checkMatchAndIndex(this.includedFieldPatterns, this.includedFields, path, isHeader);
        }
        return true;
    }

    public boolean isExcluded(String path, boolean isHeader) {
        if (!this.excludedFieldPatterns.isEmpty()) {
            return this.checkMatchAndIndex(this.excludedFieldPatterns, this.excludedFields, path, isHeader);
        }
        return false;
    }

    public boolean isRepeatedFirst(String path, boolean isHeader) {
        boolean isRepeated = this.checkMatchAndIndex(this.listSchema.repeatFields(), this.repeatedFields, path, isHeader);
        if (isRepeated && isHeader && GlobUtils.matchesOneOfPatterns(path, this.listSchema.repeatEachRow())) {
            int fieldI = this.repeatedFields.size() - 1;
            this.repeatedAllRowsIndexes.set(fieldI);
        }
        return isRepeated;
    }

    public boolean isRepeatedAllRows(int fieldI) {
        return this.repeatedAllRowsIndexes.get(fieldI);
    }

    public String prefix() {
        if (this.prefix == null) {
            return this.listSchema.prefix();
        }
        return this.prefix;
    }

    private boolean checkMatchAndIndex(Collection<String> fieldPatterns, Set<String> fields, String path, boolean isHeader) {
        boolean isMatch;
        if (isHeader) {
            isMatch = GlobUtils.matchesOneOfPatterns(path, fieldPatterns);
            if (isMatch) {
                fields.add(path);
            }
        } else {
            isMatch = fields.contains(path);
        }
        return isMatch;
    }

    @Generated
    public ListConversionMeta(String name, ListConversionSchema listSchema, Set<String> excludedFieldPatterns, Set<String> includedFieldPatterns) {
        this.name = name;
        this.listSchema = listSchema;
        this.excludedFieldPatterns = excludedFieldPatterns;
        this.includedFieldPatterns = includedFieldPatterns;
    }

    @Generated
    public String toString() {
        return "ListConversionMeta(name=" + this.name() + ", listSchema=" + String.valueOf(this.listSchema) + ", excludedFieldPatterns=" + String.valueOf(this.excludedFieldPatterns) + ", includedFieldPatterns=" + String.valueOf(this.includedFieldPatterns) + ", excludedFields=" + String.valueOf(this.excludedFields) + ", includedFields=" + String.valueOf(this.includedFields) + ", repeatedFields=" + String.valueOf(this.repeatedFields) + ", repeatedAllRowsIndexes=" + String.valueOf(this.repeatedAllRowsIndexes) + ", prefix=" + this.prefix() + ")";
    }

    @Generated
    public String name() {
        return this.name;
    }

    @Generated
    public ListConversionMeta prefix(String prefix) {
        this.prefix = prefix;
        return this;
    }
}

