/*
 * Decompiled with CFR 0.152.
 */
package hdi.edi.csv;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import hdi.edi.csv.ListConversionStrategy;
import hdi.util.GlobUtils;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
public class ListConversionSchema {
    private final Set<String> names = new LinkedHashSet<String>();
    private String prefix;
    private String fileSuffix;
    private boolean isDisabled;
    private ListConversionStrategy strategy = ListConversionStrategy.COLUMNS;
    private int numberOfColumnRepeats = 3;
    @JsonProperty(value="output")
    private boolean isWriteOutput = true;
    private final Set<String> repeatFields = new LinkedHashSet<String>();
    private final Set<String> repeatEachRow = new LinkedHashSet<String>();

    public ListConversionSchema(String listName, ListConversionStrategy strategy) {
        this.names.add(listName);
        this.setStrategy(strategy);
    }

    @JsonSetter
    public void setStrategy(ListConversionStrategy strategy) {
        this.strategy = strategy;
        if (strategy == ListConversionStrategy.ROWS) {
            this.numberOfColumnRepeats = 1;
        }
    }

    @JsonSetter
    public void setRepeatFields(Collection<String> repeatFields) {
        this.repeatFields.clear();
        this.repeatFields.addAll(repeatFields);
    }

    @JsonSetter
    public void setNames(Collection<String> namesToSet) {
        for (String name : namesToSet) {
            if (StringUtils.equalsIgnoreCase((CharSequence)"Main", (CharSequence)name)) {
                this.setStrategy(ListConversionStrategy.ROWS);
            }
            this.names.add(name);
        }
    }

    public boolean matches(String name) {
        return GlobUtils.matchesOneOfPatterns(name, this.names);
    }

    @Generated
    public Set<String> names() {
        return this.names;
    }

    @Generated
    public String prefix() {
        return this.prefix;
    }

    @Generated
    public String fileSuffix() {
        return this.fileSuffix;
    }

    @Generated
    public boolean isDisabled() {
        return this.isDisabled;
    }

    @Generated
    public ListConversionStrategy strategy() {
        return this.strategy;
    }

    @Generated
    public int numberOfColumnRepeats() {
        return this.numberOfColumnRepeats;
    }

    @JsonProperty(value="output")
    @Generated
    public boolean isWriteOutput() {
        return this.isWriteOutput;
    }

    @Generated
    public Set<String> repeatFields() {
        return this.repeatFields;
    }

    @Generated
    public Set<String> repeatEachRow() {
        return this.repeatEachRow;
    }

    @Generated
    public String toString() {
        return "ListConversionSchema(names=" + String.valueOf(this.names()) + ", prefix=" + this.prefix() + ", fileSuffix=" + this.fileSuffix() + ", isDisabled=" + this.isDisabled() + ", strategy=" + String.valueOf((Object)this.strategy()) + ", numberOfColumnRepeats=" + this.numberOfColumnRepeats() + ", isWriteOutput=" + this.isWriteOutput() + ", repeatFields=" + String.valueOf(this.repeatFields()) + ", repeatEachRow=" + String.valueOf(this.repeatEachRow()) + ")";
    }

    @Generated
    public ListConversionSchema() {
    }
}

