/*
 * Decompiled with CFR 0.152.
 */
package hdi.edi.csv;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import hdi.edi.csv.CsvUtils;
import hdi.util.GlobUtils;
import java.util.LinkedHashSet;
import java.util.Set;
import lombok.Generated;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
public class ObjectConversionSchema {
    private final Set<String> names = new LinkedHashSet<String>();
    private String prefix;
    private boolean isDisabled;
    private final Set<String> includedFields = new LinkedHashSet<String>();
    private final Set<String> excludedFields = new LinkedHashSet<String>();

    public ObjectConversionSchema(String includedFields) {
        this.addIncludedFields(includedFields);
    }

    public boolean isFieldIncluded(String fieldName) {
        if (this.includedFields.isEmpty()) {
            return true;
        }
        return this.includedFields.contains(fieldName);
    }

    public boolean isFieldExcluded(String fieldName) {
        if (this.excludedFields.isEmpty()) {
            return false;
        }
        return this.excludedFields.contains(fieldName);
    }

    public void addIncludedFields(String fieldsStr) {
        this.includedFields.addAll(CsvUtils.stringListToSet(fieldsStr));
    }

    public boolean matches(String name) {
        return GlobUtils.matchesOneOfPatterns(name, this.names);
    }

    @Generated
    public Set<String> names() {
        return this.names;
    }

    @Generated
    public String prefix() {
        return this.prefix;
    }

    @Generated
    public boolean isDisabled() {
        return this.isDisabled;
    }

    @Generated
    public Set<String> includedFields() {
        return this.includedFields;
    }

    @Generated
    public Set<String> excludedFields() {
        return this.excludedFields;
    }

    @Generated
    public String toString() {
        return "ObjectConversionSchema(names=" + String.valueOf(this.names()) + ", prefix=" + this.prefix() + ", isDisabled=" + this.isDisabled() + ", includedFields=" + String.valueOf(this.includedFields()) + ", excludedFields=" + String.valueOf(this.excludedFields()) + ")";
    }

    @Generated
    public ObjectConversionSchema() {
    }
}

