/*
 * Decompiled with CFR 0.152.
 */
package hdi.edi.csv;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.StreamReadFeature;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import hdi.edi.csv.ClaimCsv;
import hdi.edi.csv.ConversionSchema;
import hdi.edi.csv.CsvConversionException;
import hdi.edi.csv.IncludedExcludedFields;
import hdi.edi.csv.ListConversionSchema;
import hdi.edi.csv.ListConversionStrategy;
import hdi.edi.csv.PaymentCsv;
import hdi.edi.parser.TransactionType;
import hdi.model.claim.Claim;
import hdi.model.coverage.MemberCoverage;
import hdi.util.SchemaFileFormat;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
public class SchemaHolder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SchemaHolder.class);
    public static final String DEFAULT_SCHEMA_FILE_NAME = "csv_conversion.yaml";
    public static final String CONFIG_DIR = "conf";
    public static final String APP_HOME_ENV = "APP_HOME";
    public static final String CONF_DIR_ENV = "EDI_CONVERT_CONF_DIR";
    public static final String SCHEMA_FILE_ENV = "CSV_SCHEMA_FILE";
    private File schemaFile;
    private List<ConversionSchema> schemas = new ArrayList<ConversionSchema>();

    private ConversionSchema findSchemaAndPrep(TransactionType transactionType, String name) {
        ConversionSchema matchedSchema = this.findSchemaWithoutPrep(transactionType, name);
        return this.prepSchema(matchedSchema, transactionType);
    }

    private ConversionSchema findSchemaWithoutPrep(TransactionType transactionType, String name) {
        ConversionSchema matchedSchema;
        if (transactionType == TransactionType.DENTAL) {
            transactionType = TransactionType.PROF;
        }
        if (name == null) {
            name = DEFAULT_SCHEMA_FILE_NAME;
        }
        if ((matchedSchema = this.findLastMatchingSchemaOrNull(transactionType, name)) == null) {
            throw new CsvConversionException("Didn't find CSV schema for transaction type %s and name %s in %s", transactionType.ediCode(), name, this.schemaFile.getAbsolutePath());
        }
        matchedSchema = new ConversionSchema(matchedSchema);
        this.inheritFromBase(matchedSchema, transactionType);
        return matchedSchema;
    }

    @Nullable
    private ConversionSchema findLastMatchingSchemaOrNull(TransactionType transactionType, String name) {
        ConversionSchema matchedSchema = null;
        for (ConversionSchema schema : this.schemas) {
            if (!schema.matchesTransactionType(transactionType) || !schema.matchesName(name)) continue;
            matchedSchema = schema;
        }
        return matchedSchema;
    }

    public boolean hasSchema(String schemaName) {
        for (ConversionSchema schema : this.schemas) {
            if (!schema.matchesName(schemaName)) continue;
            return true;
        }
        return false;
    }

    public String findOrgSchemaName(String org, String schemaName, TransactionType transactionType) {
        String orgSchemaName = org + "-" + schemaName;
        ConversionSchema schema = this.findLastMatchingSchemaOrNull(transactionType, orgSchemaName);
        return schema != null ? schema.name() : null;
    }

    private ConversionSchema prepSchema(ConversionSchema sourceSchema, TransactionType transactionType) {
        sourceSchema.headerObject(this.getObjectForHeader(transactionType));
        sourceSchema.excludedFields().addAll(IncludedExcludedFields.getExcludedFields(transactionType));
        IncludedExcludedFields.populateObjectSchemas(sourceSchema, transactionType);
        sourceSchema.transactionTypeInUse(transactionType);
        return sourceSchema;
    }

    private void inheritFromBase(ConversionSchema schema, TransactionType transactionType) {
        if (schema.baseName() != null) {
            ConversionSchema baseSchema = this.findSchemaWithoutPrep(transactionType, schema.baseName());
            schema.mergeFromBaseSchema(baseSchema);
        }
    }

    public ConversionSchema findSchema(TransactionType transactionType) {
        return this.findSchema("default", transactionType);
    }

    public ConversionSchema findSchema(String schemaName, TransactionType transactionType) {
        return this.findSchema(schemaName, transactionType, List.of());
    }

    public ConversionSchema findSchema(String schemaName, TransactionType transactionType, List<String> listNamesAsRows) {
        ConversionSchema schema = this.findSchemaAndPrep(transactionType, schemaName);
        if (listNamesAsRows != null && !listNamesAsRows.isEmpty()) {
            for (String listName : listNamesAsRows) {
                ListConversionSchema newListSchema = new ListConversionSchema(listName, ListConversionStrategy.ROWS);
                ListConversionSchema existingListSchema = schema.getListSchema(listName);
                if (existingListSchema != null) {
                    newListSchema.setRepeatFields(existingListSchema.repeatFields());
                    newListSchema.repeatEachRow().addAll(existingListSchema.repeatEachRow());
                }
                schema.listSchemas().add(newListSchema);
            }
        }
        schema.initMeta(listNamesAsRows);
        return schema;
    }

    private Object getObjectForHeader(TransactionType transactionType) {
        return switch (transactionType) {
            case TransactionType.PAYMENT -> new PaymentCsv();
            case TransactionType.INST, TransactionType.PROF, TransactionType.DENTAL -> new ClaimCsv(new Claim(), transactionType);
            case TransactionType.MEMBER_COVERAGE -> {
                MemberCoverage member = new MemberCoverage();
                member.prepForCsv();
                yield member;
            }
            default -> null;
        };
    }

    public void addSchema(ConversionSchema schema) {
        this.schemas.add(schema);
    }

    public static SchemaHolder loadSchemas() {
        String conversionSchemaPath = System.getenv(SCHEMA_FILE_ENV);
        if (conversionSchemaPath != null) {
            File schemaFile = new File(conversionSchemaPath);
            if (!schemaFile.exists()) {
                throw new CsvConversionException("CSV conversion schema file '%s' does not exist. The path was defined by the environment variable '%s'.", schemaFile.getAbsolutePath(), SCHEMA_FILE_ENV);
            }
            return SchemaHolder.readSchema(schemaFile);
        }
        conversionSchemaPath = DEFAULT_SCHEMA_FILE_NAME;
        return SchemaHolder.loadSchemas(conversionSchemaPath);
    }

    public static SchemaHolder loadSchemas(String schemaFileName) {
        File schemaFile = new File(schemaFileName);
        if (schemaFile.exists()) {
            return SchemaHolder.readSchema(schemaFile);
        }
        File confDir = SchemaHolder.getConfigDir();
        schemaFile = new File(confDir, schemaFileName);
        if (!schemaFile.exists()) {
            if (!DEFAULT_SCHEMA_FILE_NAME.equals(schemaFileName)) {
                throw new CsvConversionException("CSV conversion schema file '%s' does not exist. Define %s environment variable with its location.", schemaFile.getAbsolutePath(), SCHEMA_FILE_ENV);
            }
            return SchemaHolder.readSchemaFromResource(DEFAULT_SCHEMA_FILE_NAME);
        }
        return SchemaHolder.readSchema(schemaFile);
    }

    private static File getConfigDir() {
        File configDir;
        String confDirPath = System.getenv(CONF_DIR_ENV);
        if (confDirPath != null) {
            configDir = new File(confDirPath);
            if (!configDir.exists()) {
                throw new CsvConversionException("The conversion schema's location '%s' not exist. This location was provided by '%s' environment variable", configDir.getAbsolutePath(), CONF_DIR_ENV);
            }
        } else {
            String appHomePath = System.getenv(APP_HOME_ENV);
            configDir = appHomePath != null ? new File(appHomePath, CONFIG_DIR) : new File(CONFIG_DIR);
        }
        return configDir;
    }

    public static SchemaHolder readSchema(File schemaFile) {
        SchemaHolder schemaHolder;
        try (BufferedReader reader = new BufferedReader(new FileReader(schemaFile));){
            schemaHolder = SchemaHolder.readSchema(reader, SchemaFileFormat.fromFileName(schemaFile.getName()));
        }
        schemaHolder.schemaFile = schemaFile;
        return schemaHolder;
    }

    public static SchemaHolder readSchemaFromResource(String schemaFileName) {
        SchemaHolder schemaHolder;
        try (InputStream resourceInputStream = SchemaHolder.class.getClassLoader().getResourceAsStream(schemaFileName);){
            if (resourceInputStream == null) {
                throw new CsvConversionException("CSV conversion schema resource '%s' does not exist. Define %s environment variable with its location.", schemaFileName, CONF_DIR_ENV);
            }
            schemaHolder = SchemaHolder.readSchema(new InputStreamReader(resourceInputStream), SchemaFileFormat.fromFileName(schemaFileName));
            schemaHolder.schemaFile = new File("./", schemaFileName);
        }
        return schemaHolder;
    }

    private static SchemaHolder readSchema(Reader reader, SchemaFileFormat schemaFileFormat) {
        ObjectMapper mapper = ((JsonMapper.Builder)JsonMapper.builder((JsonFactory)schemaFileFormat.objectMapperFactory()).enable(new StreamReadFeature[]{StreamReadFeature.INCLUDE_SOURCE_IN_LOCATION})).build();
        List schemas = (List)mapper.readValue(reader, (TypeReference)new TypeReference<List<ConversionSchema>>(){});
        SchemaHolder schemaHolder = new SchemaHolder();
        for (ConversionSchema schema : schemas) {
            schemaHolder.addSchema(schema);
        }
        return schemaHolder;
    }

    @Generated
    public SchemaHolder() {
    }

    @Generated
    public String toString() {
        return "SchemaHolder(schemaFile=" + String.valueOf(this.schemaFile()) + ", schemas=" + String.valueOf(this.schemas) + ")";
    }

    @Generated
    public File schemaFile() {
        return this.schemaFile;
    }
}

