/*
 * Decompiled with CFR 0.152.
 */
package hdi.edi.dict;

import hdi.codeent.PrimaryCodeType;
import hdi.edi.dict.DictField;
import hdi.edi.dict.VariantType;
import hdi.edi.dict.annotations.EdiObj;
import hdi.edi.dict.annotations.ObjType;
import hdi.edi.dict.annotations.Prop;
import hdi.edi.objmapper.annotations.EdiElt;
import hdi.edi.parser.DataType;
import hdi.edi.parser.EdiFormattingUtils;
import hdi.edi.parser.SegmentType;
import hdi.edi.parser.TransactionType;
import hdi.edi.qualifier.EdiQualifier;
import hdi.util.FilesUtils;
import hdi.util.ReflectionUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DictMgr {
    public static final String CONVERTED_EXAMPLES_ROOT = "https://github.com/Healthcare-Data-Insight/api-examples/tree/main/converted_files";
    public static final String INTERACTIVE_EXAMPLES_ROOT = "https://datainsight.health/edi/";
    public static final String OPEN_API_SCHEMA_ROOT = "https://github.com/Healthcare-Data-Insight/api-examples/blob/main/openapi/components/schemas/model/";

    public static List<String> getExcludedFieldsForTransaction(Class<?> clazz, TransactionType transactionType, String prefix) {
        List<Field> fields = ReflectionUtils.getFields(clazz, true);
        ArrayList<String> excludedFields = new ArrayList<String>();
        for (Field field : fields) {
            Prop prop = DictMgr.getPropAnnForField(field);
            if (prop == null || DictMgr.matchesTranType(prop, transactionType)) continue;
            Object name = field.getName();
            if (prefix != null) {
                name = prefix + (String)name;
            }
            excludedFields.add((String)name);
        }
        return excludedFields;
    }

    public static String genClassDesc(Class<?> clazz, TransactionType tranType, String typeName, ObjType baseObjType) {
        EdiObj ediObjAnn = clazz.getAnnotation(EdiObj.class);
        StringBuilder buf = new StringBuilder();
        StringBuilder loopSeg = new StringBuilder();
        if (ediObjAnn != null) {
            String desc = DictMgr.getDescForTran(ediObjAnn.desc(), tranType);
            if (StringUtils.isNotBlank((CharSequence)desc)) {
                buf.append("<div class='obj-desc'>").append(StringUtils.trim((String)desc)).append("</div>").append(System.lineSeparator());
            }
            DictMgr.addLabelAndValForObjDesc(loopSeg, "Loop", ediObjAnn.loop(), tranType);
            DictMgr.addLabelAndValForObjDesc(loopSeg, "Segment", ediObjAnn.seg(), tranType);
            DictMgr.addLabelAndValForExample(loopSeg, "JSON Example", ediObjAnn.jsonExample(), tranType, CONVERTED_EXAMPLES_ROOT, "json");
            DictMgr.addLabelAndValForExample(loopSeg, "CSV Example", ediObjAnn.csvExample(), tranType, CONVERTED_EXAMPLES_ROOT, "csv");
            DictMgr.addLabelAndValForExample(loopSeg, "Interactive Example", ediObjAnn.interactiveExample(), tranType, INTERACTIVE_EXAMPLES_ROOT, null);
        }
        DictMgr.addOpenApiSchemaLink(loopSeg, typeName);
        if (!loopSeg.isEmpty()) {
            buf.append("<div class='obj-edi-examples'>").append((CharSequence)loopSeg).append("</div>").append(System.lineSeparator());
        }
        if (baseObjType != null) {
            String href = baseObjType.link();
            buf.append("<div class='obj-desc'>").append("Extends: ").append("<a href='").append(href).append("'>").append(baseObjType.typeName()).append("</a>").append("</div>").append(System.lineSeparator());
        }
        return buf.toString();
    }

    private static void addOpenApiSchemaLink(StringBuilder buf, String typeName) {
        if (typeName != null) {
            DictMgr.genExampleLink(buf, "Open API Schema", typeName, OPEN_API_SCHEMA_ROOT, "yaml");
        }
    }

    public static List<DictField> getDictFields(Class<?> clazz, TransactionType tranType, SegmentType ... segTypes) {
        List<DictField> allDictFields = DictMgr.createDictFieldsFromAnnotation(clazz, tranType, null, null);
        ArrayList<DictField> dictFieldsForSegment = new ArrayList<DictField>();
        for (DictField df : allDictFields) {
            for (SegmentType st : segTypes) {
                if (!df.setDesignatorAndQualifierIfMatches(st)) continue;
                dictFieldsForSegment.add(df);
            }
        }
        return dictFieldsForSegment;
    }

    public static List<DictField> createDictFieldsFromAnnotation(Class<?> clazz, TransactionType tranType, PrimaryCodeType primaryCodeType) {
        return DictMgr.createDictFieldsFromAnnotation(clazz, tranType, null, primaryCodeType);
    }

    public static List<DictField> createDictFieldsFromAnnotation(Class<?> clazz, TransactionType tranType, VariantType variantType, PrimaryCodeType primaryCodeType) {
        return DictMgr.createDictFieldsFromAnnotation(clazz, tranType, variantType, primaryCodeType, true);
    }

    public static List<DictField> createDictFieldsFromAnnotation(Class<?> clazz, TransactionType tranType, VariantType variantType, PrimaryCodeType primaryCodeType, boolean includeSuperClassFields) {
        List<Field> fields = ReflectionUtils.getFields(clazz, includeSuperClassFields);
        ArrayList<DictField> dictFields = new ArrayList<DictField>();
        for (Field field : fields) {
            Prop prop = DictMgr.getPropAnnForField(field);
            if (prop != null) {
                if (!DictMgr.matchesVariant(prop, variantType) || prop.isIgnored() || !DictMgr.matchesTranType(prop, tranType) || (primaryCodeType != null || prop.codeTypeFieldFilter() != PrimaryCodeType.NONE) && (primaryCodeType == null || prop.codeTypeFieldFilter() != primaryCodeType && prop.codeTypeFieldFilter() != PrimaryCodeType.NONE)) continue;
                DictField dictField = DictMgr.dictFieldFromPropAnn(field, prop, tranType);
                dictFields.add(dictField);
                continue;
            }
            EdiElt ediElt = field.getAnnotation(EdiElt.class);
            if (ediElt == null || ediElt.pos() <= 0 || !StringUtils.isNotBlank((CharSequence)ediElt.seg()) || !DictMgr.matchesTranType(ediElt.tran(), tranType)) continue;
            DictField dictField = DictMgr.dictFieldFromEdiEltAnn(field, ediElt, tranType);
            dictFields.add(dictField);
        }
        return dictFields;
    }

    public static List<DictField> getAllDictFields(Class<?> clazz, TransactionType primaryTranType) {
        List<Field> fields = ReflectionUtils.getFields(clazz, true);
        ArrayList<DictField> dictFields = new ArrayList<DictField>();
        for (Field field : fields) {
            Prop prop = DictMgr.getPropAnnForField(field);
            if (prop != null) {
                DictField dictField = DictMgr.dictFieldFromPropAnn(field, prop, primaryTranType);
                dictFields.add(dictField);
                continue;
            }
            EdiElt ediElt = field.getAnnotation(EdiElt.class);
            if (ediElt == null || ediElt.pos() <= 0 || !StringUtils.isNotBlank((CharSequence)ediElt.seg())) continue;
            DictField dictField = DictMgr.dictFieldFromEdiEltAnn(field, ediElt, primaryTranType);
            dictFields.add(dictField);
        }
        return dictFields;
    }

    @Nullable
    private static Prop getPropAnnForField(Field field) {
        Prop prop = field.getAnnotation(Prop.class);
        if (prop == null) {
            Class<?> owningClass = field.getDeclaringClass();
            EdiObj ediObjAnn = owningClass.getAnnotation(EdiObj.class);
            if (ediObjAnn != null && !ediObjAnn.masterClass().equals(Void.class)) {
                prop = DictMgr.getPropAnnFromMasterClass(field, ediObjAnn.masterClass(), null);
            }
            return prop;
        }
        if (prop.masterClass() != null && !prop.masterClass().equals(Void.class)) {
            prop = DictMgr.getPropAnnFromMasterClass(field, prop.masterClass(), prop.fieldName());
        }
        return prop;
    }

    private static boolean matchesTranType(Prop prop, TransactionType tranType) {
        return DictMgr.matchesTranType(prop.tran(), tranType);
    }

    private static boolean matchesTranType(TransactionType[] transTypes, TransactionType tranType) {
        for (TransactionType tran : transTypes) {
            if (tran != TransactionType.UNKNOWN && tran != TransactionType.ALL && tran != tranType) continue;
            return true;
        }
        return false;
    }

    private static void addLabelAndValForExample(StringBuilder buf, String label, String[] vals, TransactionType tranType, String urlRoot, String extension) {
        String fileName = DictMgr.getDescForTran(vals, tranType);
        DictMgr.genExampleLink(buf, label, fileName, urlRoot, extension);
    }

    private static void genExampleLink(StringBuilder buf, String label, String fileName, String urlRoot, String extension) {
        if (StringUtils.isBlank((CharSequence)fileName)) {
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)extension)) {
            fileName = FilesUtils.replaceExt(fileName, extension);
        }
        String url = DictMgr.genClassHeaderLink(label, urlRoot, fileName);
        if (!buf.isEmpty()) {
            buf.append(" ");
        }
        buf.append(url);
    }

    @NotNull
    public static String genClassHeaderLink(String label, String urlRoot, String fileName) {
        if (!StringUtils.endsWith((CharSequence)urlRoot, (CharSequence)"/")) {
            urlRoot = (String)urlRoot + "/";
        }
        String href = (String)urlRoot + fileName;
        return "<a class='file-example-link' href='" + href + "' target='_blank'>" + label + "</a>";
    }

    private static void addLabelAndValForObjDesc(StringBuilder buf, String label, String[] vals, TransactionType tranType) {
        Object s = DictMgr.getDescForTran(vals, tranType);
        if (StringUtils.isBlank((CharSequence)s)) {
            return;
        }
        s = label + ": " + (String)s;
        if (!buf.isEmpty()) {
            buf.append(", ");
        }
        buf.append((String)s);
    }

    private static boolean matchesVariant(Prop prop, VariantType variantType) {
        if (variantType == null) {
            return true;
        }
        for (VariantType vt : prop.variantTypes()) {
            if (vt == VariantType.NONE && !variantType.isOnlyMatched()) {
                return true;
            }
            if (vt != variantType) continue;
            return true;
        }
        return false;
    }

    private static DictField dictFieldFromEdiEltAnn(Field field, EdiElt ediEltAnn, TransactionType transactionType) {
        DictField dictField = new DictField();
        dictField.field(field).transactionType(transactionType).name(field.getName()).objType(ObjType.NONE).desc(ediEltAnn.desc()).isRequired(ediEltAnn.isRequired()).allowedTransactionTypes(List.of(ediEltAnn.tran())).type(DataType.fromClass(field.getType()));
        String edi = ediEltAnn.seg() + EdiFormattingUtils.formatEltPos(ediEltAnn.pos());
        dictField.addEdiAndQualifier(edi, null);
        return dictField;
    }

    @NotNull
    private static DictField dictFieldFromPropAnn(Field field, Prop prop, TransactionType transactionType) {
        DictField dictField = new DictField();
        dictField.field(field).transactionType(transactionType).name(field.getName()).type(DataType.fromClass(field.getType())).typeName(prop.typeName()).minWidth(prop.minWidth()).maxWidth(prop.maxWidth()).objType(prop.objType()).isDerived(prop.isDerived()).relatedFieldName(DictMgr.getStringForTransaction(prop.relatedFieldName(), transactionType)).ignoreForEdiGen(prop.ignoreForEdiGen()).isRequired(prop.isRequired()).variantTypes(List.of(prop.variantTypes())).allowedTransactionTypes(List.of(prop.tran())).codeLookupQuery(prop.codeLookupQuery()).codeType(prop.codeType());
        if (StringUtils.isNotBlank((CharSequence)prop.name())) {
            dictField.name(prop.name());
        }
        String loop = DictMgr.getDescForTran(prop.loop(), transactionType);
        dictField.loop(loop);
        if (prop.objType() != ObjType.NONE) {
            ObjType objType = prop.objType().getTypeForTran(transactionType);
            dictField.objType(objType);
        }
        String desc = DictMgr.getDescForTran(prop.desc(), transactionType);
        dictField.desc(desc);
        if (!DictMgr.populateBasedOnQualifier(dictField, prop, transactionType)) {
            for (String ediElt : prop.edi()) {
                String ediWithoutTran = DictMgr.getStringForTransaction(ediElt, transactionType);
                if (ediWithoutTran == null) continue;
                dictField.addEdiAndQualifier(ediWithoutTran, null);
            }
        }
        if (!dictField.isRequired()) {
            for (String required : prop.required()) {
                String requiredIndicator = DictMgr.getStringForTransaction(required, transactionType);
                if (!StringUtils.equalsIgnoreCase((CharSequence)requiredIndicator, (CharSequence)"Y")) continue;
                dictField.isRequired(true);
            }
        }
        return dictField;
    }

    private static String getDescForTran(String[] descItems, TransactionType transactionType) {
        StringBuilder buf = new StringBuilder();
        for (String desc : descItems) {
            String descWithoutTran = DictMgr.getStringForTransaction(desc, transactionType);
            if (descWithoutTran == null) continue;
            if (!buf.isEmpty()) {
                buf.append("<br/>");
            }
            buf.append(descWithoutTran);
        }
        return buf.toString();
    }

    @NotNull
    private static Prop getPropAnnFromMasterClass(Field field, Class<?> masterClass, String fieldNameOverride) {
        Prop prop;
        String fieldName = field.getName();
        if (StringUtils.isNotBlank((CharSequence)fieldNameOverride)) {
            fieldName = fieldNameOverride;
        }
        if ((prop = DictMgr.findAnnotationForField(masterClass, fieldName)) == null) {
            throw new RuntimeException("Cannot find annotation for master class " + masterClass.getName() + " for field " + field.getName());
        }
        return prop;
    }

    private static String getStringForTransaction(String s, TransactionType transactionType) {
        if (transactionType == TransactionType.UNKNOWN || transactionType == null) {
            return s;
        }
        String[] parts = StringUtils.split((String)s, (String)":", (int)2);
        if (parts == null || parts.length < 2) {
            return StringUtils.trim((String)s);
        }
        String tranPrefix = StringUtils.trim((String)parts[0]);
        if (StringUtils.equalsIgnoreCase((CharSequence)tranPrefix, (CharSequence)transactionType.ediCode()) || StringUtils.equalsIgnoreCase((CharSequence)tranPrefix, (CharSequence)StringUtils.left((String)transactionType.ediCode(), (int)3))) {
            s = StringUtils.trim((String)parts[1]);
            return s;
        }
        return null;
    }

    private static Prop findAnnotationForField(Class<?> clazz, String fieldName) {
        List fields = FieldUtils.getFieldsListWithAnnotation(clazz, Prop.class);
        for (Field field : fields) {
            Prop prop = field.getAnnotation(Prop.class);
            if (prop == null || !field.getName().equals(fieldName)) continue;
            return prop;
        }
        return null;
    }

    private static boolean populateBasedOnQualifier(DictField dictField, Prop prop, TransactionType transactionType) {
        boolean isPopulated = DictMgr.populateQualifiers(dictField, prop.dateType(), prop, transactionType);
        if (!isPopulated) {
            isPopulated = DictMgr.populateQualifier(dictField, prop.amtType(), prop, transactionType);
        }
        if (!isPopulated) {
            isPopulated = DictMgr.populateQualifiers(dictField, prop.quantityType(), prop, transactionType);
        }
        if (!isPopulated) {
            isPopulated = DictMgr.populateQualifiers(dictField, prop.refType(), prop, transactionType);
        }
        if (!isPopulated) {
            isPopulated = DictMgr.populateQualifier(dictField, prop.entityRole(), prop, transactionType);
        }
        if (!isPopulated) {
            isPopulated = DictMgr.populateQualifiers(dictField, prop.diagType(), prop, transactionType);
        }
        if (!isPopulated) {
            isPopulated = DictMgr.populateQualifiers(dictField, prop.procType(), prop, transactionType);
        }
        if (!isPopulated) {
            isPopulated = DictMgr.populateQualifiers(dictField, prop.ubType(), prop, transactionType);
        }
        return isPopulated;
    }

    private static boolean populateQualifiers(DictField dictField, EdiQualifier[] ediQualifiers, Prop prop, TransactionType transactionType) {
        boolean isPopulated = false;
        int tranI = 0;
        for (TransactionType transactionType2 : prop.tran()) {
            if (transactionType2 == transactionType) break;
            ++tranI;
        }
        if (ediQualifiers.length > tranI && prop.tran().length > 1) {
            EdiQualifier ediQualifier = ediQualifiers[tranI];
            if (DictMgr.populateQualifier(dictField, ediQualifier, prop, transactionType)) {
                isPopulated = true;
            }
        } else {
            for (EdiQualifier ediQualifier : ediQualifiers) {
                if (!DictMgr.populateQualifier(dictField, ediQualifier, prop, transactionType)) continue;
                isPopulated = true;
            }
        }
        return isPopulated;
    }

    private static boolean populateQualifier(DictField dictField, EdiQualifier ediQualifier, Prop prop, TransactionType transactionType) {
        boolean isPopulated = false;
        if (ediQualifier != null && !StringUtils.equalsIgnoreCase((CharSequence)ediQualifier.name(), (CharSequence)"NONE")) {
            if (StringUtils.isNotBlank((CharSequence)prop.edi()[0])) {
                for (String ediElement : prop.edi()) {
                    String ediWithoutTran = DictMgr.getStringForTransaction(ediElement, transactionType);
                    if (ediWithoutTran == null) continue;
                    dictField.addEdiAndQualifier(ediWithoutTran, ediQualifier);
                }
            } else {
                dictField.addEdiAndQualifier(ediQualifier.ediEltId(), ediQualifier);
            }
            isPopulated = true;
        }
        return isPopulated;
    }
}

