/*
 * Decompiled with CFR 0.152.
 */
package hdi.edi.dict.annotations;

import hdi.codeent.CodeDesc;
import hdi.codeent.CodeEntity;
import hdi.codeent.PrimaryCodeType;
import hdi.codeent.Procedure;
import hdi.edi.EdiTransaction;
import hdi.edi.dict.VariantType;
import hdi.edi.fileinfo.FileInfo;
import hdi.edi.parser.TransactionType;
import hdi.model.Amount;
import hdi.model.Attachment;
import hdi.model.DateTimePeriod;
import hdi.model.ErrorInfo;
import hdi.model.LineAdjudication;
import hdi.model.Quantity;
import hdi.model.Reference;
import hdi.model.coverage.HealthCoverage;
import hdi.model.coverage.Member;
import hdi.model.coverage.ReportingCategory;
import hdi.model.coverage.TpaWithAccountInfo;
import hdi.model.dental.OrthodonticInfo;
import hdi.model.dental.ToothInfo;
import hdi.model.dental.ToothStatus;
import hdi.model.orgperson.Address;
import hdi.model.orgperson.ContactInfo;
import hdi.model.orgperson.ContactNumber;
import hdi.model.orgperson.OrgOrPerson;
import hdi.model.orgperson.PartyIdName;
import hdi.model.patientsubscriber.PatientSubscriber835;
import hdi.model.payment.InpatientAdjudication;
import hdi.model.payment.OutpatientAdjudication;
import hdi.model.payment.ProviderAdjustment;
import hdi.model.payment.ProviderAdjustmentReasonAmount;
import hdi.model.status.BatchStatus;
import hdi.model.status.ClaimStatus;
import hdi.model.status.ServiceLineStatus;
import hdi.model.status.StatusCodeInfo;
import hdi.model.status.StatusInfo;
import hdi.util.WordStringUtils;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public enum ObjType {
    TRANSACTION(null, null, null),
    TRANSACTION_835(null, null, null),
    TRANSACTION_837(null, null, null),
    TRANSACTION_277(null, null, null),
    TRANSACTION_834(null, null, null),
    PARTY(null, null, null),
    PARTY_ID_NAME(null, null, null),
    PROVIDER(null, null, null),
    SUBSCRIBER(null, null, null),
    OTHER_SUBSCRIBER(null, null, null),
    PATIENT(null, null, null),
    PATIENT_SUBSCRIBER_835(null, "#patient-subscriber", null),
    MEMBER(null, null, null),
    PERSON_WITH_DEMOGRAPHIC(null, null, null),
    REFERENCE("Reference", null, null),
    AMOUNT(null, null, null),
    DATE(null, null, null),
    QUANTITY(null, null, null),
    CONTACT_INFO(null, null, null),
    CONTACT_NUMBER(null, null, null),
    ADJUSTMENT(null, null, null),
    PROVIDER_ADJUSTMENT(null, null, null),
    PROVIDER_ADJUSTMENT_REASON_AMOUNT(null, null, null),
    ADJUDICATION(null, null, null),
    INPATIENT_ADJUDICATION(null, null, null),
    OUTPATIENT_ADJUDICATION(null, null, null),
    REPORTING_CATEGORY(null, null, null),
    ATTACHMENT(null, null, null),
    ADDRESS(null, null, null),
    LINE("ServiceLine", "#line", null),
    PROF_LINE(null, null, null),
    INST_LINE(null, null, null),
    DENT_LINE(null, null, null),
    PAYMENT_LINE(null, null, null),
    PROF_LINE_CSV(null, "#line", null),
    INST_LINE_CSV(null, "#line", null),
    PAYMENT_LINE_CSV(null, "#line", null),
    CODE("Code", null, null),
    PROCEDURE(null, null, PrimaryCodeType.PROCEDURE),
    PROCEDURE_NO_MODS("Code", null, PrimaryCodeType.PROCEDURE),
    PROCEDURE_WITH_DATE("CodeAndDate", "#code-and-date", PrimaryCodeType.PROCEDURE),
    CODE_AND_DATE(null, null, null),
    CODE_AND_AMOUNT(null, null, PrimaryCodeType.UB04_VALUE_CODE),
    DIAG("Code", null, PrimaryCodeType.DIAGNOSIS),
    INST_DIAGNOSIS(null, null, null),
    REV_CODE("Code", null, PrimaryCodeType.UB04_REVENUE_CODE),
    OCCURRENCE("CodeAndDate", "#code-and-date", PrimaryCodeType.UB04_OCCURRENCE_CODE),
    OCCURRENCE_SPAN("CodeAndDate", "#code-and-date", PrimaryCodeType.UB04_OCCURRENCE_SPAN_CODE),
    CONDITION("Code", null, PrimaryCodeType.UB04_CONDITION_CODE),
    DRUG("Code", null, PrimaryCodeType.DRUG),
    FACILITY("Code", null, PrimaryCodeType.FACILITY_TYPE),
    HEALTH_COVERAGE(null, null, null),
    COB("CoordinationOfBenefits", "#cob", null),
    TPA(null, null, null),
    CLAIM_STATUS(null, null, null),
    STATUS_INFO(null, null, null),
    STATUS_CODE_INFO(null, null, null),
    SERVICE_LINE_STATUS(null, null, null),
    BATCH_STATUS(null, null, null),
    ORTHODONTIC_INFO(null, null, null),
    TOOTH_STATUS(null, null, null),
    TOOTH_INFO(null, null, null),
    INTEGER(null, null, null),
    STRING("String", null, null),
    ERROR_INFO(null, null, null),
    FILE_INFO(null, null, null),
    NONE(null, null, null);

    private final String typeName;
    private final String link;
    private final PrimaryCodeType codeType;

    public String typeName() {
        String nameToShow = this.typeName;
        if (nameToShow == null) {
            nameToShow = WordStringUtils.enumNameToObjName(this);
        }
        return nameToShow;
    }

    public String edi() {
        return switch (this.ordinal()) {
            case 15 -> "AMT";
            case 14 -> "REF";
            case 17 -> "QTY";
            case 16 -> "DTP";
            default -> "";
        };
    }

    public String link() {
        if (this == STRING || this == INTEGER) {
            return null;
        }
        String linkBasis = this.name();
        if (this.typeName != null) {
            linkBasis = this.typeName;
        }
        return this.link == null ? ObjType.linkFromType(linkBasis) : this.link;
    }

    private static String linkFromType(String enumName) {
        String link = enumName.toLowerCase();
        return "#" + StringUtils.replace((String)link, (String)"_", (String)"-");
    }

    public String shortcode() {
        String shortcode = this.name().toLowerCase();
        return "dict-" + StringUtils.replace((String)shortcode, (String)"_", (String)"-");
    }

    public ObjType baseType() {
        return switch (this.ordinal()) {
            case 38, 41, 42, 44 -> CODE;
            case 5 -> PARTY_ID_NAME;
            case 7, 13 -> PARTY;
            case 53 -> PARTY;
            case 12 -> PERSON_WITH_DEMOGRAPHIC;
            default -> null;
        };
    }

    public VariantType variantType() {
        return switch (this.ordinal()) {
            case 7 -> VariantType.PROVIDER;
            case 12 -> VariantType.MEMBER;
            case 13 -> VariantType.PERSON_WITH_DEMOGRAPHIC;
            case 44 -> VariantType.INST_DIAGNOSIS;
            case 41 -> VariantType.CODE_DATE;
            case 42 -> VariantType.CODE_AMOUNT;
            default -> null;
        };
    }

    public ObjType getTypeForTran(TransactionType transactionType) {
        if (this == INST_DIAGNOSIS && transactionType != TransactionType.INST) {
            return DIAG;
        }
        if (this == PROCEDURE_WITH_DATE && transactionType != TransactionType.INST) {
            return PROCEDURE_NO_MODS;
        }
        if ((this == SUBSCRIBER || this == PATIENT || this == OTHER_SUBSCRIBER) && transactionType == TransactionType.PAYMENT) {
            return PATIENT_SUBSCRIBER_835;
        }
        if (this == LINE) {
            return switch (transactionType) {
                case TransactionType.INST -> INST_LINE;
                case TransactionType.PROF -> PROF_LINE;
                case TransactionType.DENTAL -> DENT_LINE;
                case TransactionType.PAYMENT -> PAYMENT_LINE;
                default -> LINE;
            };
        }
        if (this == PROF_LINE_CSV && transactionType == TransactionType.INST) {
            return INST_LINE_CSV;
        }
        if (this == TRANSACTION) {
            return switch (transactionType) {
                case TransactionType.INST, TransactionType.PROF, TransactionType.DENTAL -> TRANSACTION_837;
                case TransactionType.PAYMENT -> TRANSACTION_835;
                case TransactionType.CLAIM_ACK -> TRANSACTION_277;
                case TransactionType.MEMBER_COVERAGE -> TRANSACTION_834;
                default -> TRANSACTION;
            };
        }
        return this;
    }

    public Class<?> clazz() {
        return switch (this.ordinal()) {
            case 54 -> ClaimStatus.class;
            case 55 -> StatusInfo.class;
            case 56 -> StatusCodeInfo.class;
            case 6 -> PartyIdName.class;
            case 5, 7, 13 -> OrgOrPerson.class;
            case 57 -> ServiceLineStatus.class;
            case 58 -> BatchStatus.class;
            case 37 -> CodeDesc.class;
            case 38 -> Procedure.class;
            case 39, 41, 42, 43, 44, 48 -> CodeEntity.class;
            case 23 -> LineAdjudication.class;
            case 21 -> ProviderAdjustment.class;
            case 22 -> ProviderAdjustmentReasonAmount.class;
            case 27 -> Attachment.class;
            case 24 -> InpatientAdjudication.class;
            case 25 -> OutpatientAdjudication.class;
            case 11 -> PatientSubscriber835.class;
            case 61 -> ToothInfo.class;
            case 60 -> ToothStatus.class;
            case 59 -> OrthodonticInfo.class;
            case 0 -> EdiTransaction.class;
            case 65 -> FileInfo.class;
            case 16 -> DateTimePeriod.class;
            case 15 -> Amount.class;
            case 17 -> Quantity.class;
            case 14 -> Reference.class;
            case 18 -> ContactInfo.class;
            case 19 -> ContactNumber.class;
            case 28 -> Address.class;
            case 64 -> ErrorInfo.class;
            case 53 -> TpaWithAccountInfo.class;
            case 26 -> ReportingCategory.class;
            case 12 -> Member.class;
            case 51 -> HealthCoverage.class;
            default -> throw new IllegalStateException("Class is not defined for " + String.valueOf((Object)this));
        };
    }

    @Generated
    public PrimaryCodeType codeType() {
        return this.codeType;
    }

    @Generated
    private ObjType(String typeName, String link, PrimaryCodeType codeType) {
        this.typeName = typeName;
        this.link = link;
        this.codeType = codeType;
    }
}

