/*
 * Decompiled with CFR 0.152.
 */
package hdi.edi.dict.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import hdi.edi.dict.DictField;
import hdi.edi.dict.DictMgr;
import hdi.edi.dict.openapi.GenRequest;
import hdi.edi.dict.openapi.OpenApiObj;
import hdi.edi.dict.openapi.OpenApiObjWithBase;
import hdi.edi.dict.openapi.OpenApiProp;
import hdi.util.SchemaFileFormat;
import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenApiGen {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OpenApiGen.class);
    private static final ObjectMapper YAML_OBJECT_MAPPER = new ObjectMapper(SchemaFileFormat.YAML.objectMapperFactory()).configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false).configure(SerializationFeature.INDENT_OUTPUT, true).configure(SerializationFeature.FLUSH_AFTER_WRITE_VALUE, false).configure(SerializationFeature.CLOSE_CLOSEABLE, false).disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS).setSerializationInclusion(JsonInclude.Include.NON_NULL).registerModule((Module)new JavaTimeModule());
    private final File baseDir;

    public void genObject(GenRequest genRequest) {
        this.genObject(null, genRequest);
    }

    public void genObject(File fileOrDir, GenRequest genRequest) {
        fileOrDir = fileOrDir != null ? new File(this.baseDir, fileOrDir.getPath()) : this.baseDir;
        try (Writer writer = this.openWriter(fileOrDir, genRequest);){
            this.genObjectToWriter(writer, genRequest);
        }
    }

    public String genObjectToString(GenRequest genRequest) {
        StringWriter writer = new StringWriter();
        this.genObjectToWriter(writer, genRequest);
        return writer.toString();
    }

    public void genObjectToWriter(Writer writer, GenRequest genRequest) {
        Class<?> clazz = genRequest.clazz();
        List<DictField> fields = DictMgr.createDictFieldsFromAnnotation(clazz, genRequest.transactionType(), genRequest.variantType(), genRequest.codeType(), !genRequest.isInherited());
        String objName = genRequest.typeName();
        OpenApiObj openApiObj = new OpenApiObj(objName);
        log.info("Generating schema {}, {} fields", (Object)objName, (Object)fields.size());
        for (DictField field : fields) {
            if (field.type().openApiDataType() == null) continue;
            OpenApiProp prop = OpenApiProp.fromDicField(field);
            openApiObj.addProp(prop);
            if (!field.isRequired()) continue;
            openApiObj.addRequired(prop.name());
        }
        String objDesc = DictMgr.genClassDesc(clazz, null, null, null);
        if (StringUtils.isNotBlank((CharSequence)objDesc)) {
            openApiObj.descr(objDesc);
        }
        Object objToSerialize = openApiObj;
        if (genRequest.baseType() != null) {
            objToSerialize = new OpenApiObjWithBase(genRequest.baseType(), openApiObj);
        }
        this.validateRefs(objToSerialize);
        YAML_OBJECT_MAPPER.writerWithDefaultPrettyPrinter().writeValue(writer, objToSerialize);
    }

    private void validateRefs(Object obj) {
        if (obj instanceof OpenApiObj) {
            OpenApiObj openApiObj = (OpenApiObj)obj;
            for (Map.Entry<String, OpenApiProp> prop : openApiObj.props().entrySet()) {
                File refFile;
                Map<String, String> items;
                OpenApiProp openApiProp = prop.getValue();
                String ref = openApiProp.getRef();
                if (ref == null && (items = openApiProp.getItemsForArray()) != null) {
                    ref = items.get("$ref");
                }
                if (ref == null || (refFile = new File(this.baseDir, ref)).exists()) continue;
                log.warn("Prop: {}: Reference file {} does not exist", (Object)prop.getKey(), (Object)refFile.getPath());
            }
        }
    }

    private Writer openWriter(File fileOrDir, GenRequest genRequest) {
        File outputFile = fileOrDir;
        if (fileOrDir.isDirectory()) {
            outputFile = new File(fileOrDir, genRequest.getFileName());
        }
        log.debug("Writing schema to {}", (Object)outputFile.getPath());
        return Files.newBufferedWriter(outputFile.toPath(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
    }

    @Generated
    public OpenApiGen(File baseDir) {
        this.baseDir = baseDir;
    }

    @Generated
    public File baseDir() {
        return this.baseDir;
    }
}

