/*
 * Decompiled with CFR 0.152.
 */
package hdi.edi.edient;

import hdi.edi.EdiTransaction;
import hdi.edi.edient.EdiEntity;
import hdi.edi.edient.HiCode;
import hdi.edi.edient.Hl;
import hdi.edi.edient.Lx;
import hdi.edi.parser.EdiParsingResults;
import hdi.edi.parser.EdiSeg;
import hdi.edi.parser.SegmentType;
import hdi.edi.parser.TransactionType;
import hdi.model.Amount;
import hdi.model.Attachment;
import hdi.model.DateTimePeriod;
import hdi.model.LineAdjudication;
import hdi.model.Note;
import hdi.model.Quantity;
import hdi.model.Reference;
import hdi.model.ServiceLine;
import hdi.model.claim.Claim;
import hdi.model.coverage.ChangeReason;
import hdi.model.coverage.CoordinationOfBenefits;
import hdi.model.coverage.Disability;
import hdi.model.coverage.HealthCoverage;
import hdi.model.coverage.IdCard;
import hdi.model.coverage.LanguageInfo;
import hdi.model.coverage.Member;
import hdi.model.coverage.MemberCoverage;
import hdi.model.coverage.ProviderWithChangeReason;
import hdi.model.coverage.ReportingCategory;
import hdi.model.coverage.TpaWithAccountInfo;
import hdi.model.dental.OrthodonticInfo;
import hdi.model.dental.ToothInfo;
import hdi.model.dental.ToothStatus;
import hdi.model.orgperson.Address;
import hdi.model.orgperson.ContactInfo;
import hdi.model.orgperson.OrgOrPerson;
import hdi.model.patientsubscriber.PatientSubscriber;
import hdi.model.payment.GroupedAdjustments;
import hdi.model.payment.InpatientAdjudication;
import hdi.model.payment.OutpatientAdjudication;
import hdi.model.payment.Payment;
import hdi.model.payment.ProviderAdjustment;
import hdi.model.status.BatchStatus;
import hdi.model.status.ClaimStatus;
import hdi.model.status.ProviderStatus;
import hdi.model.status.ReceiverStatus;
import hdi.model.status.ServiceLineStatus;
import hdi.model.status.StatusInfo;
import java.util.HashMap;
import java.util.Map;

public class EdiEntFactory {
    private final Map<SegmentType, Class<? extends EdiEntity>> entsBySegType = new HashMap<SegmentType, Class<? extends EdiEntity>>();
    private final Map<SegKey, Class<? extends EdiEntity>> entsBySegKey = new HashMap<SegKey, Class<? extends EdiEntity>>();

    public EdiEntFactory() {
        this.entsBySegType.put(SegmentType.NM1, OrgOrPerson.class);
        this.entsBySegType.put(SegmentType.N1, OrgOrPerson.class);
        this.entsBySegType.put(SegmentType.DTP, DateTimePeriod.class);
        this.entsBySegType.put(SegmentType.DTM, DateTimePeriod.class);
        this.entsBySegType.put(SegmentType.AMT, Amount.class);
        this.entsBySegType.put(SegmentType.QTY, Quantity.class);
        this.entsBySegType.put(SegmentType.CLM, Claim.class);
        this.entsBySegType.put(SegmentType.CLP, Payment.class);
        this.entsBySegType.put(SegmentType.SV1, ServiceLine.class);
        this.entsBySegType.put(SegmentType.SV2, ServiceLine.class);
        this.entsBySegType.put(SegmentType.SV3, ServiceLine.class);
        this.entsBySegType.put(SegmentType.SVC, ServiceLine.class);
        this.entsBySegType.put(SegmentType.N4, Address.class);
        this.entsBySegType.put(SegmentType.N3, Address.class);
        this.entsBySegType.put(SegmentType.HI, HiCode.class);
        this.entsBySegType.put(SegmentType.NTE, Note.class);
        this.entsBySegType.put(SegmentType.ST, EdiTransaction.class);
        this.entsBySegType.put(SegmentType.PAT, PatientSubscriber.class);
        this.entsBySegType.put(SegmentType.SBR, PatientSubscriber.class);
        this.entsBySegType.put(SegmentType.REF, Reference.class);
        this.entsBySegType.put(SegmentType.LX, Lx.class);
        this.entsBySegType.put(SegmentType.HL, Hl.class);
        this.entsBySegType.put(SegmentType.SVD, LineAdjudication.class);
        this.entsBySegType.put(SegmentType.CAS, GroupedAdjustments.class);
        this.entsBySegType.put(SegmentType.PER, ContactInfo.class);
        this.entsBySegType.put(SegmentType.PWK, Attachment.class);
        this.entsBySegType.put(SegmentType.TOO, ToothInfo.class);
        this.entsBySegType.put(SegmentType.DN1, OrthodonticInfo.class);
        this.entsBySegType.put(SegmentType.DN2, ToothStatus.class);
        this.entsBySegType.put(SegmentType.HD, HealthCoverage.class);
        this.entsBySegType.put(SegmentType.PLA, ChangeReason.class);
        this.entsBySegType.put(SegmentType.STC, StatusInfo.class);
        this.entsBySegType.put(SegmentType.LUI, LanguageInfo.class);
        this.entsBySegType.put(SegmentType.PLB, ProviderAdjustment.class);
        this.entsBySegType.put(SegmentType.MOA, OutpatientAdjudication.class);
        this.entsBySegType.put(SegmentType.MIA, InpatientAdjudication.class);
        this.entsBySegKey.put(new SegKey(SegmentType.INS, "2000", TransactionType.MEMBER_COVERAGE), MemberCoverage.class);
        this.entsBySegKey.put(new SegKey(SegmentType.NM1, "2310", TransactionType.MEMBER_COVERAGE), ProviderWithChangeReason.class);
        this.entsBySegKey.put(new SegKey(SegmentType.N1, "1000C", TransactionType.MEMBER_COVERAGE), TpaWithAccountInfo.class);
        this.entsBySegKey.put(new SegKey(SegmentType.NM1, "2100A", TransactionType.MEMBER_COVERAGE), Member.class);
        this.entsBySegKey.put(new SegKey(SegmentType.NM1, "2100B", TransactionType.MEMBER_COVERAGE), Member.class);
        this.entsBySegKey.put(new SegKey(SegmentType.COB, "2320", TransactionType.MEMBER_COVERAGE), CoordinationOfBenefits.class);
        this.entsBySegKey.put(new SegKey(SegmentType.N1, "2750", TransactionType.MEMBER_COVERAGE), ReportingCategory.class);
        this.entsBySegKey.put(new SegKey(SegmentType.DSB, "2200", TransactionType.MEMBER_COVERAGE), Disability.class);
        this.entsBySegKey.put(new SegKey(SegmentType.IDC, "2300", TransactionType.MEMBER_COVERAGE), IdCard.class);
        this.entsBySegKey.put(new SegKey(SegmentType.TRN, "2200D", TransactionType.CLAIM_ACK), ClaimStatus.class);
        this.entsBySegKey.put(new SegKey(SegmentType.SVC, "2220D", TransactionType.CLAIM_ACK), ServiceLineStatus.class);
        this.entsBySegKey.put(new SegKey(SegmentType.HL, "2000C", TransactionType.CLAIM_ACK), ProviderStatus.class);
        this.entsBySegKey.put(new SegKey(SegmentType.HL, "2000B", TransactionType.CLAIM_ACK), ReceiverStatus.class);
        this.entsBySegKey.put(new SegKey(SegmentType.TRN, "2200B", TransactionType.CLAIM_ACK), BatchStatus.class);
        this.entsBySegKey.put(new SegKey(SegmentType.TRN, "2200C", TransactionType.CLAIM_ACK), BatchStatus.class);
    }

    public EdiEntity createEntityForSeg(EdiSeg seg, EdiParsingResults results) {
        if (results != null) {
            for (EdiEntity ent : results.curTranEntities()) {
                boolean isPopulated = ent.populateFromSegMaster(seg, results);
                if (!isPopulated) continue;
                return ent;
            }
        }
        EdiEntity ediEnt = null;
        SegKey segKey = this.createSegKey(seg, results);
        Class<? extends EdiEntity> entClass = this.entsBySegKey.get(segKey);
        if (entClass == null) {
            entClass = this.entsBySegType.get((Object)seg.type());
        }
        if (entClass != null) {
            ediEnt = entClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            ediEnt.populateFromSegInitial(seg, results);
        }
        if (results != null && ediEnt != null) {
            ediEnt.loop(seg.loop());
            if (!seg.type().isOneOf(SegmentType.DTM, SegmentType.DTP, SegmentType.AMT, SegmentType.QTY, SegmentType.NTE, SegmentType.REF, SegmentType.PWK, SegmentType.MOA, SegmentType.MIA)) {
                results.add(ediEnt);
            }
        }
        return ediEnt;
    }

    private SegKey createSegKey(EdiSeg seg, EdiParsingResults results) {
        EdiTransaction tran = null;
        TransactionType tranType = null;
        if (results != null) {
            tran = results.curTransaction();
        }
        if (tran != null) {
            tranType = tran.transactionType();
        }
        return new SegKey(seg.type(), seg.loop(), tranType);
    }

    private record SegKey(SegmentType type, String loop, TransactionType tranType) {
    }
}

