/*
 * Decompiled with CFR 0.152.
 */
package hdi.edi.edient;

import com.fasterxml.jackson.annotation.JsonIgnore;
import hdi.codeent.CodeEntity;
import hdi.edi.edient.EdiEntity;
import hdi.edi.parser.EdiParsingResults;
import hdi.edi.parser.EdiSeg;
import hdi.edi.qualifier.EdiQualifier;
import hdi.model.enumtype.DiagType;
import hdi.model.enumtype.ProcType;
import hdi.model.enumtype.UbCodeType;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;

public class HiCode
implements EdiEntity {
    public static final int HOW_MANY_CODES_IN_GRID = 2;
    @JsonIgnore
    private EdiSeg seg;
    private final List<CodeEntity> codeEntities = new ArrayList<CodeEntity>();

    @Override
    public void populateFromSegInitial(EdiSeg seg, EdiParsingResults results) {
        this.seg = seg;
    }

    public EdiQualifier type() {
        if (this.codeEntities.isEmpty()) {
            return null;
        }
        return this.codeEntities.get(0).subType();
    }

    public String codeTypeDescription() {
        if (this.type() instanceof ProcType) {
            return "Medical Procedure Codes";
        }
        if (this.type() instanceof DiagType) {
            return "Diagnosis Codes";
        }
        if (this.type() instanceof UbCodeType) {
            return this.type().desc();
        }
        return "Medical Information Codes";
    }

    @Override
    public void addCodeEntityForSeg(CodeEntity codeEntity) {
        if (codeEntity.subType().isMedicalCode()) {
            this.codeEntities.add(codeEntity);
        }
    }

    @JsonIgnore
    @Generated
    public EdiSeg seg() {
        return this.seg;
    }

    @Generated
    public String toString() {
        return "HiCode(codeEntities=" + String.valueOf(this.codeEntities()) + ")";
    }

    @Override
    @Generated
    public List<CodeEntity> codeEntities() {
        return this.codeEntities;
    }
}

