/*
 * Decompiled with CFR 0.152.
 */
package hdi.edi.ediwriter;

import hdi.edi.parser.DataType;
import hdi.edi.parser.DatePair;
import hdi.edi.parser.EdiDateUtils;
import hdi.edi.parser.EdiSeg;
import hdi.edi.parser.EdiSeparators;
import hdi.edi.parser.Elt;
import hdi.edi.parser.EltSet;
import hdi.edi.parser.SegmentType;
import hdi.util.NumbersUtils;
import java.io.Writer;
import java.util.Comparator;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EdiSerializer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EdiSerializer.class);
    private EdiSeparators separators = EdiSeparators.DEFAULT_EDI_SEPARATORS;
    private boolean isNewLineSegmentTermination = true;

    public int serialize(List<EdiSeg> segs, Writer writer) {
        int segCount = 0;
        for (EdiSeg seg : segs) {
            if (seg == null) continue;
            String segStr = this.serialize(seg);
            writer.write(segStr);
            if (this.isNewLineSegmentTermination) {
                writer.write(System.lineSeparator());
            }
            ++segCount;
        }
        return segCount;
    }

    public String serialize(EdiSeg seg) {
        StringBuilder buf = new StringBuilder();
        buf.append((Object)seg.type());
        this.serialize(buf, seg.eltSet(), this.separators.elementSeparator());
        buf.append(this.separators.segmentTerminator());
        return buf.toString();
    }

    private void serialize(StringBuilder buf, EltSet eltSet, String separator) {
        eltSet.elts().sort(Comparator.comparingInt(Elt::position));
        int currentPos = 0;
        for (Elt elt : eltSet.elts()) {
            if (elt.position() == currentPos) {
                String segType = eltSet.parentSeg() != null ? eltSet.parentSeg().typeAsString() : "null";
                log.debug("Segment {}: Duplicate element {} in position {}", new Object[]{segType, elt.name(), elt.position()});
                continue;
            }
            this.serialize(buf, currentPos, elt, eltSet, separator);
            currentPos = elt.position();
        }
    }

    private void serialize(StringBuilder buf, int currentPos, Elt elt, EltSet parentEltSet, String separator) {
        int numberOfSeps = elt.position() - currentPos;
        if (separator.equals(this.separators.componentElementSeparator()) && StringUtils.endsWith((CharSequence)buf.toString(), (CharSequence)this.separators.elementSeparator())) {
            --numberOfSeps;
        }
        String seps = StringUtils.repeat((String)separator, (int)numberOfSeps);
        buf.append(seps);
        if (elt.dataType() == DataType.ELT_SET) {
            this.serialize(buf, elt.eltSet(), this.separators.componentElementSeparator());
        } else {
            Object val = elt.valAsStr();
            String padChar = " ";
            if (elt.dataType() == DataType.DATE) {
                val = parentEltSet.parentSeg() != null && parentEltSet.parentSeg().type() == SegmentType.ISA ? elt.dateVal().format(EdiDateUtils.EDI_ISA_DATE_FORMAT) : EdiDateUtils.localDateToStr(elt.dateVal());
            } else if (elt.dataType() == DataType.TIME) {
                val = EdiDateUtils.localTimeToStr(elt.timeVal());
            } else if (elt.dataType() == DataType.DATE_TIME) {
                val = EdiDateUtils.localDateTimeToStr(elt.dateTimeVal());
            } else if (elt.dataType() == DataType.DATE_INTERVAL) {
                DatePair datePair = elt.datePair();
                val = EdiDateUtils.localDateToStr(datePair.date()) + "-" + EdiDateUtils.localDateToStr(datePair.dateTo());
            } else if (elt.dataType() == DataType.INT) {
                padChar = "0";
            } else if (elt.dataType() == DataType.BIG_DEC) {
                val = NumbersUtils.removeTrailingZerosUpToDecimal(elt.bigDecimalVal()).toString();
            }
            if (elt.minWidth() >= 0) {
                val = StringUtils.leftPad((String)val, (int)elt.minWidth(), (String)padChar);
            }
            if (elt.maxWidth() >= 0 && ((String)val).length() > elt.maxWidth()) {
                val = ((String)val).substring(0, elt.maxWidth());
            }
            buf.append((String)val);
        }
    }

    @Generated
    public EdiSeparators separators() {
        return this.separators;
    }

    @Generated
    public boolean isNewLineSegmentTermination() {
        return this.isNewLineSegmentTermination;
    }

    @Generated
    public EdiSerializer separators(EdiSeparators separators) {
        this.separators = separators;
        return this;
    }

    @Generated
    public EdiSerializer isNewLineSegmentTermination(boolean isNewLineSegmentTermination) {
        this.isNewLineSegmentTermination = isNewLineSegmentTermination;
        return this;
    }
}

