/*
 * Decompiled with CFR 0.152.
 */
package hdi.edi.ediwriter;

import hdi.edi.EdiTransaction;
import hdi.edi.ediwriter.ClaimToSegMapper;
import hdi.edi.ediwriter.EdiSerializer;
import hdi.edi.ediwriter.EdiWriterException;
import hdi.edi.ediwriter.EdiWritingLevels;
import hdi.edi.ediwriter.EltCreator;
import hdi.edi.ediwriter.ObjToSegMapper;
import hdi.edi.parser.EdiSeg;
import hdi.edi.parser.SegmentType;
import hdi.edi.parser.TransactionType;
import hdi.edi.validation.ValidationIssue;
import hdi.license.CliLicenseReader;
import hdi.model.ServiceLine;
import hdi.model.claim.Claim;
import hdi.model.control.FunctionalGroup;
import hdi.model.control.Ge;
import hdi.model.control.Iea;
import hdi.model.control.Isa;
import hdi.model.control.Se;
import hdi.util.UniqueIdGen;
import java.io.Closeable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EdiWriter
implements Closeable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EdiWriter.class);
    private final ObjToSegMapper objToSegMapper = new ObjToSegMapper();
    private final ClaimToSegMapper claimToSegMapper = new ClaimToSegMapper();
    private final EdiSerializer serializer = new EdiSerializer();
    private Isa isa;
    private FunctionalGroup functionalGroup;
    private int functionalGroupCount = 0;
    private EdiTransaction ediTransaction;
    private int tranCount = 0;
    private int segCount = 0;
    private final Writer writer;
    private EdiWritingLevels ediWritingLevels = new EdiWritingLevels();
    private final CliLicenseReader licenseReader = new CliLicenseReader();

    public EdiWriter(Writer writer) {
        this.writer = writer;
        this.licenseReader.checkLicense();
    }

    public List<ValidationIssue> writeClaim(Claim claim) {
        EdiWritingLevels.LevelStatus patientLevelStatus;
        this.checkTransactionIsSet();
        TransactionType tranType = this.ediTransaction.transactionType();
        ArrayList<EdiSeg> segs = new ArrayList<EdiSeg>();
        if (claim.billingProvider() == null) {
            throw new EdiWriterException("Billing provider is not defined for this claim:\n %s", claim);
        }
        EdiWritingLevels.LevelStatus billingProviderLevelStatus = this.ediWritingLevels.updateLevelIfNeeded(1, claim.billingProvider());
        if (billingProviderLevelStatus.isNewLevel()) {
            segs.add(EltCreator.createHl("20", billingProviderLevelStatus.levelHlCount(), null, true));
            this.objToSegMapper.mapOrgPersonSegs(segs, tranType, SegmentType.NM1, claim.billingProvider());
        }
        if (claim.subscriber() == null) {
            throw new EdiWriterException("Subscriber/patient is not defined for claim: %s", claim);
        }
        EdiWritingLevels.LevelStatus subscriberLevelStatus = this.ediWritingLevels.updateLevelIfNeeded(2, claim.subscriber());
        if (subscriberLevelStatus.isNewLevel()) {
            segs.add(EltCreator.createHl("22", subscriberLevelStatus.levelHlCount(), billingProviderLevelStatus.levelHlCount(), claim.patient() != null));
            List<EdiSeg> subSegs = this.objToSegMapper.createPatSubSegs(tranType, claim.subscriber());
            segs.addAll(subSegs);
        }
        if (claim.patient() != null && (patientLevelStatus = this.ediWritingLevels.updateLevelIfNeeded(3, claim.patient())).isNewLevel()) {
            segs.add(EltCreator.createHl("23", patientLevelStatus.levelHlCount(), subscriberLevelStatus.levelHlCount(), false));
            List<EdiSeg> subSegs = this.objToSegMapper.createPatSubSegs(tranType, claim.patient());
            segs.addAll(subSegs);
        }
        List<EdiSeg> claimSegs = this.claimToSegMapper.mapClaimOnly(tranType, claim);
        segs.addAll(claimSegs);
        int i = 1;
        for (ServiceLine line : claim.lines()) {
            List<EdiSeg> lineSegs = this.claimToSegMapper.mapLine(tranType, line);
            segs.add(EltCreator.createLx(i));
            segs.addAll(lineSegs);
            ++i;
        }
        this.writeSegs(segs);
        return new ArrayList<ValidationIssue>();
    }

    private void checkTransactionIsSet() {
        if (this.ediTransaction == null) {
            throw new EdiWriterException("EDI Transaction is not defined. You must write transaction before writing other objects", new Object[0]);
        }
    }

    public void writeIsa(Isa isa) {
        this.isa = isa;
        this.serializer.separators(isa.ediSeparators());
        this.mapAndWriteSegs(isa, SegmentType.ISA);
    }

    public void writeFunctionalGroup(FunctionalGroup functionalGroup) {
        if (this.functionalGroup != null) {
            this.writeSe();
            this.writeGe();
        }
        this.functionalGroup = functionalGroup = new FunctionalGroup(functionalGroup);
        if (functionalGroup.controlNumber() == null) {
            functionalGroup.controlNumber(UniqueIdGen.generatePseudoRandomIntId());
        }
        this.mapAndWriteSegs(functionalGroup, SegmentType.GS);
        ++this.functionalGroupCount;
        this.ediTransaction = null;
        this.tranCount = 0;
    }

    public void writeTransaction(EdiTransaction ediTransaction) {
        if (this.ediTransaction != null) {
            this.writeSe();
        }
        this.segCount = 0;
        if ((ediTransaction = new EdiTransaction(ediTransaction)).controlNumber() == null) {
            ediTransaction.controlNumber(Integer.toString(this.tranCount + 1));
        }
        if (ediTransaction.originatorApplicationTransactionId() == null) {
            ediTransaction.originatorApplicationTransactionId(ediTransaction.id());
        }
        this.ediTransaction = ediTransaction;
        List<EdiSeg> segs = this.objToSegMapper.createTransactionSegs(ediTransaction);
        this.writeSegs(segs);
        ++this.tranCount;
        this.ediWritingLevels = new EdiWritingLevels();
    }

    @Override
    public void close() {
        this.writeSe();
        this.writeGe();
        this.writeIea();
    }

    private void writeIea() {
        if (this.isa != null) {
            Iea iea = new Iea(this.functionalGroupCount, this.isa.controlNumber());
            this.mapAndWriteSegs(iea, SegmentType.IEA);
        } else {
            log.warn("No ISA found, cannot write IEA");
        }
    }

    private void writeGe() {
        if (this.functionalGroup != null) {
            Ge ge = new Ge(this.tranCount, this.functionalGroup.controlNumber());
            this.mapAndWriteSegs(ge, SegmentType.GE);
        } else {
            log.warn("Functional group not found, cannot write GE");
        }
    }

    private void writeSe() {
        if (this.ediTransaction != null) {
            ++this.segCount;
            Se se = new Se(this.segCount, this.ediTransaction.controlNumber());
            this.mapAndWriteSegs(se, SegmentType.SE);
        } else {
            log.warn("Transaction not found, cannot write SE");
        }
    }

    private void mapAndWriteSegs(Object obj, SegmentType ... segTypes) {
        List<EdiSeg> segs = this.objToSegMapper.createSegs(null, obj, segTypes);
        this.writeSegs(segs);
    }

    private void writeSegs(List<EdiSeg> segs) {
        int serializedCount = this.serializer.serialize(segs, this.writer);
        this.segCount += serializedCount;
    }

    @Generated
    public ObjToSegMapper objToSegMapper() {
        return this.objToSegMapper;
    }

    @Generated
    public ClaimToSegMapper claimToSegMapper() {
        return this.claimToSegMapper;
    }

    @Generated
    public EdiSerializer serializer() {
        return this.serializer;
    }

    @Generated
    public Isa isa() {
        return this.isa;
    }

    @Generated
    public FunctionalGroup functionalGroup() {
        return this.functionalGroup;
    }

    @Generated
    public int functionalGroupCount() {
        return this.functionalGroupCount;
    }

    @Generated
    public EdiTransaction ediTransaction() {
        return this.ediTransaction;
    }

    @Generated
    public int tranCount() {
        return this.tranCount;
    }

    @Generated
    public int segCount() {
        return this.segCount;
    }

    @Generated
    public Writer writer() {
        return this.writer;
    }

    @Generated
    public EdiWritingLevels ediWritingLevels() {
        return this.ediWritingLevels;
    }

    @Generated
    public CliLicenseReader licenseReader() {
        return this.licenseReader;
    }
}

