/*
 * Decompiled with CFR 0.152.
 */
package hdi.edi.fileinfo;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import hdi.edi.dict.annotations.Prop;
import hdi.edi.fileinfo.FileSource;
import hdi.edi.fileinfo.FileSourceType;
import hdi.edi.fileinfo.FileType;
import hdi.edi.fileinfo.ReaderOpener;
import hdi.edi.stats.IngestStats;
import hdi.job.JobStat;
import hdi.util.SearchWordsUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.bson.types.ObjectId;
import org.springframework.data.annotation.Transient;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class FileInfo {
    @JsonIgnore
    private ObjectId id;
    @JsonIgnore
    private FileSource fileSource;
    @Prop(desc={"File name"})
    private String name;
    @JsonIgnore
    private String dataSetName;
    @JsonIgnore
    private Set<String> searchWords;
    @Prop(desc={"URL of the file, including the full path"})
    private String url;
    @Prop(desc={"Last modified date and time of the file"})
    private ZonedDateTime lastModifiedDateTime;
    @Transient
    @JsonIgnore
    private Reader reader;
    @Transient
    @JsonIgnore
    private InputStream inputStream;
    @Transient
    @JsonIgnore
    private File file;
    @Transient
    @JsonIgnore
    private boolean isNewFile;
    @Transient
    @JsonIgnore
    private JobStat jobStat;
    @Transient
    @JsonIgnore
    private IngestStats ingestStat;
    @Transient
    @JsonIgnore
    private Throwable exception;
    private FileType fileType = FileType.EDI;
    @Transient
    @JsonIgnore
    private ReaderOpener readerOpener;
    private String str;

    public FileInfo() {
    }

    public FileInfo(FileSource fileSource, String name, ZonedDateTime lastModifiedDateTime, ReaderOpener readerOpener) {
        this.name = name;
        this.fileSource = fileSource;
        this.url = FileInfo.normalizeUrl(fileSource.url(), name);
        this.readerOpener = readerOpener;
        this.lastModifiedDateTime = lastModifiedDateTime;
        this.id = ObjectId.get();
        this.prepSearchWords();
    }

    public FileInfo(FileInfo fileInfo) {
        this.id = fileInfo.id;
        this.fileSource = fileInfo.fileSource;
        this.url = fileInfo.url;
        this.name = fileInfo.name;
        this.file = fileInfo.file;
        this.reader = fileInfo.reader;
        this.lastModifiedDateTime = fileInfo.lastModifiedDateTime;
        this.searchWords = fileInfo.searchWords;
        this.fileType = fileInfo.fileType;
        this.jobStat = fileInfo.jobStat;
        this.dataSetName = fileInfo.dataSetName;
        this.isNewFile = fileInfo.isNewFile;
        this.inputStream = fileInfo.inputStream;
        this.ingestStat = fileInfo.ingestStat;
        this.exception = fileInfo.exception;
        this.readerOpener = fileInfo.readerOpener;
        this.prepSearchWords();
    }

    public FileInfo(File file) {
        this.file = file;
        this.name = file.getName();
        this.url = FileInfo.normalizeUrl(file.toURI().toURL().toString());
        this.id = ObjectId.get();
        this.fileSource = new FileSource(FileSourceType.FILE, this.url);
        this.populateFileLastModifiedDate(file);
        this.prepSearchWords();
    }

    public FileInfo(String name, InputStream inputStream) {
        this(null, name, inputStream);
    }

    public FileInfo(String dataSetName, String name, InputStream inputStream) {
        this.dataSetName = dataSetName;
        this.inputStream = inputStream;
        this.populateForNonFiles(name);
    }

    public FileInfo(String name, Reader reader) {
        this.reader = reader;
        this.populateForNonFiles(name);
    }

    public FileInfo(FileSource fileSource, File file) {
        this(file);
        this.fileSource = fileSource;
    }

    public FileInfo(String s) {
        this.fileSource = FileSource.ofString();
        if (s == null) {
            s = "";
        }
        this.str = s;
        this.reader = new StringReader(s);
        this.prepSearchWords();
    }

    @JsonIgnore
    public boolean isString() {
        return this.fileSource != null && this.fileSource.type() == FileSourceType.STRING;
    }

    @JsonIgnore
    public String getContentAsString() {
        if (this.str != null) {
            return this.str;
        }
        if (this.reader != null) {
            return IOUtils.toString((Reader)this.reader);
        }
        if (this.file != null) {
            return IOUtils.toString((InputStream)new FileInputStream(this.file), (Charset)Charset.defaultCharset());
        }
        return null;
    }

    private void populateForNonFiles(String name) {
        this.name = name;
        this.fileSource = FileSource.ofInputStream();
        this.url = this.createUrlForUploads(name);
        this.lastModifiedDateTime = ZonedDateTime.now(ZoneId.systemDefault());
        this.prepSearchWords();
    }

    public String pathRelativeToFileSource() {
        if (this.fileSource == null) {
            return this.url;
        }
        Object prefixToRemove = this.fileSource.url();
        if (!StringUtils.endsWith((CharSequence)prefixToRemove, (CharSequence)"/")) {
            prefixToRemove = (String)prefixToRemove + "/";
        }
        return StringUtils.removeStart((String)this.url, (String)prefixToRemove);
    }

    private String createUrlForUploads(String name) {
        if (name == null) {
            return null;
        }
        File file = new File("/uploads/");
        file = new File(file, name);
        return FileInfo.normalizeUrl(file.toURI().toURL().toString());
    }

    private void prepSearchWords() {
        this.searchWords = SearchWordsUtils.tokenizeTextFields(this.name, this.url, this.dataSetName);
        if (this.fileType != null) {
            this.searchWords.add(this.fileType.name().toLowerCase());
        }
        if (this.name != null) {
            this.searchWords.add(this.name.toLowerCase());
        }
        if (this.url != null) {
            this.searchWords.add(this.url.toLowerCase());
        }
    }

    private void populateFileLastModifiedDate(File file) {
        this.lastModifiedDateTime = ZonedDateTime.ofInstant(Instant.ofEpochMilli(file.lastModified()), ZoneId.systemDefault());
    }

    @JsonIgnore
    public BufferedReader getContent() {
        if (this.file != null) {
            return Files.newBufferedReader(this.file.toPath());
        }
        if (this.reader != null) {
            return new BufferedReader(this.reader);
        }
        if (this.inputStream != null) {
            return new BufferedReader(new InputStreamReader(this.inputStream));
        }
        if (this.readerOpener != null) {
            return new BufferedReader(this.readerOpener.openReader());
        }
        throw new IllegalStateException("Don't know how to open reader for file info " + String.valueOf(this));
    }

    public InputStream openInputStream() {
        if (this.file != null) {
            return new FileInputStream(this.file);
        }
        if (this.inputStream != null) {
            return this.inputStream;
        }
        throw new IllegalStateException("Don't know how to open inputstream for this file info " + String.valueOf(this));
    }

    public FileInfo name(String name) {
        this.name = name;
        if (StringUtils.contains((CharSequence)name, (CharSequence)"/")) {
            this.name = StringUtils.prependIfMissing((String)name, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
        }
        return this;
    }

    public FileInfo url(String url) {
        this.url = URLDecoder.decode(url, StandardCharsets.UTF_8);
        return this;
    }

    public String fileContainer() {
        String filePath = this.url;
        if (StringUtils.isBlank((CharSequence)(filePath = StringUtils.substringBeforeLast((String)filePath, (String)"/")))) {
            filePath = "/";
        }
        return filePath;
    }

    public static String normalizeUrl(String url) {
        URI uri = new URI(url);
        return uri.normalize().toString();
    }

    public static String normalizeUrl(String parent, String fileName) {
        String encodedFileName = FileInfo.percentEncodeFileName(fileName);
        if (!StringUtils.endsWith((CharSequence)parent, (CharSequence)"/")) {
            parent = (String)parent + "/";
        }
        String url = (String)parent + encodedFileName;
        return FileInfo.normalizeUrl(url);
    }

    private static String percentEncodeFileName(String fileName) {
        File fakeFile = new File(fileName);
        String encodedUrl = fakeFile.toPath().toUri().toURL().toString();
        return FilenameUtils.getName((String)encodedUrl);
    }

    private static String percentDecodeFileName(String fileName) {
        File fakeFile = new File(fileName);
        String encodedUrl = fakeFile.toPath().toUri().toURL().toString();
        return FilenameUtils.getName((String)encodedUrl);
    }

    @JsonIgnore
    public boolean isNewFile() {
        return this.isNewFile;
    }

    public FileSourceType fileSourceType() {
        if (this.fileSource == null) {
            return null;
        }
        return this.fileSource.type();
    }

    @Generated
    public String toString() {
        return "FileInfo(id=" + String.valueOf(this.id()) + ", fileSource=" + String.valueOf(this.fileSource()) + ", name=" + this.name() + ", dataSetName=" + this.dataSetName() + ", url=" + this.url() + ", lastModifiedDateTime=" + String.valueOf(this.lastModifiedDateTime()) + ", file=" + String.valueOf(this.file()) + ", isNewFile=" + this.isNewFile() + ", jobStat=" + String.valueOf(this.jobStat()) + ", ingestStat=" + String.valueOf(this.ingestStat()) + ", exception=" + String.valueOf(this.exception()) + ", fileType=" + String.valueOf((Object)this.fileType()) + ", readerOpener=" + String.valueOf(this.readerOpener()) + ", str=" + this.str() + ")";
    }

    @JsonIgnore
    @Generated
    public ObjectId id() {
        return this.id;
    }

    @JsonIgnore
    @Generated
    public Reader reader() {
        return this.reader;
    }

    @JsonIgnore
    @Generated
    public InputStream inputStream() {
        return this.inputStream;
    }

    @JsonIgnore
    @Generated
    public ReaderOpener readerOpener() {
        return this.readerOpener;
    }

    @Generated
    public String str() {
        return this.str;
    }

    @JsonIgnore
    @Generated
    public FileInfo id(ObjectId id) {
        this.id = id;
        return this;
    }

    @JsonIgnore
    @Generated
    public FileSource fileSource() {
        return this.fileSource;
    }

    @JsonIgnore
    @Generated
    public FileInfo fileSource(FileSource fileSource) {
        this.fileSource = fileSource;
        return this;
    }

    @Generated
    public String name() {
        return this.name;
    }

    @JsonIgnore
    @Generated
    public String dataSetName() {
        return this.dataSetName;
    }

    @JsonIgnore
    @Generated
    public FileInfo dataSetName(String dataSetName) {
        this.dataSetName = dataSetName;
        return this;
    }

    @JsonIgnore
    @Generated
    public Set<String> searchWords() {
        return this.searchWords;
    }

    @Generated
    public String url() {
        return this.url;
    }

    @Generated
    public ZonedDateTime lastModifiedDateTime() {
        return this.lastModifiedDateTime;
    }

    @Generated
    public FileInfo lastModifiedDateTime(ZonedDateTime lastModifiedDateTime) {
        this.lastModifiedDateTime = lastModifiedDateTime;
        return this;
    }

    @JsonIgnore
    @Generated
    public File file() {
        return this.file;
    }

    @JsonIgnore
    @Generated
    public FileInfo isNewFile(boolean isNewFile) {
        this.isNewFile = isNewFile;
        return this;
    }

    @JsonIgnore
    @Generated
    public JobStat jobStat() {
        return this.jobStat;
    }

    @JsonIgnore
    @Generated
    public FileInfo jobStat(JobStat jobStat) {
        this.jobStat = jobStat;
        return this;
    }

    @JsonIgnore
    @Generated
    public IngestStats ingestStat() {
        return this.ingestStat;
    }

    @JsonIgnore
    @Generated
    public FileInfo ingestStat(IngestStats ingestStat) {
        this.ingestStat = ingestStat;
        return this;
    }

    @JsonIgnore
    @Generated
    public Throwable exception() {
        return this.exception;
    }

    @JsonIgnore
    @Generated
    public FileInfo exception(Throwable exception) {
        this.exception = exception;
        return this;
    }

    @Generated
    public FileInfo fileType(FileType fileType) {
        this.fileType = fileType;
        return this;
    }

    @Generated
    public FileType fileType() {
        return this.fileType;
    }
}

