/*
 * Decompiled with CFR 0.152.
 */
package hdi.edi.fileinfo;

import hdi.edi.fileinfo.FileInfo;
import hdi.edi.fileinfo.FileSourceType;
import hdi.util.FormattingUtils;
import java.io.File;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Collection;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.annotation.PersistenceCreator;
import org.springframework.data.annotation.Transient;

public class FileSource {
    private String id;
    public static final String SCAN_TIMESTAMP_FIELD = "scanTimestamp";
    public static final String NAME_FIELD = "alias";
    public static final String URL_FIELD = "url";
    private String alias;
    private String dataSetName;
    private boolean isDefaultDataSet;
    private FileSourceType type;
    private LocalDateTime scanTimestamp;
    @CreatedDate
    private LocalDateTime createTimestamp;
    @LastModifiedDate
    private LocalDateTime updateTimestamp;
    private boolean isDisabled;
    private boolean isScanEnabled = true;
    private LocalDate fromDate;
    private LocalDate toDate;
    private String includePatterns;
    private String excludePatterns;
    private boolean isRecursive;
    private String prefix;
    private String url;
    private String containerName;
    private String outputContainerName;
    private boolean isConvertAllToCsv;
    private String accessToken;
    private String host;
    private String username;
    private String password;
    private String privateKeyFileName;
    private String localDir;
    private String dir;
    @Transient
    private Collection<File> files;
    @Transient
    private Collection<FileInfo> fileInfos;

    @PersistenceCreator
    public FileSource() {
    }

    public FileSource includePatternList(Collection<String> patterns) {
        this.includePatterns = StringUtils.join(patterns, (char)',');
        return this;
    }

    public static FileSource ofString() {
        FileSource fs = new FileSource();
        fs.type = FileSourceType.STRING;
        fs.url("https://filesource.datainsight.health/String");
        return fs;
    }

    public static FileSource ofInputStream() {
        FileSource fs = new FileSource();
        fs.type = FileSourceType.INPUT_STREAM;
        fs.url("https://filesource.datainsight.health/inputStream");
        return fs;
    }

    public static FileSource ofSftp(String username, String host, String dir) {
        FileSource fs = new FileSource().host(host).username(username).dir(dir);
        fs.type = FileSourceType.SFTP;
        String url = "sftp://" + host;
        if (StringUtils.isNotBlank((CharSequence)dir)) {
            url = url + "/" + dir;
        }
        fs.url(url);
        return fs;
    }

    public static FileSource ofAzureBlob(String storageUrl, String containerName, String accessToken) {
        FileSource fs = new FileSource(FileSourceType.AZURE_BLOB, storageUrl, containerName);
        fs.accessToken = accessToken;
        return fs;
    }

    public FileSource(FileSourceType type, String baseUrl, String containerName) {
        this.type = type;
        if (type == FileSourceType.FILE_SYSTEM_DIR) {
            this.dir = baseUrl;
            this.url = FileInfo.normalizeUrl(new File(this.dir).toURI().toURL().toString());
        } else {
            Object urlS = baseUrl;
            if (containerName != null) {
                urlS = baseUrl + "/" + containerName;
            }
            this.url = FileInfo.normalizeUrl((String)urlS);
            this.containerName = containerName;
        }
    }

    public FileSource(FileSourceType type, String url) {
        this(type, url, null);
    }

    public FileSource(FileSource fileSource, String prefix) {
        this(fileSource);
        this.prefix = prefix;
    }

    public FileSource(FileSource fileSource) {
        this.id = fileSource.id;
        this.alias = fileSource.alias;
        this.type = fileSource.type;
        this.createTimestamp = LocalDateTime.now();
        this.isDisabled = fileSource.isDisabled;
        this.fromDate = fileSource.fromDate;
        this.toDate = fileSource.toDate;
        this.includePatterns = fileSource.includePatterns;
        this.excludePatterns = fileSource.excludePatterns;
        this.isRecursive = fileSource.isRecursive;
        this.url = fileSource.url;
        this.containerName = fileSource.containerName;
        this.prefix = fileSource.prefix;
        this.accessToken = fileSource.accessToken;
        this.dir = fileSource.dir;
        this.isScanEnabled = fileSource.isScanEnabled;
        this.host = fileSource.host;
        this.username = fileSource.username;
        this.password = fileSource.password;
        this.privateKeyFileName = fileSource.privateKeyFileName;
        this.localDir = fileSource.localDir;
        this.dataSetName = fileSource.dataSetName;
        this.isDefaultDataSet = fileSource.isDefaultDataSet;
        this.scanTimestamp = fileSource.scanTimestamp;
        this.updateTimestamp = fileSource.updateTimestamp;
        this.files = fileSource.files;
        this.fileInfos = fileSource.fileInfos;
        this.isConvertAllToCsv = fileSource.isConvertAllToCsv;
        this.outputContainerName = fileSource.outputContainerName;
    }

    public String url() {
        return this.url;
    }

    public FileSource url(String url) {
        this.url = FileInfo.normalizeUrl(url);
        return this;
    }

    public String containerName() {
        return this.containerName;
    }

    public String toFriendlyString() {
        return FormattingUtils.concat(this.alias, this.url, "-");
    }

    @Generated
    public String id() {
        return this.id;
    }

    @Generated
    public String alias() {
        return this.alias;
    }

    @Generated
    public String dataSetName() {
        return this.dataSetName;
    }

    @Generated
    public boolean isDefaultDataSet() {
        return this.isDefaultDataSet;
    }

    @Generated
    public FileSourceType type() {
        return this.type;
    }

    @Generated
    public LocalDateTime scanTimestamp() {
        return this.scanTimestamp;
    }

    @Generated
    public LocalDateTime createTimestamp() {
        return this.createTimestamp;
    }

    @Generated
    public LocalDateTime updateTimestamp() {
        return this.updateTimestamp;
    }

    @Generated
    public boolean isDisabled() {
        return this.isDisabled;
    }

    @Generated
    public boolean isScanEnabled() {
        return this.isScanEnabled;
    }

    @Generated
    public LocalDate fromDate() {
        return this.fromDate;
    }

    @Generated
    public LocalDate toDate() {
        return this.toDate;
    }

    @Generated
    public String includePatterns() {
        return this.includePatterns;
    }

    @Generated
    public String excludePatterns() {
        return this.excludePatterns;
    }

    @Generated
    public boolean isRecursive() {
        return this.isRecursive;
    }

    @Generated
    public String prefix() {
        return this.prefix;
    }

    @Generated
    public String outputContainerName() {
        return this.outputContainerName;
    }

    @Generated
    public boolean isConvertAllToCsv() {
        return this.isConvertAllToCsv;
    }

    @Generated
    public String accessToken() {
        return this.accessToken;
    }

    @Generated
    public String host() {
        return this.host;
    }

    @Generated
    public String username() {
        return this.username;
    }

    @Generated
    public String password() {
        return this.password;
    }

    @Generated
    public String privateKeyFileName() {
        return this.privateKeyFileName;
    }

    @Generated
    public String localDir() {
        return this.localDir;
    }

    @Generated
    public String dir() {
        return this.dir;
    }

    @Generated
    public Collection<File> files() {
        return this.files;
    }

    @Generated
    public Collection<FileInfo> fileInfos() {
        return this.fileInfos;
    }

    @Generated
    public FileSource id(String id) {
        this.id = id;
        return this;
    }

    @Generated
    public FileSource alias(String alias) {
        this.alias = alias;
        return this;
    }

    @Generated
    public FileSource dataSetName(String dataSetName) {
        this.dataSetName = dataSetName;
        return this;
    }

    @Generated
    public FileSource isDefaultDataSet(boolean isDefaultDataSet) {
        this.isDefaultDataSet = isDefaultDataSet;
        return this;
    }

    @Generated
    public FileSource type(FileSourceType type) {
        this.type = type;
        return this;
    }

    @Generated
    public FileSource scanTimestamp(LocalDateTime scanTimestamp) {
        this.scanTimestamp = scanTimestamp;
        return this;
    }

    @Generated
    public FileSource createTimestamp(LocalDateTime createTimestamp) {
        this.createTimestamp = createTimestamp;
        return this;
    }

    @Generated
    public FileSource updateTimestamp(LocalDateTime updateTimestamp) {
        this.updateTimestamp = updateTimestamp;
        return this;
    }

    @Generated
    public FileSource isDisabled(boolean isDisabled) {
        this.isDisabled = isDisabled;
        return this;
    }

    @Generated
    public FileSource isScanEnabled(boolean isScanEnabled) {
        this.isScanEnabled = isScanEnabled;
        return this;
    }

    @Generated
    public FileSource fromDate(LocalDate fromDate) {
        this.fromDate = fromDate;
        return this;
    }

    @Generated
    public FileSource toDate(LocalDate toDate) {
        this.toDate = toDate;
        return this;
    }

    @Generated
    public FileSource includePatterns(String includePatterns) {
        this.includePatterns = includePatterns;
        return this;
    }

    @Generated
    public FileSource excludePatterns(String excludePatterns) {
        this.excludePatterns = excludePatterns;
        return this;
    }

    @Generated
    public FileSource isRecursive(boolean isRecursive) {
        this.isRecursive = isRecursive;
        return this;
    }

    @Generated
    public FileSource prefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    @Generated
    public FileSource containerName(String containerName) {
        this.containerName = containerName;
        return this;
    }

    @Generated
    public FileSource outputContainerName(String outputContainerName) {
        this.outputContainerName = outputContainerName;
        return this;
    }

    @Generated
    public FileSource isConvertAllToCsv(boolean isConvertAllToCsv) {
        this.isConvertAllToCsv = isConvertAllToCsv;
        return this;
    }

    @Generated
    public FileSource accessToken(String accessToken) {
        this.accessToken = accessToken;
        return this;
    }

    @Generated
    public FileSource host(String host) {
        this.host = host;
        return this;
    }

    @Generated
    public FileSource username(String username) {
        this.username = username;
        return this;
    }

    @Generated
    public FileSource password(String password) {
        this.password = password;
        return this;
    }

    @Generated
    public FileSource privateKeyFileName(String privateKeyFileName) {
        this.privateKeyFileName = privateKeyFileName;
        return this;
    }

    @Generated
    public FileSource localDir(String localDir) {
        this.localDir = localDir;
        return this;
    }

    @Generated
    public FileSource dir(String dir) {
        this.dir = dir;
        return this;
    }

    @Generated
    public FileSource files(Collection<File> files) {
        this.files = files;
        return this;
    }

    @Generated
    public FileSource fileInfos(Collection<FileInfo> fileInfos) {
        this.fileInfos = fileInfos;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FileSource)) {
            return false;
        }
        FileSource other = (FileSource)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isDefaultDataSet() != other.isDefaultDataSet()) {
            return false;
        }
        if (this.isDisabled() != other.isDisabled()) {
            return false;
        }
        if (this.isScanEnabled() != other.isScanEnabled()) {
            return false;
        }
        if (this.isRecursive() != other.isRecursive()) {
            return false;
        }
        if (this.isConvertAllToCsv() != other.isConvertAllToCsv()) {
            return false;
        }
        String this$id = this.id();
        String other$id = other.id();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$alias = this.alias();
        String other$alias = other.alias();
        if (this$alias == null ? other$alias != null : !this$alias.equals(other$alias)) {
            return false;
        }
        String this$dataSetName = this.dataSetName();
        String other$dataSetName = other.dataSetName();
        if (this$dataSetName == null ? other$dataSetName != null : !this$dataSetName.equals(other$dataSetName)) {
            return false;
        }
        FileSourceType this$type = this.type();
        FileSourceType other$type = other.type();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        LocalDateTime this$scanTimestamp = this.scanTimestamp();
        LocalDateTime other$scanTimestamp = other.scanTimestamp();
        if (this$scanTimestamp == null ? other$scanTimestamp != null : !((Object)this$scanTimestamp).equals(other$scanTimestamp)) {
            return false;
        }
        LocalDateTime this$createTimestamp = this.createTimestamp();
        LocalDateTime other$createTimestamp = other.createTimestamp();
        if (this$createTimestamp == null ? other$createTimestamp != null : !((Object)this$createTimestamp).equals(other$createTimestamp)) {
            return false;
        }
        LocalDateTime this$updateTimestamp = this.updateTimestamp();
        LocalDateTime other$updateTimestamp = other.updateTimestamp();
        if (this$updateTimestamp == null ? other$updateTimestamp != null : !((Object)this$updateTimestamp).equals(other$updateTimestamp)) {
            return false;
        }
        LocalDate this$fromDate = this.fromDate();
        LocalDate other$fromDate = other.fromDate();
        if (this$fromDate == null ? other$fromDate != null : !((Object)this$fromDate).equals(other$fromDate)) {
            return false;
        }
        LocalDate this$toDate = this.toDate();
        LocalDate other$toDate = other.toDate();
        if (this$toDate == null ? other$toDate != null : !((Object)this$toDate).equals(other$toDate)) {
            return false;
        }
        String this$includePatterns = this.includePatterns();
        String other$includePatterns = other.includePatterns();
        if (this$includePatterns == null ? other$includePatterns != null : !this$includePatterns.equals(other$includePatterns)) {
            return false;
        }
        String this$excludePatterns = this.excludePatterns();
        String other$excludePatterns = other.excludePatterns();
        if (this$excludePatterns == null ? other$excludePatterns != null : !this$excludePatterns.equals(other$excludePatterns)) {
            return false;
        }
        String this$prefix = this.prefix();
        String other$prefix = other.prefix();
        if (this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix)) {
            return false;
        }
        String this$url = this.url();
        String other$url = other.url();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$containerName = this.containerName();
        String other$containerName = other.containerName();
        if (this$containerName == null ? other$containerName != null : !this$containerName.equals(other$containerName)) {
            return false;
        }
        String this$outputContainerName = this.outputContainerName();
        String other$outputContainerName = other.outputContainerName();
        if (this$outputContainerName == null ? other$outputContainerName != null : !this$outputContainerName.equals(other$outputContainerName)) {
            return false;
        }
        String this$accessToken = this.accessToken();
        String other$accessToken = other.accessToken();
        if (this$accessToken == null ? other$accessToken != null : !this$accessToken.equals(other$accessToken)) {
            return false;
        }
        String this$host = this.host();
        String other$host = other.host();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$username = this.username();
        String other$username = other.username();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.password();
        String other$password = other.password();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$privateKeyFileName = this.privateKeyFileName();
        String other$privateKeyFileName = other.privateKeyFileName();
        if (this$privateKeyFileName == null ? other$privateKeyFileName != null : !this$privateKeyFileName.equals(other$privateKeyFileName)) {
            return false;
        }
        String this$localDir = this.localDir();
        String other$localDir = other.localDir();
        if (this$localDir == null ? other$localDir != null : !this$localDir.equals(other$localDir)) {
            return false;
        }
        String this$dir = this.dir();
        String other$dir = other.dir();
        if (this$dir == null ? other$dir != null : !this$dir.equals(other$dir)) {
            return false;
        }
        Collection<File> this$files = this.files();
        Collection<File> other$files = other.files();
        if (this$files == null ? other$files != null : !((Object)this$files).equals(other$files)) {
            return false;
        }
        Collection<FileInfo> this$fileInfos = this.fileInfos();
        Collection<FileInfo> other$fileInfos = other.fileInfos();
        return !(this$fileInfos == null ? other$fileInfos != null : !((Object)this$fileInfos).equals(other$fileInfos));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FileSource;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isDefaultDataSet() ? 79 : 97);
        result = result * 59 + (this.isDisabled() ? 79 : 97);
        result = result * 59 + (this.isScanEnabled() ? 79 : 97);
        result = result * 59 + (this.isRecursive() ? 79 : 97);
        result = result * 59 + (this.isConvertAllToCsv() ? 79 : 97);
        String $id = this.id();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $alias = this.alias();
        result = result * 59 + ($alias == null ? 43 : $alias.hashCode());
        String $dataSetName = this.dataSetName();
        result = result * 59 + ($dataSetName == null ? 43 : $dataSetName.hashCode());
        FileSourceType $type = this.type();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        LocalDateTime $scanTimestamp = this.scanTimestamp();
        result = result * 59 + ($scanTimestamp == null ? 43 : ((Object)$scanTimestamp).hashCode());
        LocalDateTime $createTimestamp = this.createTimestamp();
        result = result * 59 + ($createTimestamp == null ? 43 : ((Object)$createTimestamp).hashCode());
        LocalDateTime $updateTimestamp = this.updateTimestamp();
        result = result * 59 + ($updateTimestamp == null ? 43 : ((Object)$updateTimestamp).hashCode());
        LocalDate $fromDate = this.fromDate();
        result = result * 59 + ($fromDate == null ? 43 : ((Object)$fromDate).hashCode());
        LocalDate $toDate = this.toDate();
        result = result * 59 + ($toDate == null ? 43 : ((Object)$toDate).hashCode());
        String $includePatterns = this.includePatterns();
        result = result * 59 + ($includePatterns == null ? 43 : $includePatterns.hashCode());
        String $excludePatterns = this.excludePatterns();
        result = result * 59 + ($excludePatterns == null ? 43 : $excludePatterns.hashCode());
        String $prefix = this.prefix();
        result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
        String $url = this.url();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $containerName = this.containerName();
        result = result * 59 + ($containerName == null ? 43 : $containerName.hashCode());
        String $outputContainerName = this.outputContainerName();
        result = result * 59 + ($outputContainerName == null ? 43 : $outputContainerName.hashCode());
        String $accessToken = this.accessToken();
        result = result * 59 + ($accessToken == null ? 43 : $accessToken.hashCode());
        String $host = this.host();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $username = this.username();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.password();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $privateKeyFileName = this.privateKeyFileName();
        result = result * 59 + ($privateKeyFileName == null ? 43 : $privateKeyFileName.hashCode());
        String $localDir = this.localDir();
        result = result * 59 + ($localDir == null ? 43 : $localDir.hashCode());
        String $dir = this.dir();
        result = result * 59 + ($dir == null ? 43 : $dir.hashCode());
        Collection<File> $files = this.files();
        result = result * 59 + ($files == null ? 43 : ((Object)$files).hashCode());
        Collection<FileInfo> $fileInfos = this.fileInfos();
        result = result * 59 + ($fileInfos == null ? 43 : ((Object)$fileInfos).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "FileSource(id=" + this.id() + ", alias=" + this.alias() + ", dataSetName=" + this.dataSetName() + ", isDefaultDataSet=" + this.isDefaultDataSet() + ", type=" + String.valueOf((Object)this.type()) + ", scanTimestamp=" + String.valueOf(this.scanTimestamp()) + ", createTimestamp=" + String.valueOf(this.createTimestamp()) + ", updateTimestamp=" + String.valueOf(this.updateTimestamp()) + ", isDisabled=" + this.isDisabled() + ", isScanEnabled=" + this.isScanEnabled() + ", fromDate=" + String.valueOf(this.fromDate()) + ", toDate=" + String.valueOf(this.toDate()) + ", includePatterns=" + this.includePatterns() + ", excludePatterns=" + this.excludePatterns() + ", isRecursive=" + this.isRecursive() + ", prefix=" + this.prefix() + ", url=" + this.url() + ", containerName=" + this.containerName() + ", outputContainerName=" + this.outputContainerName() + ", isConvertAllToCsv=" + this.isConvertAllToCsv() + ", host=" + this.host() + ", username=" + this.username() + ", password=" + this.password() + ", privateKeyFileName=" + this.privateKeyFileName() + ", localDir=" + this.localDir() + ", dir=" + this.dir() + ")";
    }
}

