/*
 * Decompiled with CFR 0.152.
 */
package hdi.edi.legacyparser;

import hdi.edi.openedi.OpenEdiNames;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public enum EdiDataType implements OpenEdiNames
{
    NUMERIC("N"),
    DECIMAL("R"),
    IDENTIFIER("ID"),
    STRING("AN"),
    DATE("DT"),
    TIME("TM"),
    BINARY("B"),
    ENUM("ID"),
    COMPOSITE(null);

    private final String ediSymbol;

    private static EdiDataType fromEdi(String ediVal, boolean isNcpdp) {
        if (StringUtils.startsWithIgnoreCase((CharSequence)ediVal, (CharSequence)EdiDataType.NUMERIC.ediSymbol)) {
            return NUMERIC;
        }
        if (isNcpdp && StringUtils.equalsIgnoreCase((CharSequence)ediVal, (CharSequence)"D2")) {
            return DECIMAL;
        }
        for (EdiDataType v : EdiDataType.values()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)v.ediSymbol, (CharSequence)ediVal)) continue;
            return v;
        }
        return null;
    }

    public static Integer extractScale(String format) {
        String possibleDigits;
        if (StringUtils.startsWithAny((CharSequence)(format = StringUtils.substringAfterLast((String)format, (String)"_")), (CharSequence[])new CharSequence[]{"D", "N"}) && StringUtils.isNumeric((CharSequence)(possibleDigits = StringUtils.substring((String)format, (int)1)))) {
            return Integer.parseInt(possibleDigits);
        }
        return null;
    }

    public static EdiDataType fromOpenEdiFormat(String openEdiFormat) {
        if (StringUtils.isBlank((CharSequence)openEdiFormat)) {
            return null;
        }
        String ediTypeVal = StringUtils.substringAfter((String)openEdiFormat, (String)"_");
        String formatPrefix = StringUtils.substringBefore((String)openEdiFormat, (String)"_");
        if (StringUtils.isBlank((CharSequence)ediTypeVal)) {
            ediTypeVal = openEdiFormat;
        }
        return EdiDataType.fromEdi(ediTypeVal, StringUtils.equalsIgnoreCase((CharSequence)formatPrefix, (CharSequence)"TELCO"));
    }

    @Generated
    private EdiDataType(String ediSymbol) {
        this.ediSymbol = ediSymbol;
    }
}

