/*
 * Decompiled with CFR 0.152.
 */
package hdi.edi.legacyparser;

import hdi.edi.legacyparser.EdiDictionary;
import hdi.edi.legacyparser.ElementWithChildrenDictionary;
import hdi.edi.legacyparser.SegmentDictionary;
import hdi.util.Loggers;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EdiMeta
implements Loggers {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EdiMeta.class);
    private final Map<String, SegmentDictionary> segsWithCodeOrQualifier = new HashMap<String, SegmentDictionary>();
    private final Map<String, SegmentDictionary> loopDependentSegs = new HashMap<String, SegmentDictionary>();
    private final Map<String, SegmentDictionary> segsByType = new HashMap<String, SegmentDictionary>();
    private final EdiDictionary ediDictionary;
    public static final Set<String> PREFIXES_TO_REMOVE = Set.of("billing_provider_");

    public static EdiMeta fromEdiDictionary(EdiDictionary ediDictionary) {
        return new EdiMeta(ediDictionary);
    }

    private EdiMeta(EdiDictionary ediDictionary) {
        this.ediDictionary = ediDictionary;
        this.populateFromEdiDictionary(ediDictionary);
    }

    private void populateFromEdiDictionary(EdiDictionary ediDictionary) {
        this.populateFromTranSpecificDictionary(ediDictionary.getProfDictionary());
        this.populateFromTranSpecificDictionary(ediDictionary.getInstDictionary());
        this.populateFromTranSpecificDictionary(ediDictionary.getDentDictionary());
    }

    private void populateFromTranSpecificDictionary(Map<String, SegmentDictionary> ediDictionary) {
        for (SegmentDictionary segDict : ediDictionary.values()) {
            this.putSegMetaInItsMap(segDict);
        }
    }

    public SegmentDictionary findSegDict(Iterable<String> elts, String loop) {
        int i = 0;
        String type = null;
        String codeOrQualifier = null;
        for (String elt : elts) {
            if (i == 0) {
                type = elt;
            } else if (i == 1) {
                codeOrQualifier = this.qualifierFromCompositeElement(elt);
                break;
            }
            ++i;
        }
        assert (type != null);
        return this.findSegDict(type, codeOrQualifier);
    }

    private String qualifierFromCompositeElement(String elt) {
        return StringUtils.substringBefore((String)elt, (String)":");
    }

    public SegmentDictionary findSegDict(@NotNull String type, String codeOrQual) {
        String key = this.createSegmentKey(type, codeOrQual, null);
        SegmentDictionary segDict = this.segsWithCodeOrQualifier.get(key);
        if (segDict == null && (segDict = this.segsByType.get(type)) != null) {
            ediParsingIssuesLogger.debug("Unknown segment {}*{}, using {} canonical representation", new Object[]{type, codeOrQual, type});
        }
        return segDict;
    }

    private void putSegMetaInItsMap(SegmentDictionary segmentDictionary) {
        String type = segmentDictionary.getTag();
        String codeOrQual = StringUtils.stripToNull((String)segmentDictionary.getCode());
        String loop = StringUtils.stripToNull((String)segmentDictionary.getLoop());
        if (codeOrQual != null) {
            String key = this.createSegmentKey(type, codeOrQual, null);
            this.putIntoMap(this.segsWithCodeOrQualifier, key, segmentDictionary);
            this.segsByType.putIfAbsent(type, segmentDictionary);
        } else {
            String key = this.createSegmentKey(type, null, loop);
            this.putIntoMap(this.loopDependentSegs, key, segmentDictionary);
            SegmentDictionary canonicalSegDict = this.segsByType.get(type);
            if (canonicalSegDict == null) {
                canonicalSegDict = this.makeNamesCanonical(segmentDictionary);
                this.segsByType.put(type, canonicalSegDict);
            }
        }
    }

    private String createSegmentKey(@NotNull String type, String codeOrQualifier, String loop) {
        StringBuilder key = new StringBuilder(type);
        if (codeOrQualifier != null) {
            key.append('-').append(codeOrQualifier);
        } else if (loop != null) {
            key.append('!').append(loop);
        }
        return StringUtils.toRootUpperCase((String)key.toString());
    }

    private void putIntoMap(Map<String, SegmentDictionary> segMap, String key, SegmentDictionary segDict) {
        SegmentDictionary existingSegDict = segMap.get(key);
        if (existingSegDict != null) {
            log.debug("Segment dictionary entry already exists: {}: {}", (Object)key, (Object)existingSegDict);
            if (!existingSegDict.getLoop().equals(segDict.getLoop())) {
                log.debug("Attempt to add a segment with the same key but with a diff loop. Existing/new:\n{}\n{}", (Object)existingSegDict, (Object)segDict);
            }
        } else {
            segMap.put(key, segDict);
        }
    }

    private SegmentDictionary makeNamesCanonical(SegmentDictionary segmentDictionary) {
        SegmentDictionary canonicalSegDict = new SegmentDictionary(segmentDictionary);
        String nm = this.canonicalizeName(canonicalSegDict.getJsonName());
        canonicalSegDict.setJsonName(nm);
        for (ElementWithChildrenDictionary eltDict : canonicalSegDict.elements) {
            eltDict.jsonName(this.canonicalizeName(eltDict.getJsonName()));
        }
        return canonicalSegDict;
    }

    private String canonicalizeName(String name) {
        for (String prefix : PREFIXES_TO_REMOVE) {
            if (!StringUtils.startsWith((CharSequence)name, (CharSequence)prefix)) continue;
            name = StringUtils.removeStart((String)name, (String)prefix);
            break;
        }
        return name;
    }

    @Generated
    public EdiDictionary ediDictionary() {
        return this.ediDictionary;
    }
}

