/*
 * Decompiled with CFR 0.152.
 */
package hdi.edi.legacyparser;

import hdi.edi.fileinfo.FileInfo;
import hdi.edi.legacyparser.EdiDataType;
import hdi.edi.legacyparser.EdiDictionary;
import hdi.edi.legacyparser.EdiElement;
import hdi.edi.legacyparser.EdiMeta;
import hdi.edi.legacyparser.EdiMetaHolder;
import hdi.edi.legacyparser.EdiSegment;
import hdi.edi.legacyparser.ElementDictionary;
import hdi.edi.legacyparser.ElementWithChildrenDictionary;
import hdi.edi.legacyparser.EltValHolder;
import hdi.edi.legacyparser.SegmentDictionary;
import hdi.edi.openedi.LoopSchema;
import hdi.edi.openedi.LoopSegRef;
import hdi.edi.openedi.OpenEdiSchemaHolder;
import hdi.edi.openedi.SchemaComponent;
import hdi.edi.openedi.TransactionSchema;
import hdi.edi.parser.EdiParserException;
import hdi.edi.parser.EdiSeparators;
import hdi.edi.parser.IsaParser;
import hdi.edi.parser.ParsingIssue;
import hdi.edi.parser.ParsingIssueSeverity;
import hdi.edi.parser.SegmentType;
import hdi.edi.parser.TransactionType;
import hdi.util.Loggers;
import hdi.util.NumbersUtils;
import hdi.util.WordStringUtils;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.MalformedInputException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegacyEdiParser
implements AutoCloseable,
Loggers {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LegacyEdiParser.class);
    public static final String DICT_RESOURCE_PATH = "/dictionary.json";
    public static Logger parsingIssuesLogger = ediParsingIssuesLogger;
    private FileInfo fileInfo;
    private final EdiMeta ediMeta = EdiMetaHolder.getEdiMeta();
    private final EdiDictionary dict = this.ediMeta.ediDictionary();
    private TransactionType currentTransactionType;
    private TransactionSchema transactionSchema;
    private final OpenEdiSchemaHolder openEdiSchemaHolder = new OpenEdiSchemaHolder();
    private Scanner scan;
    private String segmentLineBuffer = "";
    private EdiSegment lastSegment = null;
    private SegmentType stopSegType = null;
    private EdiSegment lastParentSegment = null;
    private String componentElementSeparator = ":";
    private final Map<String, EdiSegment> loopParentSegments = new LinkedHashMap<String, EdiSegment>();
    protected String globLoopId = "";
    protected String loopPrevId = "";
    private EdiSeparators ediSeparators;
    private int maxNumberOfIssues = -1;
    private List<SegmentType> splitSegTypes = new ArrayList<SegmentType>();
    private boolean isSplitMode = false;
    private Collection<SegmentType> stopSegTypes = List.of(SegmentType.SE);
    private int segNumber = 0;
    private int lineNumber = 0;
    private int numberOfIssues = 0;
    private List<ParsingIssue> parsingIssues = new ArrayList<ParsingIssue>();
    private final Reader reader;
    private boolean isFragmentMode = false;
    private boolean isStrictMode = false;
    private boolean isSuppressIssueLogging = false;
    private LocalDateTime functionalGroupCreationGSDateAndTime;
    public static final int MAX_ISSUES = 2000;

    public LegacyEdiParser(File ediFile) {
        this.reader = IOUtils.toBufferedReader((Reader)new FileReader(ediFile));
        this.initParsing();
    }

    @Override
    public void close() {
        this.scan.close();
        IOUtils.closeQuietly((Reader)this.reader);
    }

    public LegacyEdiParser(FileInfo fileInfo, boolean isStrictMode, boolean isFragmentMode, boolean isSuppressIssueLogging) {
        this.fileInfo = fileInfo;
        this.isStrictMode = isStrictMode;
        this.isFragmentMode = isFragmentMode;
        this.isSuppressIssueLogging = isSuppressIssueLogging;
        this.reader = IOUtils.toBufferedReader((Reader)fileInfo.getContent());
        this.initParsing();
    }

    private void initParsing() {
        this.parsingIssues = new ArrayList<ParsingIssue>();
        this.numberOfIssues = 0;
        this.segNumber = 0;
        this.lineNumber = 0;
        try {
            this.ediSeparators = IsaParser.attemptToParseISA(this.reader);
        }
        catch (IOException e) {
            if (e instanceof MalformedInputException) {
                this.registerParsingIssue(ParsingIssueSeverity.ERROR, "Encountered binary input at the beginning of the file; is this a valid text/EDI file?", new String[0]);
            } else {
                log.error("Encountered exception while initiating file parsing", (Throwable)e);
                this.registerParsingIssue(ParsingIssueSeverity.ERROR, "Encountered exception while initiating parsing: %s", e.toString());
            }
        }
        catch (EdiParserException e) {
            this.registerParsingIssue(ParsingIssueSeverity.ERROR, e.getMessage(), new String[0]);
        }
        if (this.ediSeparators.isaParsingErrorMessage() != null) {
            this.registerParsingIssue(ParsingIssueSeverity.WARNING, this.ediSeparators.isaParsingErrorMessage(), new String[0]);
        }
        if (this.ediSeparators.isIsaNotFound()) {
            this.registerParsingIssue("'ISA' segment not found, using default separators: %s", this.ediSeparators.toSeparatorsString());
            try {
                boolean isEdiSeparatorFound = IsaParser.probeForEdiDelimiter(this.reader, 500, this.ediSeparators);
                if (!isEdiSeparatorFound) {
                    this.registerParsingIssue(ParsingIssueSeverity.ERROR, "Did not find X12 EDI separators at the beginning of the file, is this an EDI file? Expected separators: %s", this.ediSeparators.toSeparatorsString());
                }
            }
            catch (IOException e) {
                log.error("Encountered exception while initiating file parsing", (Throwable)e);
                this.registerParsingIssue(ParsingIssueSeverity.ERROR, "Encountered exception while initiating parsing: %s", e.toString());
            }
        }
        this.scan = new Scanner(this.reader);
        this.scan.useDelimiter("\\Q" + this.ediSeparators.segmentTerminator() + "\\E");
        this.componentElementSeparator = this.ediSeparators.componentElementSeparator();
    }

    EdiSegment parseTransaction() {
        List<EdiSegment> segs = this.parseSegments();
        for (EdiSegment seg : segs) {
            if (seg.type() != SegmentType.ST) continue;
            return seg;
        }
        return null;
    }

    public List<EdiSegment> parseSegments() {
        ArrayList<EdiSegment> segs = new ArrayList<EdiSegment>();
        if (!this.scan.hasNext()) {
            this.lastSegment = null;
            this.lastParentSegment = null;
            return segs;
        }
        while (this.scan.hasNext()) {
            this.stopSegType = null;
            boolean isReparsed = false;
            if (this.segmentLineBuffer.isEmpty()) {
                this.segmentLineBuffer = this.scan.next();
                int numberOfNewLines = WordStringUtils.countNumberOfCharInWhitespace(this.segmentLineBuffer, '\n');
                this.lineNumber += numberOfNewLines;
                this.segmentLineBuffer = StringUtils.strip((String)this.segmentLineBuffer);
                ++this.segNumber;
            } else {
                isReparsed = true;
            }
            EdiSegment seg = this.preParseSegment(this.segmentLineBuffer);
            if (seg == null) {
                this.segmentLineBuffer = "";
                continue;
            }
            if (!isReparsed && seg.type() != null && this.isSplitMode && seg.type().isOneOf(this.splitSegTypes)) break;
            if (!seg.isControlSegment() && this.currentTransactionType == null) {
                ParsingIssueSeverity severity = ParsingIssueSeverity.ERROR;
                Object message = "Did not find 'ST' segment to determine transaction type";
                if (this.isFragmentMode) {
                    severity = ParsingIssueSeverity.WARNING;
                    this.currentTransactionType = TransactionType.PROF;
                    this.loopParentSegments.clear();
                    message = (String)message + ". Default to " + this.currentTransactionType.ediCode() + " schema";
                }
                this.registerParsingIssue(severity, (String)message, new String[0]);
            }
            this.parseSegment(segs, seg);
            if (seg.type() == SegmentType.GS && seg.elements.containsKey("date") && seg.elements.get("date") instanceof LocalDate && seg.elements.containsKey("time") && seg.elements.get("time") instanceof LocalTime) {
                this.functionalGroupCreationGSDateAndTime = LocalDateTime.of((LocalDate)seg.elements.get("date"), (LocalTime)seg.elements.get("time"));
            }
            if (seg.type() == SegmentType.ST) {
                seg.functionalGroupCreationGSDateAndTime(this.functionalGroupCreationGSDateAndTime);
            }
            this.segmentLineBuffer = "";
            if (seg.type() == null || !seg.type().isOneOf(this.stopSegTypes)) continue;
            this.stopSegType = seg.type();
            break;
        }
        return segs;
    }

    private void initiateTran(EdiSegment seg) {
        this.loopParentSegments.clear();
        this.splitSegTypes = List.of();
        String tranId = seg.getRawElt(1);
        String messageVersion = seg.getRawElt(3);
        if (Strings.CS.startsWith((CharSequence)tranId, (CharSequence)"837")) {
            this.splitSegTypes = List.of(SegmentType.CLM);
        } else if (Strings.CS.startsWith((CharSequence)tranId, (CharSequence)"835")) {
            this.splitSegTypes = List.of(SegmentType.CLP, SegmentType.PLB);
        } else if (Strings.CS.startsWith((CharSequence)tranId, (CharSequence)"834")) {
            this.splitSegTypes = List.of(SegmentType.INS);
        }
        if (!StringUtils.startsWithAny((CharSequence)tranId, (CharSequence[])new CharSequence[]{"837", "835"})) {
            this.currentTransactionType = TransactionType.UNKNOWN;
            this.transactionSchema = this.openEdiSchemaHolder.getSchema(tranId, messageVersion);
            if (this.transactionSchema != null) {
                log.debug("Using OpenEDI schema for transaction {}", (Object)tranId);
            }
        } else {
            this.currentTransactionType = TransactionType.fromST(seg);
        }
        if (this.transactionSchema == null && this.currentTransactionType == TransactionType.UNKNOWN) {
            ParsingIssueSeverity severity = ParsingIssueSeverity.ERROR;
            Object tranIdAndMessageVersion = tranId;
            if (messageVersion != null) {
                tranIdAndMessageVersion = (String)tranIdAndMessageVersion + "*" + messageVersion;
            }
            Object message = "Unknown X12 EDI transaction or version '%s'";
            if (this.isFragmentMode) {
                severity = ParsingIssueSeverity.WARNING;
                this.currentTransactionType = TransactionType.PROF;
                message = (String)message + ". Default to " + this.currentTransactionType.ediCode() + " schema";
            }
            this.registerParsingIssue(severity, (String)message, new String[]{tranIdAndMessageVersion});
        }
        this.lastParentSegment = seg;
    }

    public TransactionType currentTransactionType() {
        return this.currentTransactionType;
    }

    public EdiSegment getCurrentRootParent() {
        EdiSegment currentParent = this.lastParentSegment;
        if (currentParent == null) {
            return null;
        }
        while (currentParent.parent != null) {
            currentParent = currentParent.parent;
        }
        return currentParent;
    }

    private EdiSegment preParseSegment(String segmentString) {
        boolean loopCalculated;
        EdiSegment seg = new EdiSegment();
        if (StringUtils.isBlank((CharSequence)segmentString)) {
            return null;
        }
        String[] elements = StringUtils.splitPreserveAllTokens((String)segmentString, (String)this.ediSeparators.elementSeparator());
        if (elements.length < 2) {
            ParsingIssueSeverity severity = ParsingIssueSeverity.WARNING;
            Object msg = "Did not find element separator %s";
            if (this.segNumber == 1) {
                severity = ParsingIssueSeverity.ERROR;
                msg = (String)msg + ". Is this an EDI file?";
            }
            this.registerParsingIssue(severity, (String)msg, this.ediSeparators.elementSeparator());
            return null;
        }
        String tag = elements[0];
        if (StringUtils.length((CharSequence)(tag = StringUtils.strip((String)StringUtils.substringBefore((String)tag, (String)"\n")))) > 3) {
            tag = StringUtils.abbreviate((String)tag, (int)30);
            ParsingIssueSeverity severity = ParsingIssueSeverity.WARNING;
            Object msg = "This is not a valid EDI tag, it's too long: %s";
            if (this.segNumber == 1) {
                severity = ParsingIssueSeverity.ERROR;
                msg = (String)msg + ". Is this an EDI file?";
            }
            this.registerParsingIssue(severity, (String)msg, tag);
            return null;
        }
        seg.tag(tag);
        seg.rawElts(Arrays.asList(elements));
        if (seg.type() == SegmentType.ST) {
            this.initiateTran(seg);
        }
        if (this.transactionSchema == null && !(loopCalculated = this.calculateLoop(seg, elements, this.currentTransactionType))) {
            throw new EdiParserException("Loops could not be calculated, quitting.", new Object[0]);
        }
        seg.qualifier(elements[1].toUpperCase());
        int iCodeColonPosition = seg.qualifier().indexOf(this.componentElementSeparator);
        if (iCodeColonPosition > -1) {
            seg.qualifier(seg.qualifier().substring(0, iCodeColonPosition));
        }
        seg.loop(this.getGlobLoopId());
        return seg;
    }

    private void parseSegment(List<EdiSegment> rootSegs, EdiSegment seg) {
        if (seg == null) {
            return;
        }
        SegmentDictionary segDict = this.transactionSchema == null || seg.isControlSegment() ? this.findSegMeta(seg) : this.findSegMetaUsingOpenEdi(seg);
        boolean isSegmentValid = true;
        if (segDict == null) {
            log.debug("Was not able to find segment metadata for this segment (loop {}): {}", (Object)this.getGlobLoopId(), (Object)seg);
            if (this.isFragmentMode) {
                this.addToLastParentSegment(seg);
            } else {
                isSegmentValid = false;
            }
        } else {
            seg.name(segDict.getJsonName());
            seg.description(segDict.getDescription());
            if (this.transactionSchema == null && StringUtils.isNotBlank((CharSequence)segDict.getParent())) {
                EdiSegment parentSegment = this.identifyParent(segDict);
                if (parentSegment != null) {
                    parentSegment.segments.add(seg);
                    seg.parent = parentSegment;
                    this.lastParentSegment = parentSegment;
                    this.lastSegment = seg;
                } else {
                    if (!this.isFragmentMode) {
                        isSegmentValid = false;
                    } else {
                        this.addToLastParentSegment(seg);
                        this.lastSegment = seg;
                    }
                    String lastParentSegmentKey = "";
                    if (this.lastParentSegment != null) {
                        lastParentSegmentKey = this.lastParentSegment.hashTag();
                    }
                    this.registerParsingIssue("Unexpected segment '%s'. It should be part of loop %s but found in %s", seg.tag(), this.segKeyToMessage(segDict.getParent()), this.segKeyToMessage(lastParentSegmentKey));
                }
            }
            this.parseElements(segDict, seg);
        }
        if (seg.parent == null && isSegmentValid) {
            rootSegs.add(seg);
        }
    }

    private String segKeyToMessage(String segKey) {
        if (StringUtils.isBlank((CharSequence)segKey)) {
            return "root loop";
        }
        String segLoop = StringUtils.replace((String)segKey, (String)"__", (String)" ");
        segLoop = StringUtils.replace((String)segLoop, (String)"_", (String)" ");
        return segLoop;
    }

    private void addToLastParentSegment(EdiSegment seg) {
        if (this.lastParentSegment != null) {
            this.lastParentSegment.segments.add(seg);
            seg.parent = this.lastParentSegment;
        }
    }

    private EdiSegment identifyParent(SegmentDictionary segDict) {
        if (StringUtils.isBlank((CharSequence)segDict.getParent())) {
            return null;
        }
        EdiSegment parent = null;
        if (this.transactionSchema == null) {
            parent = this.lastParentSegment != null && this.lastParentSegment.hashTag().equals(segDict.getParent()) ? this.lastParentSegment : (this.lastSegment != null && this.lastSegment.hashTag().equals(segDict.getParent()) ? this.lastSegment : this.findParent(segDict.getParent(), this.lastParentSegment));
        }
        return parent;
    }

    private void parseElements(SegmentDictionary segDict, EdiSegment seg) {
        String[] elements = seg.rawElts().toArray(new String[0]);
        HashMap<String, Integer> repeatingNames = new HashMap<String, Integer>();
        for (ElementWithChildrenDictionary eltMeta : segDict.elements) {
            Object elValueObject;
            if (elements.length <= eltMeta.getIndex() || StringUtils.isEmpty((CharSequence)elements[eltMeta.getIndex()])) continue;
            String elValueString = elements[eltMeta.getIndex()];
            boolean isConversionFailure = false;
            Object eltName = eltMeta.getJsonName();
            if (!eltMeta.getSubElements().isEmpty()) {
                String separator = this.ediSeparators.componentElementSeparator();
                elValueString = StringUtils.trim((String)elValueString);
                String[] subElements = StringUtils.splitPreserveAllTokens((String)elValueString, (String)separator);
                EdiElement element = new EdiElement();
                element.value = elValueString;
                for (ElementDictionary subeltMeta : eltMeta.getSubElements()) {
                    if (subeltMeta.getIndex() >= subElements.length) break;
                    String subElValue = subElements[subeltMeta.getIndex()];
                    ValConversionResult conversionResult = this.convertValueType(subeltMeta, subElValue);
                    element.subElements.put(subeltMeta.getJsonName(), conversionResult.val);
                    EltValHolder eltValHolder = new EltValHolder(subeltMeta, subElValue, conversionResult.val).segmentNumber(this.segNumber).lineNumber(this.lineNumber);
                    eltValHolder.isFailedConversion(conversionResult.isFailure);
                    element.getEltHolders().add(eltValHolder);
                }
                elValueObject = element;
            } else {
                if (seg.type() == SegmentType.ISA && eltMeta.ediDataType() == EdiDataType.DATE) {
                    elValueString = StringUtils.right((String)elValueString, (int)6);
                }
                if (eltMeta.isArray()) {
                    elValueObject = this.convertArray(elValueString);
                } else {
                    ValConversionResult conversionResult = this.convertValueType(eltMeta, elValueString);
                    elValueObject = conversionResult.val;
                    isConversionFailure = conversionResult.isFailure;
                }
            }
            if (seg.elements.containsKey(eltName)) {
                Integer repeatingEltInd = repeatingNames.getOrDefault(eltName, 2);
                repeatingNames.put((String)eltName, repeatingEltInd + 1);
                eltName = (String)eltName + "_" + repeatingEltInd;
                eltMeta.jsonName((String)eltName);
            }
            seg.elements.put((String)eltName, elValueObject);
            EltValHolder eltValHolder = new EltValHolder(eltMeta, elValueString, elValueObject).isFailedConversion(isConversionFailure).segmentNumber(this.segNumber).lineNumber(this.lineNumber);
            seg.eltHolders().add(eltValHolder);
        }
    }

    private EdiSegment findParent(String parentHashTag, EdiSegment lastParent) {
        if (lastParent == null) {
            return null;
        }
        if (lastParent.hashTag().equals(parentHashTag)) {
            return lastParent;
        }
        if (lastParent.parent == null) {
            return null;
        }
        return this.findParent(parentHashTag, lastParent.parent);
    }

    private List<String> convertArray(String ediStr) {
        String separator = this.ediSeparators.repetitionSeparator();
        String[] arr = StringUtils.split((String)ediStr, (String)separator);
        return Arrays.asList(arr);
    }

    private ValConversionResult convertValueType(ElementDictionary eltMeta, String value) {
        if (value == null) {
            return new ValConversionResult();
        }
        EdiDataType dataType = eltMeta.ediDataType();
        int scale = eltMeta.getScale();
        String formatString = eltMeta.getFormat();
        Object objVal = value;
        boolean isFailure = false;
        if (dataType != null) {
            switch (dataType) {
                case DECIMAL: {
                    value = StringUtils.strip((String)value);
                    if (value.isBlank()) {
                        new ValConversionResult(value, null, false);
                    }
                    try {
                        objVal = Double.parseDouble(value);
                    }
                    catch (NumberFormatException ex) {
                        this.registerParsingIssue("Element: %s: Unable to convert string %s to decimal number. Error: %s", eltMeta.getDesignatorNameForLogging(), value, ex.getMessage());
                        isFailure = true;
                    }
                    break;
                }
                case NUMERIC: {
                    value = StringUtils.strip((String)value);
                    if (value.isBlank()) {
                        new ValConversionResult(value, null, false);
                    }
                    if (scale <= 0) {
                        try {
                            objVal = Integer.parseInt(value);
                        }
                        catch (NumberFormatException ex) {
                            this.registerParsingIssue("Element: %s: Unable to convert string %s to integer number. Error: %s", eltMeta.getDesignatorNameForLogging(), value, ex.getMessage());
                            isFailure = true;
                        }
                        break;
                    }
                    try {
                        objVal = NumbersUtils.convertToBigDecimalAccordingToScale(value, scale);
                    }
                    catch (NumberFormatException ex) {
                        this.registerParsingIssue("Element: %s: Unable to convert string %s to numeric value with %s decimal points. Error: %s", eltMeta.getDesignatorNameForLogging(), value, Integer.toString(scale), ex.getMessage());
                        isFailure = true;
                    }
                    break;
                }
                case DATE: {
                    if (value.isBlank()) {
                        return new ValConversionResult(value, null, false);
                    }
                    String dateFormat = StringUtils.isBlank((CharSequence)formatString) ? "yyyyMMdd" : formatString.replace("C", "y").replace("Y", "y").replace("D", "d");
                    DateTimeFormatter formatter = DateTimeFormatter.ofPattern(dateFormat);
                    if (dateFormat.contains("-")) {
                        return new ValConversionResult(value, null, false);
                    }
                    try {
                        objVal = LocalDate.parse(value, formatter);
                    }
                    catch (DateTimeParseException dtex) {
                        this.registerParsingIssue("Element: %s: Unable to convert string %s to date. Expected date format: %s", eltMeta.getDesignatorNameForLogging(), value, dateFormat);
                        isFailure = true;
                    }
                    break;
                }
                case TIME: {
                    if (value.isBlank()) {
                        return new ValConversionResult(value, null, false);
                    }
                    String timeFormat = StringUtils.isBlank((CharSequence)formatString) ? "HHmmssSS" : formatString.replace("M", "m");
                    if (value.length() > timeFormat.length()) {
                        value = StringUtils.left((String)value, (int)timeFormat.length());
                    } else if (value.length() < timeFormat.length()) {
                        timeFormat = StringUtils.left((String)timeFormat, (int)value.length());
                    }
                    DateTimeFormatter timeFormatter = DateTimeFormatter.ofPattern(timeFormat);
                    try {
                        objVal = LocalTime.parse(value, timeFormatter);
                        break;
                    }
                    catch (DateTimeParseException dtex) {
                        this.registerParsingIssue("Element: %s: Unable to convert string %s to time. Expected time format: %s", eltMeta.getDesignatorNameForLogging(), value, timeFormat);
                        isFailure = true;
                    }
                }
            }
        }
        return new ValConversionResult(value, objVal, isFailure);
    }

    public String getGlobLoopId() {
        return this.globLoopId;
    }

    public void setGlobLoopId(String globLoopId) {
        this.globLoopId = globLoopId;
    }

    public String getLoopPrevId() {
        return this.loopPrevId;
    }

    public void setLoopPrevId(String loopPrevId) {
        this.loopPrevId = loopPrevId;
    }

    public boolean calculateLoop(EdiSegment seg, String[] elements, TransactionType fileTransactionType) {
        if (seg.isControlSegment()) {
            this.globLoopId = "0000";
            this.loopPrevId = "0";
            return true;
        }
        if (fileTransactionType == TransactionType.PROF) {
            return this.calculateProfessionalLoop(elements);
        }
        if (fileTransactionType == TransactionType.INST) {
            return this.calculateInstitutionalLoop(elements);
        }
        if (fileTransactionType == TransactionType.DENTAL) {
            return this.calculateDentalLoop(elements);
        }
        if (fileTransactionType == TransactionType.PAYMENT) {
            return this.calculatePaymentLoop(elements);
        }
        return this.calculateProfessionalLoop(elements);
    }

    public boolean calculateProfessionalLoop(String[] elements) {
        if (elements == null || elements.length < 1) {
            return false;
        }
        String loop = this.getGlobLoopId();
        try {
            if (elements[0].equals("ISA") || elements[0].equals("GS") || elements[0].equals("BHT") || elements[0].equals("ST") || elements[0].equals("SE")) {
                loop = "0000";
            } else if (elements[0].equals("NM1") && elements[1].equals("41")) {
                loop = "1000A";
            } else if (elements[0].equals("NM1") && elements[1].equals("40")) {
                loop = "1000B";
            } else if (elements.length > 3 && elements[0].equals("HL") && elements[3].equals("20")) {
                loop = "2000A";
            } else if (elements[0].equals("NM1") && elements[1].equals("85") && !this.getLoopPrevId().equals("2320")) {
                loop = "2010AA";
            } else if (elements[0].equals("NM1") && elements[1].equals("87")) {
                loop = "2010AB";
            } else if (elements[0].equals("NM1") && elements[1].equals("PE")) {
                loop = "2010AC";
            } else if (elements.length > 3 && elements[0].equals("HL") && elements[3].equals("22")) {
                loop = "2000B";
            } else if (elements[0].equals("SBR") && this.getLoopPrevId().equals("0")) {
                loop = "2000B";
            } else if (elements[0].equals("PAT") && this.getLoopPrevId().equals("2000B")) {
                loop = "2000B";
            } else if (elements[0].equals("NM1") && elements[1].equals("IL") && (this.getLoopPrevId().equals("0") || this.getLoopPrevId().equals("2000B"))) {
                loop = "2010BA";
            } else if (elements[0].equals("NM1") && elements[1].equals("PR") && (this.getLoopPrevId().equals("0") || this.getLoopPrevId().equals("2000B"))) {
                loop = "2010BB";
            } else if (elements.length > 3 && elements[0].equals("HL") && elements[3].equals("23")) {
                loop = "2000C";
            } else if (elements[0].equals("PAT") && this.getLoopPrevId().equals("2000C")) {
                loop = "2000C";
            } else if (elements[0].equals("NM1") && elements[1].equals("QC")) {
                loop = "2010CA";
            } else if (elements[0].equals("CLM")) {
                loop = "2300";
            } else if (elements[0].equals("NM1") && (elements[1].equals("DN") || elements[1].equals("P3")) && this.getLoopPrevId().equals("2300")) {
                loop = "2310A";
            } else if (elements[0].equals("NM1") && elements[1].equals("82") && this.getLoopPrevId().equals("2300")) {
                loop = "2310B";
            } else if (elements[0].equals("NM1") && elements[1].equals("77") && this.getLoopPrevId().equals("2300")) {
                loop = "2310C";
            } else if (elements[0].equals("NM1") && elements[1].equals("DQ") && this.getLoopPrevId().equals("2300")) {
                loop = "2310D";
            } else if (elements[0].equals("NM1") && elements[1].equals("PW") && this.getLoopPrevId().equals("2300")) {
                loop = "2310E";
            } else if (elements[0].equals("NM1") && elements[1].equals("45") && this.getLoopPrevId().equals("2300")) {
                loop = "2310F";
            } else if (elements[0].equals("SBR") && (this.getLoopPrevId().equals("2300") || this.getLoopPrevId().equals("2320"))) {
                loop = "2320";
            } else if (elements[0].equals("NM1") && elements[1].equals("IL") && this.getLoopPrevId().equals("2320")) {
                loop = "2330A";
            } else if (elements[0].equals("NM1") && elements[1].equals("PR") && this.getLoopPrevId().equals("2320")) {
                loop = "2330B";
            } else if (elements[0].equals("NM1") && (elements[1].equals("DN") || elements[1].equals("P3")) && this.getLoopPrevId().equals("2320")) {
                loop = "2330C";
            } else if (elements[0].equals("NM1") && elements[1].equals("82") && this.getLoopPrevId().equals("2320")) {
                loop = "2330D";
            } else if (elements[0].equals("NM1") && elements[1].equals("DQ") && this.getLoopPrevId().equals("2320")) {
                loop = "2330F";
            } else if (elements[0].equals("NM1") && elements[1].equals("85") && this.getLoopPrevId().equals("2320")) {
                loop = "2330G";
            } else if (elements[0].equals("NM1") && elements[1].equals("77") && this.getLoopPrevId().equals("2320")) {
                loop = "2330E";
            } else if (elements[0].equals("NM1") && elements[1].equals("DD") && this.getLoopPrevId().equals("2320")) {
                loop = "2330H";
            } else if (elements[0].equals("LX")) {
                loop = "2400";
            } else if (elements[0].equals("LIN") || elements[0].equals("CTP")) {
                loop = "2410";
            } else if (elements[0].equals("NM1") && elements[1].equals("82") && this.getLoopPrevId().equals("2400")) {
                loop = "2420A";
            } else if (elements[0].equals("NM1") && elements[1].equals("QB") && this.getLoopPrevId().equals("2400")) {
                loop = "2420B";
            } else if (elements[0].equals("NM1") && elements[1].equals("77") && this.getLoopPrevId().equals("2400")) {
                loop = "2420C";
            } else if (elements[0].equals("NM1") && elements[1].equals("DQ") && this.getLoopPrevId().equals("2400")) {
                loop = "2420D";
            } else if (elements[0].equals("NM1") && elements[1].equals("DK") && this.getLoopPrevId().equals("2400")) {
                loop = "2420E";
            } else if (elements[0].equals("NM1") && (elements[1].equals("DN") || elements[1].equals("P3")) && this.getLoopPrevId().equals("2400")) {
                loop = "2420F";
            } else if (elements[0].equals("NM1") && elements[1].equals("PW") && this.getLoopPrevId().equals("2400")) {
                loop = "2420G";
            } else if (elements[0].equals("NM1") && elements[1].equals("45") && this.getLoopPrevId().equals("2400")) {
                loop = "2420H";
            } else if (elements[0].equals("SVD")) {
                loop = "2430";
            } else if (elements[0].equals("FRM") || elements[0].equals("LQ")) {
                loop = "2440";
            }
            if (elements[0].equals("ISA") || elements[0].equals("GS") || elements[0].equals("BHT") || elements[0].equals("ST") || elements[0].equals("SE")) {
                this.setLoopPrevId("0");
            } else if (elements[0].equals("CLM")) {
                this.setLoopPrevId("2300");
            } else if (elements[0].equals("SBR") && this.getLoopPrevId().equals("2300")) {
                this.setLoopPrevId("2320");
            } else if (elements[0].equals("LX")) {
                this.setLoopPrevId("2400");
            } else if (elements.length > 3 && elements[0].equals("HL") && elements[3].equals("22")) {
                this.setLoopPrevId("2000B");
            } else if (elements.length > 3 && elements[0].equals("HL") && elements[3].equals("23")) {
                this.setLoopPrevId("2000C");
            }
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            log.error("Could not calculate loop, element index out of bound");
            return false;
        }
        this.setGlobLoopId(loop);
        return true;
    }

    public boolean calculateInstitutionalLoop(String[] elements) {
        if (elements == null || elements.length < 1) {
            return false;
        }
        String loop = this.getGlobLoopId();
        try {
            if (elements[0].equals("ISA") || elements[0].equals("GS") || elements[0].equals("BHT") || elements[0].equals("ST") || elements[0].equals("SE")) {
                loop = "0000";
            } else if (elements[0].equals("NM1") && elements[1].equals("41")) {
                loop = "1000A";
            } else if (elements[0].equals("NM1") && elements[1].equals("40")) {
                loop = "1000B";
            } else if (elements.length > 3 && elements[0].equals("HL") && elements[3].equals("20")) {
                loop = "2000A";
            } else if (elements[0].equals("NM1") && elements[1].equals("85") && !this.getLoopPrevId().equals("2320")) {
                loop = "2010AA";
            } else if (elements[0].equals("NM1") && elements[1].equals("87")) {
                loop = "2010AB";
            } else if (elements[0].equals("NM1") && elements[1].equals("PE")) {
                loop = "2010AC";
            } else if (elements.length > 3 && elements[0].equals("HL") && elements[3].equals("22")) {
                loop = "2000B";
            } else if (elements[0].equals("SBR") && this.getLoopPrevId().equals("0")) {
                loop = "2000B";
            } else if (elements[0].equals("NM1") && elements[1].equals("IL") && (this.getLoopPrevId().equals("0") || this.getLoopPrevId().equals("2000B"))) {
                loop = "2010BA";
            } else if (elements[0].equals("NM1") && elements[1].equals("PR") && (this.getLoopPrevId().equals("0") || this.getLoopPrevId().equals("2000B"))) {
                loop = "2010BB";
            } else if (elements.length > 3 && elements[0].equals("HL") && elements[3].equals("23")) {
                loop = "2000C";
            } else if (elements[0].equals("PAT")) {
                loop = "2000C";
            } else if (elements[0].equals("NM1") && elements[1].equals("QC")) {
                loop = "2010CA";
            } else if (elements[0].equals("CLM")) {
                loop = "2300";
            } else if (elements[0].equals("NM1") && elements[1].equals("71") && this.getLoopPrevId().equals("2300")) {
                loop = "2310A";
            } else if (elements[0].equals("NM1") && elements[1].equals("72") && this.getLoopPrevId().equals("2300")) {
                loop = "2310B";
            } else if (elements[0].equals("NM1") && elements[1].equals("ZZ") && this.getLoopPrevId().equals("2300")) {
                loop = "2310C";
            } else if (elements[0].equals("NM1") && elements[1].equals("82") && this.getLoopPrevId().equals("2300")) {
                loop = "2310D";
            } else if (elements[0].equals("NM1") && elements[1].equals("77") && this.getLoopPrevId().equals("2300")) {
                loop = "2310E";
            } else if (elements[0].equals("NM1") && elements[1].equals("DN") && this.getLoopPrevId().equals("2300")) {
                loop = "2310F";
            } else if (elements[0].equals("SBR") && (this.getLoopPrevId().equals("2300") || this.getLoopPrevId().equals("2320"))) {
                loop = "2320";
            } else if (elements[0].equals("NM1") && elements[1].equals("IL") && this.getLoopPrevId().equals("2320")) {
                loop = "2330A";
            } else if (elements[0].equals("NM1") && elements[1].equals("PR") && this.getLoopPrevId().equals("2320")) {
                loop = "2330B";
            } else if (elements[0].equals("NM1") && elements[1].equals("71") && this.getLoopPrevId().equals("2320")) {
                loop = "2330C";
            } else if (elements[0].equals("NM1") && elements[1].equals("72") && this.getLoopPrevId().equals("2320")) {
                loop = "2330D";
            } else if (elements[0].equals("NM1") && elements[1].equals("ZZ") && this.getLoopPrevId().equals("2320")) {
                loop = "2330E";
            } else if (elements[0].equals("NM1") && elements[1].equals("77") && this.getLoopPrevId().equals("2320")) {
                loop = "2330F";
            } else if (elements[0].equals("NM1") && elements[1].equals("82") && this.getLoopPrevId().equals("2320")) {
                loop = "2330G";
            } else if (elements[0].equals("NM1") && elements[1].equals("DN") && this.getLoopPrevId().equals("2320")) {
                loop = "2330H";
            } else if (elements[0].equals("NM1") && elements[1].equals("85") && this.getLoopPrevId().equals("2320")) {
                loop = "2330I";
            } else if (elements[0].equals("LX")) {
                loop = "2400";
            } else if (elements[0].equals("LIN") || elements[0].equals("CTP") || elements[0].equals("REF") && this.getLoopPrevId().equals("2410")) {
                loop = "2410";
            } else if (elements[0].equals("NM1") && elements[1].equals("72") && this.getLoopPrevId().equals("2400")) {
                loop = "2420A";
            } else if (elements[0].equals("NM1") && elements[1].equals("ZZ") && this.getLoopPrevId().equals("2400")) {
                loop = "2420B";
            } else if (elements[0].equals("NM1") && elements[1].equals("82") && this.getLoopPrevId().equals("2400")) {
                loop = "2420C";
            } else if (elements[0].equals("NM1") && elements[1].equals("DN") && this.getLoopPrevId().equals("2400")) {
                loop = "2420D";
            } else if (elements[0].equals("SVD")) {
                loop = "2430";
            } else if (elements[0].equals("FRM") || elements[0].equals("LQ")) {
                loop = "2440";
            }
            if (elements[0].equals("ISA") || elements[0].equals("GS") || elements[0].equals("BHT") || elements[0].equals("ST") || elements[0].equals("SE")) {
                this.setLoopPrevId("0");
            } else if (elements[0].equals("CLM")) {
                this.setLoopPrevId("2300");
            } else if (elements[0].equals("SBR") && this.getLoopPrevId().equals("2300")) {
                this.setLoopPrevId("2320");
            } else if (elements[0].equals("LX")) {
                this.setLoopPrevId("2400");
            } else if (elements.length > 3 && elements[0].equals("HL") && elements[3].equals("22")) {
                this.setLoopPrevId("2000B");
            } else if (elements.length > 3 && elements[0].equals("HL") && elements[3].equals("23")) {
                this.setLoopPrevId("2000C");
            }
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            log.error("Could not calculate loop, element index out of bound");
            return false;
        }
        this.setGlobLoopId(loop);
        return true;
    }

    public boolean calculateDentalLoop(String[] elements) {
        if (elements == null || elements.length < 1) {
            return false;
        }
        String loop = this.getGlobLoopId();
        try {
            if (elements[0].equals("ISA") || elements[0].equals("GS") || elements[0].equals("BHT") || elements[0].equals("ST") || elements[0].equals("SE")) {
                loop = "0000";
            } else if (elements[0].equals("NM1") && elements[1].equals("41")) {
                loop = "1000A";
            } else if (elements[0].equals("NM1") && elements[1].equals("40")) {
                loop = "1000B";
            } else if (elements.length > 3 && elements[0].equals("HL") && elements[3].equals("20")) {
                loop = "2000A";
            } else if (elements[0].equals("NM1") && elements[1].equals("85") && !this.getLoopPrevId().equals("2320")) {
                loop = "2010AA";
            } else if (elements[0].equals("NM1") && elements[1].equals("87")) {
                loop = "2010AB";
            } else if (elements[0].equals("NM1") && elements[1].equals("98")) {
                loop = "2010AC";
            } else if (elements.length > 3 && elements[0].equals("HL") && elements[3].equals("22")) {
                loop = "2000B";
            } else if (elements[0].equals("SBR") && this.getLoopPrevId().equals("0")) {
                loop = "2000B";
            } else if (elements[0].equals("NM1") && elements[1].equals("IL") && (this.getLoopPrevId().equals("0") || this.getLoopPrevId().equals("2000B"))) {
                loop = "2010BA";
            } else if (elements[0].equals("NM1") && elements[1].equals("PR") && (this.getLoopPrevId().equals("0") || this.getLoopPrevId().equals("2000B"))) {
                loop = "2010BB";
            } else if (elements.length > 3 && elements[0].equals("HL") && elements[3].equals("23")) {
                loop = "2000C";
            } else if (elements[0].equals("PAT")) {
                loop = "2000C";
            } else if (elements[0].equals("NM1") && elements[1].equals("QC")) {
                loop = "2010CA";
            } else if (elements[0].equals("CLM")) {
                loop = "2300";
            } else if (elements[0].equals("NM1") && (elements[1].equals("DN") || elements[1].equals("P3")) && this.getLoopPrevId().equals("2300")) {
                loop = "2310A";
            } else if (elements[0].equals("NM1") && elements[1].equals("82") && this.getLoopPrevId().equals("2300")) {
                loop = "2310B";
            } else if (elements[0].equals("NM1") && elements[1].equals("77") && this.getLoopPrevId().equals("2300")) {
                loop = "2310C";
            } else if (elements[0].equals("NM1") && elements[1].equals("DD") && this.getLoopPrevId().equals("2300")) {
                loop = "2310D";
            } else if (elements[0].equals("NM1") && elements[1].equals("DQ") && this.getLoopPrevId().equals("2300")) {
                loop = "2310E";
            } else if (elements[0].equals("SBR") && (this.getLoopPrevId().equals("2300") || this.getLoopPrevId().equals("2320"))) {
                loop = "2320";
            } else if (elements[0].equals("NM1") && elements[1].equals("IL") && this.getLoopPrevId().equals("2320")) {
                loop = "2330A";
            } else if (elements[0].equals("NM1") && elements[1].equals("PR") && this.getLoopPrevId().equals("2320")) {
                loop = "2330B";
            } else if (elements[0].equals("NM1") && (elements[1].equals("DN") || elements[1].equals("P3")) && this.getLoopPrevId().equals("2320")) {
                loop = "2330C";
            } else if (elements[0].equals("NM1") && elements[1].equals("82") && this.getLoopPrevId().equals("2320")) {
                loop = "2330D";
            } else if (elements[0].equals("NM1") && elements[1].equals("DQ") && this.getLoopPrevId().equals("2320")) {
                loop = "2330E";
            } else if (elements[0].equals("NM1") && elements[1].equals("85") && this.getLoopPrevId().equals("2320")) {
                loop = "2330F";
            } else if (elements[0].equals("NM1") && elements[1].equals("77") && this.getLoopPrevId().equals("2320")) {
                loop = "2330G";
            } else if (elements[0].equals("NM1") && elements[1].equals("DD") && this.getLoopPrevId().equals("2320")) {
                loop = "2330H";
            } else if (elements[0].equals("LX")) {
                loop = "2400";
            } else if (elements[0].equals("LIN") || elements[0].equals("CTP")) {
                loop = "2410";
            } else if (elements[0].equals("NM1") && elements[1].equals("82") && this.getLoopPrevId().equals("2400")) {
                loop = "2420A";
            } else if (elements[0].equals("NM1") && elements[1].equals("DD") && this.getLoopPrevId().equals("2400")) {
                loop = "2420B";
            } else if (elements[0].equals("NM1") && elements[1].equals("DQ") && this.getLoopPrevId().equals("2400")) {
                loop = "2420C";
            } else if (elements[0].equals("NM1") && elements[1].equals("77") && this.getLoopPrevId().equals("2400")) {
                loop = "2420D";
            } else if (elements[0].equals("SVD")) {
                loop = "2430";
            }
            if (elements[0].equals("ISA") || elements[0].equals("GS") || elements[0].equals("BHT") || elements[0].equals("ST") || elements[0].equals("SE")) {
                this.setLoopPrevId("0");
            } else if (elements[0].equals("CLM")) {
                this.setLoopPrevId("2300");
            } else if (elements[0].equals("SBR") && this.getLoopPrevId().equals("2300")) {
                this.setLoopPrevId("2320");
            } else if (elements[0].equals("LX")) {
                this.setLoopPrevId("2400");
            } else if (elements.length > 3 && elements[0].equals("HL") && elements[3].equals("22")) {
                this.setLoopPrevId("2000B");
            }
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            log.error("Could not calculate loop, element index out of bound");
            return false;
        }
        this.setGlobLoopId(loop);
        return true;
    }

    public boolean calculatePaymentLoop(String[] elements) {
        if (elements == null || elements.length < 1) {
            return false;
        }
        String loop = this.getGlobLoopId();
        this.setLoopPrevId(loop);
        try {
            if (elements[0].equals("ISA") || elements[0].equals("GS") || elements[0].equals("BPR") || elements[0].equals("TRN") || elements[0].equals("CUR") || elements[0].equals("ST") || elements[0].equals("SE") || elements[0].equals("IEA") || elements[0].equals("PLB")) {
                loop = "0000";
            } else if ((elements[0].equals("REF") || elements[0].equals("DTM")) && this.getGlobLoopId().equals("0000")) {
                loop = "0000";
            } else if (elements[0].equals("N1") && elements[1].equals("PR") && this.getGlobLoopId().equals("0000")) {
                loop = "1000A";
            } else if (elements[0].equals("N1") && elements[1].equals("PE")) {
                loop = "1000B";
            } else if (elements[0].equals("LX")) {
                loop = "2000";
            } else if (elements[0].equals("CLP")) {
                loop = "2100";
            } else if (elements[0].equals("SVC")) {
                loop = "2110";
            }
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            log.error("Could not calculate loop, element index out of bound");
            return false;
        }
        this.setGlobLoopId(loop);
        return true;
    }

    private SegmentDictionary findSegMeta(EdiSegment seg) {
        SegmentDictionary segDict;
        TransactionType tranType = this.currentTransactionType;
        if ((tranType == null || tranType == TransactionType.UNKNOWN) && seg.isControlSegment()) {
            tranType = TransactionType.PROF;
        }
        if ((segDict = this.findSegDict(tranType, seg.tag(), seg.qualifier(), this.getGlobLoopId())) == null) {
            segDict = this.ediMeta.findSegDict(seg.rawElts(), this.getGlobLoopId());
            if (segDict == null) {
                this.registerParsingIssue("Unknown segment '%s'", seg.tag());
            } else {
                segDict = new SegmentDictionary(segDict);
                EdiSegment parentSegment = this.determineParent();
                if (parentSegment != null) {
                    segDict.setParent(parentSegment.hashTag());
                }
                this.registerParsingIssue("Unexpected segment '%s' for this EDI loop", seg.tag());
                if (!this.isFragmentMode) {
                    segDict = null;
                }
            }
        }
        return segDict;
    }

    private EdiSegment determineParent() {
        EdiSegment parentSegment = null;
        if (this.lastParentSegment != null) {
            parentSegment = this.lastSegment != null && !this.lastSegment.loop().equals(this.lastParentSegment.loop()) ? this.lastSegment : this.lastParentSegment;
        }
        return parentSegment;
    }

    private SegmentDictionary findSegDict(TransactionType tranType, String segType, String qualifierCode, String loopId) {
        String segKey;
        Map<String, SegmentDictionary> tranDict = this.dict.getDictionary(tranType);
        SegmentDictionary segDict = tranDict.get(segKey = this.createSegKey(segType, qualifierCode, loopId));
        if (segDict == null) {
            segKey = this.createSegKey(segType, null, loopId);
            segDict = tranDict.get(segKey);
        }
        if (segDict == null && StringUtils.isNotBlank((CharSequence)qualifierCode)) {
            segKey = this.createSegKey(segType, this.adjustQualifierCode(segType, qualifierCode), loopId);
            segDict = tranDict.get(segKey);
        }
        return segDict;
    }

    private String createSegKey(String segType, String qualifierCode, String loopId) {
        if (qualifierCode == null) {
            qualifierCode = "";
        }
        return segType + "_" + qualifierCode + "_" + loopId;
    }

    private SegmentDictionary findSegMetaUsingOpenEdi(EdiSegment seg) {
        LoopSegRef segRefSchema;
        String segId = seg.tag();
        String loopId = this.getGlobLoopId();
        if (StringUtils.isBlank((CharSequence)loopId)) {
            loopId = "0000";
        }
        String code = seg.qualifier();
        if (seg.type() == SegmentType.HL) {
            code = seg.getRawElt(3);
            seg.qualifier(code);
            if (code == null) {
                ediParsingIssuesLogger.warn("HL element without code in the third position:\n{}", seg.rawElts());
            }
        }
        if ((segRefSchema = this.transactionSchema.findSeg(loopId, segId, code)) == null) {
            this.registerParsingIssue("Unknown segment '%s'", segId);
            return null;
        }
        if (!seg.isArray()) {
            seg.isArray(segRefSchema.isArray());
        }
        boolean isSegmentValid = true;
        EdiSegment parentSeg = this.loopParentSegments.get(segRefSchema.parentSegmentLoopId());
        if (segRefSchema.parentSegmentLoopId() != null && parentSeg == null) {
            this.registerParsingIssue("Unexpected segment '%s'. It should be part of loop %s but found in %s", seg.tag(), segRefSchema.parentSegmentLoopId(), loopId);
            parentSeg = this.getLastLoopParentSegment();
            if (!this.isFragmentMode) {
                isSegmentValid = false;
            }
        } else {
            String newLoopId = segRefSchema.parent().id();
            if (segRefSchema.isLoopFirst() || this.loopParentSegments.isEmpty()) {
                SchemaComponent schemaComponent = segRefSchema.parent();
                if (schemaComponent instanceof LoopSchema) {
                    LoopSchema loopSchema = (LoopSchema)schemaComponent;
                    seg.isArray(loopSchema.isArray());
                    seg.isLoopParent(true);
                }
                this.loopParentSegments.put(newLoopId, seg);
            }
            this.setGlobLoopId(newLoopId);
            seg.loop(newLoopId);
        }
        seg.parent = parentSeg;
        if (parentSeg != null && isSegmentValid) {
            parentSeg.segments().add(seg);
        }
        return segRefSchema.toLegacySegmentDictionary();
    }

    private EdiSegment getLastLoopParentSegment() {
        EdiSegment lastSegment = null;
        Iterator<EdiSegment> iterator = this.loopParentSegments.values().iterator();
        while (iterator.hasNext()) {
            EdiSegment ediSegment;
            lastSegment = ediSegment = iterator.next();
        }
        return lastSegment;
    }

    private String adjustQualifierCode(String segType, String code) {
        if (segType.equals("REF") && StringUtils.equalsAny((CharSequence)code, (CharSequence[])new CharSequence[]{"LU", "1G", "0B"})) {
            return "G2";
        }
        return code;
    }

    private void registerParsingIssue(String msg, String ... params) {
        this.registerParsingIssue(ParsingIssueSeverity.WARNING, msg, params);
    }

    private void registerParsingIssue(ParsingIssueSeverity severity, String msg, String ... params) {
        String message = String.format(msg, params);
        ParsingIssue parsingIssue = this.createParsingIssue(severity, message);
        if (this.parsingIssues.size() <= 2000) {
            this.parsingIssues.add(parsingIssue);
        } else {
            log.debug("Too many parsing issues");
        }
        String errorMsg = parsingIssue.toFormattedString();
        if (severity == ParsingIssueSeverity.WARNING && !this.isSuppressIssueLogging) {
            parsingIssuesLogger.warn(errorMsg);
        }
        ++this.numberOfIssues;
        if ((this.isStrictMode || severity == ParsingIssueSeverity.ERROR) && !StringUtils.startsWith((CharSequence)message, (CharSequence)"'ISA' segment not found")) {
            throw new EdiParserException(parsingIssue);
        }
        if (severity == ParsingIssueSeverity.ERROR || severity == null) {
            parsingIssuesLogger.error(errorMsg);
        }
        if (this.maxNumberOfIssues >= 0 && this.numberOfIssues >= this.maxNumberOfIssues) {
            Object tooManyMsg = "Too many EDI parsing issues or warnings";
            if (this.fileInfo != null && this.fileInfo.name() != null) {
                tooManyMsg = (String)tooManyMsg + " in file " + this.fileInfo.name();
            }
            ParsingIssue issue = this.createParsingIssue(ParsingIssueSeverity.ERROR, (String)tooManyMsg);
            issue.ediString(null);
            this.parsingIssues.add(issue);
            EdiParserException e = new EdiParserException((String)tooManyMsg, new Object[0]);
            e.issues(this.parsingIssues);
            throw e;
        }
    }

    private ParsingIssue createParsingIssue(ParsingIssueSeverity severity, String message) {
        ParsingIssue parsingIssue = new ParsingIssue(this.segNumber, message).severity(severity).lineNumber(this.lineNumber).ediString(StringUtils.stripToNull((String)this.segmentLineBuffer)).loop(StringUtils.stripToNull((String)this.globLoopId));
        if (this.fileInfo != null) {
            parsingIssue.fileName(this.fileInfo.name());
        }
        return parsingIssue;
    }

    @Generated
    public TransactionSchema transactionSchema() {
        return this.transactionSchema;
    }

    @Generated
    public LegacyEdiParser lastSegment(EdiSegment lastSegment) {
        this.lastSegment = lastSegment;
        return this;
    }

    @Generated
    public EdiSegment lastSegment() {
        return this.lastSegment;
    }

    @Generated
    public SegmentType stopSegType() {
        return this.stopSegType;
    }

    @Generated
    public LegacyEdiParser lastParentSegment(EdiSegment lastParentSegment) {
        this.lastParentSegment = lastParentSegment;
        return this;
    }

    @Generated
    public Map<String, EdiSegment> loopParentSegments() {
        return this.loopParentSegments;
    }

    @Generated
    public EdiSeparators ediSeparators() {
        return this.ediSeparators;
    }

    @Generated
    public LegacyEdiParser maxNumberOfIssues(int maxNumberOfIssues) {
        this.maxNumberOfIssues = maxNumberOfIssues;
        return this;
    }

    @Generated
    public LegacyEdiParser splitSegTypes(List<SegmentType> splitSegTypes) {
        this.splitSegTypes = splitSegTypes;
        return this;
    }

    @Generated
    public LegacyEdiParser isSplitMode(boolean isSplitMode) {
        this.isSplitMode = isSplitMode;
        return this;
    }

    @Generated
    public LegacyEdiParser stopSegTypes(Collection<SegmentType> stopSegTypes) {
        this.stopSegTypes = stopSegTypes;
        return this;
    }

    @Generated
    public List<ParsingIssue> parsingIssues() {
        return this.parsingIssues;
    }

    public record ValConversionResult(String sourceVal, Object val, boolean isFailure) {
        ValConversionResult() {
            this(null, null, false);
        }
    }
}

