/*
 * Decompiled with CFR 0.152.
 */
package hdi.edi.legacyparser;

import hdi.edi.legacyparser.ElementWithChildrenDictionary;
import hdi.edi.parser.NameUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import lombok.Generated;

public class SegmentDictionary
implements Comparable<SegmentDictionary> {
    private String parent;
    private String tag;
    private String code;
    private Set<String> codes = new LinkedHashSet<String>();
    private String loop;
    private String jsonName = "";
    private boolean isLineLevel;
    private boolean isHeader;
    private int repeat = 1;
    private boolean required;
    private String description = "";
    List<ElementWithChildrenDictionary> elements = new ArrayList<ElementWithChildrenDictionary>();

    public SegmentDictionary() {
    }

    public SegmentDictionary(String tag, String code, String loop, String jsonName) {
        this.tag = tag;
        this.code = code;
        this.loop = loop;
        this.jsonName = jsonName;
    }

    public SegmentDictionary(String tag, String code, String loop, String jsonName, boolean isLineLevel) {
        this.tag = tag;
        this.code = code;
        this.loop = loop;
        this.jsonName = jsonName;
        this.isLineLevel = isLineLevel;
    }

    public SegmentDictionary(String parent, String tag, String code, String loop, String jsonName, boolean isLineLevel, boolean isHeader, int repeat, boolean required) {
        this.parent = parent;
        this.tag = tag;
        this.code = code;
        this.loop = loop;
        this.jsonName = jsonName;
        this.isLineLevel = isLineLevel;
        this.isHeader = isHeader;
        this.repeat = repeat;
        this.required = required;
    }

    public SegmentDictionary(SegmentDictionary anotherSegDict) {
        this(anotherSegDict.parent, anotherSegDict.tag, anotherSegDict.code, anotherSegDict.loop, anotherSegDict.jsonName, anotherSegDict.isLineLevel, anotherSegDict.isHeader, anotherSegDict.repeat, anotherSegDict.required);
        this.description = anotherSegDict.description;
        for (ElementWithChildrenDictionary eltDict : anotherSegDict.elements) {
            this.elements.add(new ElementWithChildrenDictionary(eltDict));
        }
        this.codes = new HashSet<String>(anotherSegDict.codes);
    }

    public String getParent() {
        return this.parent;
    }

    public void setParent(String parent) {
        this.parent = parent;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getLoop() {
        return this.loop;
    }

    public void setLoop(String loop) {
        this.loop = loop;
    }

    public String getJsonName() {
        return this.jsonName;
    }

    public void setJsonName(String jsonName) {
        this.jsonName = NameUtils.cleanName(jsonName);
    }

    public boolean isLineLevel() {
        return this.isLineLevel;
    }

    public void setLineLevel(boolean lineLevel) {
        this.isLineLevel = lineLevel;
    }

    public boolean isHeader() {
        return this.isHeader;
    }

    public void setHeader(boolean header) {
        this.isHeader = header;
    }

    public int getRepeat() {
        return this.repeat;
    }

    public void setRepeat(int repeat) {
        this.repeat = repeat;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<ElementWithChildrenDictionary> getElements() {
        return this.elements;
    }

    public void setElements(List<ElementWithChildrenDictionary> elements) {
        this.elements = elements;
    }

    public String hashTag() {
        return this.tag + "_" + this.code + "_" + this.loop;
    }

    @Override
    public int compareTo(SegmentDictionary that) {
        return this.getJsonName().trim().toLowerCase(Locale.ROOT).compareTo(that.getJsonName().trim().toLowerCase(Locale.ROOT));
    }

    @Generated
    public String toString() {
        return "SegmentDictionary(parent=" + this.parent + ", tag=" + this.tag + ", code=" + this.code + ", codes=" + String.valueOf(this.codes) + ", loop=" + this.loop + ", jsonName=" + this.jsonName + ", isLineLevel=" + this.isLineLevel() + ", isHeader=" + this.isHeader() + ", repeat=" + this.repeat + ", required=" + this.required + ", description=" + this.description + ")";
    }
}

