/*
 * Decompiled with CFR 0.152.
 */
package hdi.edi.openedi;

import com.fasterxml.jackson.databind.JsonNode;
import hdi.edi.legacyparser.EdiDataType;
import hdi.edi.legacyparser.ElementWithChildrenDictionary;
import hdi.edi.legacyparser.FieldMeta;
import hdi.edi.openedi.CompositeElementSchema;
import hdi.edi.openedi.EnumSchema;
import hdi.edi.openedi.InputStandardType;
import hdi.edi.openedi.OpenEdiUtils;
import hdi.edi.openedi.SchemaComponent;
import hdi.edi.openedi.TransactionSchema;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElementSchema {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ElementSchema.class);
    public static final String ELEMENT_ID = "x-openedi-element-id";
    private int position = -1;
    private boolean isArray = false;
    private Integer maxLength;
    private Integer minLength;
    private Integer scale;
    private EdiDataType type;
    private String format;
    private String elementId;
    private String name;
    private String schemaName;
    private final Set<String> enumValues = new LinkedHashSet<String>();
    private CompositeElementSchema compositeElement;
    private boolean isRequired = false;

    public int scale() {
        return this.scale == null ? -1 : this.scale;
    }

    ElementSchema(String name, EdiDataType type) {
        this.name = name;
        this.type = type;
        this.elementId = name;
        this.schemaName = name;
    }

    public static ElementSchema fromJsonNode(String name, JsonNode elementNode, TransactionSchema schema) {
        ElementSchema eltSchema = new ElementSchema();
        eltSchema.schemaName = name;
        eltSchema.name = OpenEdiUtils.nodeNameToEdiNameBeforePrefix(name);
        eltSchema.name = OpenEdiUtils.fixUpName(eltSchema.name);
        eltSchema.elementId = elementNode.path(ELEMENT_ID).asText(null);
        if (elementNode.has("$ref")) {
            eltSchema.resolveRef(elementNode, schema);
        }
        if (elementNode.has("items")) {
            JsonNode itemsNode = elementNode.get("items");
            if (itemsNode.has("$ref")) {
                eltSchema.resolveRef(itemsNode, schema);
                if (eltSchema.compositeElement != null) {
                    eltSchema.compositeElement.isArray(true);
                } else {
                    log.warn("We expected a composite element!");
                }
            } else {
                eltSchema.isArray = true;
                eltSchema.type = EdiDataType.STRING;
            }
        } else {
            eltSchema.parseCodeRefs(name, elementNode, schema);
            String format = elementNode.path("format").asText();
            if (eltSchema.type == null) {
                eltSchema.type = EdiDataType.fromOpenEdiFormat(format);
            }
            eltSchema.minLength = elementNode.path("minLength").asInt(-1);
            eltSchema.maxLength = elementNode.path("maxLength").asInt(-1);
            eltSchema.scale = EdiDataType.extractScale(format);
            if (StringUtils.startsWithIgnoreCase((CharSequence)format, (CharSequence)"TELCO") && eltSchema.type == EdiDataType.NUMERIC && eltSchema.scale() == 0 && eltSchema.maxLength >= 10) {
                log.debug("Implicitly setting string data type for {}", (Object)name);
                eltSchema.type = EdiDataType.STRING;
            }
        }
        return eltSchema;
    }

    public static ElementSchema valueElement() {
        ElementSchema eltSchema = new ElementSchema();
        eltSchema.type = EdiDataType.STRING;
        eltSchema.name = "value";
        eltSchema.isRequired = true;
        return eltSchema;
    }

    private void parseCodeRefs(String name, JsonNode elementNode, TransactionSchema schema) {
        JsonNode allOfNode = elementNode.get("allOf");
        if (allOfNode != null) {
            this.type = EdiDataType.ENUM;
            if (allOfNode.isArray()) {
                Iterator refsIter = allOfNode.elements();
                while (refsIter.hasNext()) {
                    JsonNode refNode = (JsonNode)refsIter.next();
                    this.resolveRef(refNode, schema);
                }
            } else {
                this.resolveRef(allOfNode, schema);
            }
            if (this.enumValues.isEmpty()) {
                log.warn("allOf node without refs inside {}", (Object)name);
            }
        }
    }

    private void resolveRef(JsonNode refNode, TransactionSchema schema) {
        String ref = refNode.path("$ref").asText();
        SchemaComponent schemaComp = schema.findSchemaComponentByRef(ref);
        if (schemaComp instanceof EnumSchema) {
            EnumSchema enumSchema = (EnumSchema)schemaComp;
            this.enumValues.addAll(enumSchema.enumValues());
        } else if (schemaComp instanceof CompositeElementSchema) {
            CompositeElementSchema compositeElementSchema = (CompositeElementSchema)schemaComp;
            this.type = EdiDataType.COMPOSITE;
            this.compositeElement = compositeElementSchema;
        }
    }

    public static boolean isElement(JsonNode jsonNode) {
        return jsonNode.has(ELEMENT_ID) || jsonNode.has("$ref") || jsonNode.has("type");
    }

    public ElementWithChildrenDictionary toLegacyElementDictionary() {
        ElementWithChildrenDictionary eltDict = new ElementWithChildrenDictionary();
        eltDict.ediDataType(this.type).jsonName(this.name).setIndex(this.position);
        if (this.scale != null) {
            eltDict.scale(this.scale);
        }
        if (this.maxLength != null) {
            eltDict.length(this.maxLength);
        }
        eltDict.isArray(this.isArray);
        if (this.compositeElement != null) {
            List<ElementWithChildrenDictionary> subEltDicts = this.compositeElement.eltsToLegacyElementDictionaries();
            eltDict.setSubElements(subEltDicts);
        }
        return eltDict;
    }

    public FieldMeta toFieldMeta() {
        return new FieldMeta(InputStandardType.NCPDP, this.name, this.type, this.scale);
    }

    @Generated
    public int position() {
        return this.position;
    }

    @Generated
    public boolean isArray() {
        return this.isArray;
    }

    @Generated
    public Integer maxLength() {
        return this.maxLength;
    }

    @Generated
    public Integer minLength() {
        return this.minLength;
    }

    @Generated
    public EdiDataType type() {
        return this.type;
    }

    @Generated
    public String format() {
        return this.format;
    }

    @Generated
    public String elementId() {
        return this.elementId;
    }

    @Generated
    public String name() {
        return this.name;
    }

    @Generated
    public String schemaName() {
        return this.schemaName;
    }

    @Generated
    public Set<String> enumValues() {
        return this.enumValues;
    }

    @Generated
    public CompositeElementSchema compositeElement() {
        return this.compositeElement;
    }

    @Generated
    public boolean isRequired() {
        return this.isRequired;
    }

    @Generated
    public String toString() {
        return "ElementSchema(position=" + this.position() + ", isArray=" + this.isArray() + ", maxLength=" + this.maxLength() + ", minLength=" + this.minLength() + ", scale=" + this.scale() + ", type=" + String.valueOf(this.type()) + ", format=" + this.format() + ", elementId=" + this.elementId() + ", name=" + this.name() + ", schemaName=" + this.schemaName() + ", compositeElement=" + String.valueOf(this.compositeElement()) + ", isRequired=" + this.isRequired() + ")";
    }

    @Generated
    public ElementSchema() {
    }

    @Generated
    public ElementSchema position(int position) {
        this.position = position;
        return this;
    }

    @Generated
    public ElementSchema isRequired(boolean isRequired) {
        this.isRequired = isRequired;
        return this;
    }
}

