/*
 * Decompiled with CFR 0.152.
 */
package hdi.edi.parser;

import hdi.edi.dict.openapi.OpenApiDataType;
import hdi.edi.parser.DataTypeCategory;
import hdi.edi.qualifier.EdiQualifier;
import hdi.model.enumtype.DateFormatType;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public enum DataType {
    STR(DataTypeCategory.STRING, OpenApiDataType.STRING),
    FLOAT(DataTypeCategory.NUM_DECIMAL, OpenApiDataType.BIG_DEC),
    DOUBLE(DataTypeCategory.NUM_DECIMAL, OpenApiDataType.BIG_DEC),
    DATE(DataTypeCategory.DATE_OR_TIME_OR_PERIOD, OpenApiDataType.DATE),
    DATE_TIME(DataTypeCategory.DATE_OR_TIME_OR_PERIOD, OpenApiDataType.DATE_TIME),
    TIME(DataTypeCategory.DATE_OR_TIME_OR_PERIOD, OpenApiDataType.TIME),
    BIG_DEC(DataTypeCategory.NUM_DECIMAL, OpenApiDataType.BIG_DEC),
    OBJ(DataTypeCategory.OTHER, OpenApiDataType.OBJECT),
    INT(DataTypeCategory.OTHER, OpenApiDataType.INT),
    DATE_INTERVAL(DataTypeCategory.DATE_OR_TIME_OR_PERIOD, null),
    ELT_SET(DataTypeCategory.COMPLEX, null),
    LIST(DataTypeCategory.COMPLEX, OpenApiDataType.ARRAY),
    QUALIFIER(DataTypeCategory.OTHER, null),
    CODE_ENTITY(DataTypeCategory.OTHER, null),
    CODE_ENTITY_LIST(DataTypeCategory.OTHER, null);

    private final DataTypeCategory category;
    private final OpenApiDataType openApiDataType;

    boolean isNumeric() {
        return this == FLOAT || this == DOUBLE || this == BIG_DEC || this == INT;
    }

    public EdiQualifier formatQualifier() {
        return switch (this.ordinal()) {
            case 3 -> DateFormatType.DATE;
            case 4 -> DateFormatType.DATE_TIME;
            case 5 -> DateFormatType.TIME;
            case 9 -> DateFormatType.DATE_PERIOD;
            default -> null;
        };
    }

    public static DataType fromString(String s) {
        for (DataType nm : DataType.values()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)nm.name(), (CharSequence)s)) continue;
            return nm;
        }
        return null;
    }

    public static DataType fromClass(Class<?> clazz) {
        if (clazz == String.class) {
            return STR;
        }
        if (clazz == Float.class || clazz == Double.class || clazz == BigDecimal.class) {
            return BIG_DEC;
        }
        if (clazz == Integer.class) {
            return INT;
        }
        if (clazz == LocalDate.class) {
            return DATE;
        }
        if (clazz == LocalDateTime.class || clazz == ZonedDateTime.class) {
            return DATE_TIME;
        }
        if (clazz == LocalTime.class) {
            return TIME;
        }
        if (clazz == List.class || clazz == Set.class) {
            return LIST;
        }
        if (clazz.isEnum()) {
            return STR;
        }
        return OBJ;
    }

    @Generated
    private DataType(DataTypeCategory category, OpenApiDataType openApiDataType) {
        this.category = category;
        this.openApiDataType = openApiDataType;
    }

    @Generated
    public DataTypeCategory category() {
        return this.category;
    }

    @Generated
    public OpenApiDataType openApiDataType() {
        return this.openApiDataType;
    }
}

