/*
 * Decompiled with CFR 0.152.
 */
package hdi.edi.parser;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import lombok.Generated;

public final class EdiDateUtils {
    public static DateTimeFormatter EDI_DATE_TIME_FORMAT = DateTimeFormatter.ofPattern("yyyyMMddHHmm");
    public static DateTimeFormatter EDI_DATE_FORMAT = DateTimeFormatter.ofPattern("yyyyMMdd");
    public static DateTimeFormatter EDI_ISA_DATE_FORMAT = DateTimeFormatter.ofPattern("yyMMdd");
    public static DateTimeFormatter EDI_TIME_FORMAT = DateTimeFormatter.ofPattern("HHmm");

    public static LocalDate localDateFromStr(String dtStr) {
        return LocalDate.parse(dtStr, DateTimeFormatter.BASIC_ISO_DATE);
    }

    public static LocalTime localTimeFromStr(String dtStr) {
        return LocalTime.parse(dtStr, EDI_TIME_FORMAT);
    }

    public static LocalDateTime localDateTimeFromStr(String dtStr) {
        LocalDateTime dt;
        try {
            dt = LocalDateTime.parse(dtStr, EDI_DATE_TIME_FORMAT);
        }
        catch (DateTimeParseException parseException) {
            LocalDate d = EdiDateUtils.localDateFromStr(dtStr);
            dt = d.atStartOfDay();
        }
        return dt;
    }

    public static String localDateTimeToStr(LocalDateTime dt) {
        return dt.format(EDI_DATE_TIME_FORMAT);
    }

    public static String localDateToStr(LocalDate dt) {
        return dt.format(EDI_DATE_FORMAT);
    }

    public static String localTimeToStr(LocalTime dt) {
        return dt.format(EDI_TIME_FORMAT);
    }

    @Generated
    private EdiDateUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

