/*
 * Decompiled with CFR 0.152.
 */
package hdi.edi.parser;

import hdi.edi.codecollector.CodeEntityCollector;
import hdi.edi.codecollector.CodeEntityHolder;
import hdi.edi.codecollector.CodeEntityResolver;
import hdi.edi.fileinfo.FileInfo;
import hdi.edi.legacyparser.EdiSegment;
import hdi.edi.legacyparser.LegacyEdiParser;
import hdi.edi.parser.EdiParsingResults;
import hdi.edi.parser.EdiSeg;
import hdi.edi.parser.EdiTransactionSeg;
import hdi.edi.parser.SegmentType;
import hdi.license.CliLicenseReader;
import hdi.model.ClaimOrPayment;
import hdi.model.claim.Claim;
import hdi.model.payment.Payment;
import java.io.Closeable;
import java.io.File;
import java.io.Reader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EdiParser
implements Closeable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EdiParser.class);
    public static final String MAX_NUMBER_OF_ISSUES_ENV_NAME = "EDI_PARSER_MAX_WARNINGS";
    public static final int DEFAULT_MAX_NUMBER_OF_ISSUES = 100;
    private CodeEntityResolver codeResolver;
    private final FileInfo fileInfo;
    private LegacyEdiParser legacyParser;
    private final CodeEntityCollector codeEntityCollector = new CodeEntityCollector();
    private boolean buildLoopHierarchy = true;
    private boolean isFragmentMode = false;
    private boolean isSuppressIssueLogging = false;
    private boolean isStrictMode = false;
    private boolean isSplitMode = true;
    private int maxNumberOfIssues;
    private final CliLicenseReader licenseReader = new CliLicenseReader();
    private EdiParsingResults curParsingResultsForBatch;
    private static final Set<String> SEGMENT_KEYS_TO_PRESERVE = Set.of("LX__2000");

    public EdiParser(File ediFile) {
        this(new FileInfo(ediFile));
    }

    public EdiParser(Reader reader) {
        this(new FileInfo(null, reader));
    }

    public EdiParser(FileInfo fileInfo) {
        this.fileInfo = fileInfo;
        this.maxNumberOfIssues = this.getMaxNumberOfIssues();
    }

    private int getMaxNumberOfIssues() {
        String maxNumberOfIssuesStr = System.getenv(MAX_NUMBER_OF_ISSUES_ENV_NAME);
        if (maxNumberOfIssuesStr != null) {
            try {
                return Integer.parseInt(maxNumberOfIssuesStr);
            }
            catch (NumberFormatException e) {
                log.warn("Invalid value for environment variable {}: {}", (Object)MAX_NUMBER_OF_ISSUES_ENV_NAME, (Object)maxNumberOfIssuesStr);
            }
        }
        return 100;
    }

    public List<Claim> parse837(int batchSize) {
        this.isSplitMode = true;
        EdiParsingResults results = this.parse(batchSize);
        return results.claims();
    }

    public List<Payment> parse835(int batchSize) {
        this.isSplitMode = true;
        EdiParsingResults results = this.parse(batchSize);
        return results.payments();
    }

    public EdiParsingResults parse() {
        return this.parse(-1);
    }

    public EdiParsingResults parse(int batchSize) {
        return this.parse(batchSize, true);
    }

    public List<EdiSeg> parseAllSegs() {
        return this.parse(-1).segs();
    }

    public EdiParsingResults parseAll() {
        return this.parse(-1, false);
    }

    private EdiParsingResults parse(int batchSize, boolean isTransactionsOnly) {
        log.debug("Parsing settings: Split mode: {}", (Object)this.isSplitMode);
        this.initLegacyParser();
        if (this.isSplitMode) {
            return this.parseBatchBasedOnSplitSeg(batchSize);
        }
        return this.parseBatchOfTransactions(batchSize, isTransactionsOnly);
    }

    @NotNull
    private EdiParsingResults parseBatchOfTransactions(int batchSize, boolean isTransactionsOnly) {
        EdiParsingResults ediParsingResults = new EdiParsingResults(this.fileInfo);
        ArrayList<EdiSeg> segs = new ArrayList<EdiSeg>();
        List<Object> segsFromBatch = new ArrayList();
        this.legacyParser.isSplitMode(false);
        int segCount = 0;
        if (!isTransactionsOnly) {
            this.legacyParser.stopSegTypes(List.of());
        }
        while (!(segCount >= batchSize && batchSize >= 0 || (segsFromBatch = this.parseNextTranOrAllSegments(this.legacyParser, ediParsingResults, isTransactionsOnly)).isEmpty())) {
            segs.addAll(segsFromBatch);
            ++segCount;
        }
        if (segsFromBatch.isEmpty()) {
            this.legacyParser.close();
            ediParsingResults.isDone(true);
        }
        ediParsingResults.ediSeparators(this.legacyParser.ediSeparators());
        log.debug("Parsed {} root segment(s)", (Object)segCount);
        ediParsingResults.segs(segs);
        if (this.codeResolver != null) {
            this.codeResolver.resolve(ediParsingResults.codeEntityHolder());
        }
        this.prepDerived(ediParsingResults);
        return ediParsingResults;
    }

    private List<EdiSeg> parseNextTranOrAllSegments(LegacyEdiParser legacyParser, EdiParsingResults ediParsingResults, boolean isTransactionsOnly) {
        ArrayList<EdiSeg> segs = new ArrayList<EdiSeg>();
        List<EdiSegment> legacyEdiSegs = legacyParser.parseSegments();
        this.copyParsingIssues(legacyParser, ediParsingResults);
        ediParsingResults.parsedSegIndex(0);
        for (EdiSegment legacySeg : legacyEdiSegs) {
            EdiSeg seg;
            if (legacySeg.type() == SegmentType.ST) {
                boolean buildLoops = this.buildLoopHierarchy && legacyParser.transactionSchema() == null;
                seg = new EdiTransactionSeg(legacySeg, buildLoops, ediParsingResults).transactionType(legacyParser.currentTransactionType());
                segs.add(seg);
                continue;
            }
            if (isTransactionsOnly) continue;
            seg = new EdiSeg(legacySeg, this.buildLoopHierarchy, ediParsingResults);
            segs.add(seg);
        }
        CodeEntityHolder codeEntHolder = this.codeEntityCollector.processEdi(segs);
        ediParsingResults.addCodeEntities(codeEntHolder.codes());
        return segs;
    }

    private EdiParsingResults parseBatchBasedOnSplitSeg(int batchSize) {
        this.legacyParser.isSplitMode(true);
        if (this.curParsingResultsForBatch == null) {
            this.curParsingResultsForBatch = new EdiParsingResults(this.fileInfo);
        } else {
            this.curParsingResultsForBatch.clearEntsSplitTranBatch();
        }
        EdiParsingResults ediParsingResults = this.curParsingResultsForBatch;
        if (ediParsingResults.isDone()) {
            return ediParsingResults;
        }
        int splitEntOrTranCount = 0;
        while (splitEntOrTranCount < batchSize || batchSize < 0) {
            int curTranCount = ediParsingResults.ediTransactions().size();
            int curSplitEntCount = ediParsingResults.rootEntityCount();
            this.parseBySplitSeg(ediParsingResults);
            int foundSplitEntCount = ediParsingResults.rootEntityCount() - curSplitEntCount;
            splitEntOrTranCount += foundSplitEntCount;
            if (this.legacyParser.stopSegType() != null && this.legacyParser.stopSegType() == SegmentType.SE && foundSplitEntCount == 0 && ediParsingResults.ediTransactions().size() > curTranCount) {
                ++splitEntOrTranCount;
            }
            if (!ediParsingResults.isDone()) continue;
            break;
        }
        if (this.codeResolver != null) {
            this.codeResolver.resolve(ediParsingResults.codeEntityHolder());
        }
        log.debug("Parsed {} root entities in split mode", (Object)splitEntOrTranCount);
        return ediParsingResults;
    }

    private void parseBySplitSeg(EdiParsingResults ediParsingResults) {
        ediParsingResults.clearEntsForSplitTranChunk();
        EdiSegment oldRootSeg = this.legacyParser.getCurrentRootParent();
        if (oldRootSeg != null) {
            this.clearTransactionChildSegsForSplit(oldRootSeg);
        }
        List<EdiSegment> segs = this.legacyParser.parseSegments();
        for (EdiSegment seg : segs) {
            if (!seg.isControlSegment()) continue;
            ediParsingResults.segs().add(new EdiSeg(seg, false, ediParsingResults));
        }
        this.copyParsingIssues(this.legacyParser, ediParsingResults);
        EdiSegment rootSeg = this.legacyParser.getCurrentRootParent();
        if (rootSeg != null) {
            ediParsingResults.isPreserveTransaction(oldRootSeg == rootSeg);
            boolean buildLoops = this.buildLoopHierarchy && this.legacyParser.transactionSchema() == null;
            EdiTransactionSeg seg = new EdiTransactionSeg(rootSeg, buildLoops, ediParsingResults).transactionType(this.legacyParser.currentTransactionType());
            if (oldRootSeg != rootSeg || !seg.childSegs().isEmpty()) {
                ediParsingResults.segs().add(seg);
            }
            ediParsingResults.ediSeparators(this.legacyParser.ediSeparators());
            this.prepDerived(ediParsingResults);
            CodeEntityHolder codeEntHolder = this.codeEntityCollector.processEdi(List.of(seg));
            ediParsingResults.addCodeEntities(codeEntHolder.codes());
        } else {
            this.legacyParser.close();
            ediParsingResults.isDone(true);
        }
    }

    private void clearTransactionChildSegsForSplit(EdiSegment transactionSegment) {
        List<EdiSegment> childSegs = transactionSegment.segments();
        LinkedHashMap<String, EdiSegment> childSegMap = new LinkedHashMap<String, EdiSegment>();
        for (EdiSegment childSeg : childSegs) {
            if (!SEGMENT_KEYS_TO_PRESERVE.contains(childSeg.hashTag())) continue;
            childSeg.segments(new ArrayList<EdiSegment>());
            childSegMap.put(childSeg.hashTag(), childSeg);
        }
        transactionSegment.segments(new ArrayList<EdiSegment>(childSegMap.values()));
    }

    private void prepDerived(EdiParsingResults parsingResults) {
        parsingResults.payments().forEach(ClaimOrPayment::prepDerived);
        parsingResults.claims().forEach(ClaimOrPayment::prepDerived);
    }

    private void copyParsingIssues(LegacyEdiParser legacyParser, EdiParsingResults parsingResults) {
        parsingResults.addParsingIssues(legacyParser.parsingIssues());
        legacyParser.parsingIssues().clear();
    }

    private void initLegacyParser() {
        if (this.legacyParser == null) {
            this.legacyParser = new LegacyEdiParser(this.fileInfo, this.isStrictMode, this.isFragmentMode, this.isSuppressIssueLogging).maxNumberOfIssues(this.maxNumberOfIssues);
        }
    }

    @Override
    public void close() {
        if (this.legacyParser != null) {
            this.legacyParser.close();
        }
    }

    @Generated
    public EdiParser codeResolver(CodeEntityResolver codeResolver) {
        this.codeResolver = codeResolver;
        return this;
    }

    @Generated
    public FileInfo fileInfo() {
        return this.fileInfo;
    }

    @Generated
    public EdiParser buildLoopHierarchy(boolean buildLoopHierarchy) {
        this.buildLoopHierarchy = buildLoopHierarchy;
        return this;
    }

    @Generated
    public EdiParser isFragmentMode(boolean isFragmentMode) {
        this.isFragmentMode = isFragmentMode;
        return this;
    }

    @Generated
    public EdiParser isSuppressIssueLogging(boolean isSuppressIssueLogging) {
        this.isSuppressIssueLogging = isSuppressIssueLogging;
        return this;
    }

    @Generated
    public EdiParser isStrictMode(boolean isStrictMode) {
        this.isStrictMode = isStrictMode;
        return this;
    }

    @Generated
    public EdiParser isSplitMode(boolean isSplitMode) {
        this.isSplitMode = isSplitMode;
        return this;
    }

    @Generated
    public EdiParser maxNumberOfIssues(int maxNumberOfIssues) {
        this.maxNumberOfIssues = maxNumberOfIssues;
        return this;
    }
}

