/*
 * Decompiled with CFR 0.152.
 */
package hdi.edi.parser;

import hdi.GeneralException;
import hdi.edi.parser.ParsingIssue;
import hdi.edi.parserhelper.ParsedLine;
import hdi.edi.parserhelper.ParsingError;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class EdiParserException
extends GeneralException {
    private List<ParsedLine> invalidLines;
    private List<ParsingIssue> issues;

    public EdiParserException(String msg, Object ... args) {
        super(msg, args);
    }

    public EdiParserException(Throwable e) {
        super(e);
    }

    public EdiParserException(String msg, Throwable e, Object ... args) {
        super(msg, e, args);
    }

    public EdiParserException(ParsingIssue issue) {
        super(issue.toFormattedString(), new Object[0]);
        if (this.issues == null) {
            this.issues = new ArrayList<ParsingIssue>();
        }
        this.issues.add(issue);
    }

    public ParsingIssue getLastIssue() {
        if (this.issues == null || this.issues.isEmpty()) {
            return null;
        }
        return this.issues.get(this.issues.size() - 1);
    }

    public boolean hasIssues() {
        return this.issues != null && !this.issues.isEmpty();
    }

    public void addInvalidLine(String line) {
        if (this.invalidLines == null) {
            this.invalidLines = new ArrayList<ParsedLine>();
        }
        ParsedLine parsedLine = new ParsedLine(StringUtils.left((String)line, (int)1000), -1);
        parsedLine.addError(new ParsingError(this.getMessage()));
        this.invalidLines.add(parsedLine);
    }

    @Generated
    public EdiParserException invalidLines(List<ParsedLine> invalidLines) {
        this.invalidLines = invalidLines;
        return this;
    }

    @Generated
    public EdiParserException issues(List<ParsingIssue> issues) {
        this.issues = issues;
        return this;
    }

    @Generated
    public List<ParsedLine> invalidLines() {
        return this.invalidLines;
    }

    @Generated
    public List<ParsingIssue> issues() {
        return this.issues;
    }
}

