/*
 * Decompiled with CFR 0.152.
 */
package hdi.edi.parser;

import hdi.codeent.CodeEntity;
import hdi.edi.EdiTransaction;
import hdi.edi.OwnerIdHolder;
import hdi.edi.codecollector.CodeEntityHolder;
import hdi.edi.edient.EdiEntity;
import hdi.edi.fileinfo.FileInfo;
import hdi.edi.parser.EdiSeg;
import hdi.edi.parser.EdiSeparators;
import hdi.edi.parser.ParsingIssue;
import hdi.edi.parser.SegmentType;
import hdi.edi.parser.TransactionType;
import hdi.edi.parserhelper.SegMatcher;
import hdi.edi.parserhelper.SegMatchingCriteria;
import hdi.edi.parserhelper.SegTreeHelper;
import hdi.edi.qualifier.EdiQualifier;
import hdi.model.RootObj;
import hdi.model.ServiceLine;
import hdi.model.claim.Claim;
import hdi.model.claim.ClaimTransaction;
import hdi.model.coverage.MemberCoverage;
import hdi.model.coverage.TpaWithAccountInfo;
import hdi.model.orgperson.EntityRole;
import hdi.model.orgperson.OrgOrPerson;
import hdi.model.patientsubscriber.PatientSubscriber;
import hdi.model.payment.Payment;
import hdi.model.payment.ProviderAdjustment;
import hdi.model.status.BaseProviderReceiverStatus;
import hdi.model.status.ClaimStatus;
import hdi.model.status.ReceiverProviderClaimStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;

public class EdiParsingResults {
    private SegMatcher segMatcher = new SegMatcher();
    private SegTreeHelper segTreeHelper = new SegTreeHelper();
    private boolean isDone;
    private final FileInfo fileInfo;
    private List<EdiSeg> segs = new ArrayList<EdiSeg>();
    private List<EdiSeg> flatSegList;
    private EdiSeparators ediSeparators;
    private final List<RootObj> rootObjs = new ArrayList<RootObj>();
    private final List<EdiTransaction> ediTransactions = new ArrayList<EdiTransaction>();
    private final List<Claim> claims = new ArrayList<Claim>();
    private final List<ClaimTransaction> claimTransactions = new ArrayList<ClaimTransaction>();
    private final List<Payment> payments = new ArrayList<Payment>();
    private final List<ProviderAdjustment> providerAdjustments = new ArrayList<ProviderAdjustment>();
    private final List<MemberCoverage> memberCoverages = new ArrayList<MemberCoverage>();
    private final List<ReceiverProviderClaimStatus> statuses = new ArrayList<ReceiverProviderClaimStatus>();
    private final List<ParsingIssue> parsingIssues = new ArrayList<ParsingIssue>();
    private CodeEntityHolder codeEntityHolder = new CodeEntityHolder();
    private Claim curClaim;
    private EdiTransaction curTransaction;
    private String curTransactionId;
    private int parsedSegIndex;
    private boolean isPreserveTransaction = false;
    private List<EdiEntity> curTranEntities = new ArrayList<EdiEntity>();
    private static final int MAX_NUMBER_OF_ISSUES_WITHIN_BATCH = 5000;

    public EdiParsingResults(EdiParsingResults results) {
        this.parsingIssues.addAll(results.parsingIssues);
        this.fileInfo = results.fileInfo;
        this.segMatcher = results.segMatcher;
        this.segs.addAll(results.segs);
        this.ediSeparators = results.ediSeparators;
        this.rootObjs.addAll(results.rootObjs);
        this.claims.addAll(results.claims);
        this.payments.addAll(results.payments);
        this.providerAdjustments.addAll(results.providerAdjustments);
        this.memberCoverages.addAll(results.memberCoverages);
        this.statuses.addAll(results.statuses);
        this.ediTransactions.addAll(results.ediTransactions);
        this.claimTransactions.addAll(results.claimTransactions);
        this.codeEntityHolder = results.codeEntityHolder;
        this.flatSegList = results.flatSegList;
        this.curClaim = results.curClaim;
        this.curTransaction = results.curTransaction;
        this.parsedSegIndex = results.parsedSegIndex;
        this.isPreserveTransaction = results.isPreserveTransaction;
        this.curTranEntities = results.curTranEntities;
        this.isDone = results.isDone;
        this.segTreeHelper = results.segTreeHelper;
        this.curTransactionId = results.curTransactionId;
    }

    public int rootEntityCount() {
        return this.claimTransactions.size() + this.payments.size() + this.memberCoverages.size() + this.providerAdjustments.size();
    }

    public int getCurrentIndexAndIncrement() {
        int indToReturn = this.parsedSegIndex++;
        return indToReturn;
    }

    public void add(EdiEntity entity) {
        if (entity instanceof EdiTransaction) {
            EdiTransaction ediTransaction = (EdiTransaction)entity;
            this.curTransactionId = ediTransaction.id();
            if (!this.isPreserveTransaction) {
                this.curTranEntities.clear();
                this.curClaim = null;
                this.curTransaction = ediTransaction;
                this.ediTransactions.add(ediTransaction);
            }
        } else if (entity instanceof Claim) {
            Claim claim;
            this.curClaim = claim = (Claim)entity;
            claim.transactionId(this.curTransactionId);
            this.removeLastEntOfClass(Claim.class);
            this.removeLastEntOfClass(ServiceLine.class);
        } else if (entity instanceof ServiceLine) {
            this.removeLastEntOfClass(ServiceLine.class);
        } else if (entity instanceof Payment) {
            Payment payment = (Payment)entity;
            payment.transactionId(this.curTransactionId);
            this.removeLastEntOfClass(Payment.class);
            this.removeLastEntOfClass(ServiceLine.class);
            this.rootObjs.add(payment);
            this.payments.add(payment);
        } else if (entity instanceof ProviderAdjustment) {
            ProviderAdjustment providerAdjustment = (ProviderAdjustment)entity;
            this.providerAdjustments.add(providerAdjustment);
            this.rootObjs.add(providerAdjustment);
        } else if (entity instanceof MemberCoverage) {
            this.removeLastEntOfClass(MemberCoverage.class);
        } else if (entity instanceof ClaimStatus) {
            ClaimStatus claimStatus = (ClaimStatus)entity;
            this.removeLastEntOfClass(ClaimStatus.class);
            this.statuses.add(claimStatus);
        } else if (entity instanceof BaseProviderReceiverStatus) {
            BaseProviderReceiverStatus providerReceiverStatus = (BaseProviderReceiverStatus)entity;
            this.statuses.add(providerReceiverStatus);
        } else if (entity instanceof PatientSubscriber && StringUtils.startsWithAny((CharSequence)entity.loop(), (CharSequence[])new CharSequence[]{"2000B"})) {
            this.removeAllEntsOfClass(PatientSubscriber.class);
        } else if (entity instanceof OrgOrPerson && StringUtils.startsWithAny((CharSequence)entity.loop(), (CharSequence[])new CharSequence[]{"2010AA"})) {
            this.curTranEntities.clear();
            this.curClaim = null;
        }
        this.curTranEntities.add(entity);
    }

    private void removeLastEntOfClass(Class<?> clazz) {
        EdiEntity lastEnt = this.getLastEntOfClass(clazz);
        if (lastEnt != null) {
            this.curTranEntities.remove(lastEnt);
        }
    }

    public void clearEntsSplitTranBatch() {
        this.claimTransactions.clear();
        this.claims.clear();
        this.payments.clear();
        this.providerAdjustments.clear();
        this.rootObjs.clear();
        this.memberCoverages.clear();
        this.curClaim = null;
        this.ediTransactions.clear();
        this.segs.clear();
        this.flatSegList = null;
        this.codeEntityHolder = new CodeEntityHolder();
        this.parsingIssues.clear();
        this.statuses.clear();
        this.clearEntsForSplitTranChunk();
    }

    public void clearEntsForSplitTranChunk() {
        this.curTranEntities = new ArrayList<EdiEntity>(this.getEntsToPreserve());
    }

    private Collection<EdiEntity> getEntsToPreserve() {
        if (this.curTransaction == null) {
            return Collections.emptyList();
        }
        TransactionType transactionType = this.curTransaction.transactionType();
        if (!transactionType.isClaim() && transactionType != TransactionType.MEMBER_COVERAGE) {
            return Collections.emptyList();
        }
        HashMap<EntityRole, EdiEntity> entByRole = new HashMap<EntityRole, EdiEntity>();
        ArrayList<EdiEntity> entsToPreserve = new ArrayList<EdiEntity>();
        for (EdiEntity ent : this.curTranEntities) {
            OrgOrPerson orgOrPerson;
            if (transactionType.isClaim()) {
                EntityRole subEntRole;
                if (ent instanceof PatientSubscriber && Strings.CI.startsWith((CharSequence)ent.loop(), (CharSequence)"2000B")) {
                    subEntRole = EntityRole.INSURED_SUBSCRIBER;
                    entByRole.put(subEntRole, ent);
                    continue;
                }
                if (ent instanceof PatientSubscriber && Strings.CI.startsWith((CharSequence)ent.loop(), (CharSequence)"2000C")) {
                    subEntRole = EntityRole.PATIENT;
                    entByRole.put(subEntRole, ent);
                    continue;
                }
                if (!(ent instanceof OrgOrPerson)) continue;
                orgOrPerson = (OrgOrPerson)ent;
                if (!Strings.CI.startsWithAny((CharSequence)ent.loop(), new CharSequence[]{"2010AA", "2010AB", "2010AC"})) continue;
                entByRole.put(orgOrPerson.entityRole(), ent);
                continue;
            }
            if (transactionType != TransactionType.MEMBER_COVERAGE) continue;
            if (ent instanceof OrgOrPerson) {
                orgOrPerson = (OrgOrPerson)ent;
                if (Strings.CI.startsWithAny((CharSequence)ent.loop(), new CharSequence[]{"1000A", "1000B", "1000C"}) && orgOrPerson.entityRole() != null && orgOrPerson.entityRole().oneOf(EntityRole.INSURER, EntityRole.PLAN_SPONSOR)) {
                    entByRole.put(orgOrPerson.entityRole(), ent);
                    continue;
                }
            }
            if (!(ent instanceof TpaWithAccountInfo)) continue;
            TpaWithAccountInfo tpa = (TpaWithAccountInfo)ent;
            entsToPreserve.add(tpa);
        }
        entsToPreserve.addAll(entByRole.values());
        return entsToPreserve;
    }

    private EdiEntity getLastEntOfClass(Class<?> clazz) {
        EdiEntity curEnt = null;
        for (EdiEntity ent : this.curTranEntities) {
            if (ent.getClass() != clazz) continue;
            curEnt = ent;
        }
        return curEnt;
    }

    public OrgOrPerson findPartyByRole(EntityRole role) {
        OrgOrPerson curEnt = null;
        for (EdiEntity ent : this.curTranEntities) {
            OrgOrPerson orgOrPerson;
            if (!(ent instanceof OrgOrPerson) || role != (orgOrPerson = (OrgOrPerson)ent).entityRole()) continue;
            curEnt = orgOrPerson;
        }
        return curEnt;
    }

    public List<OrgOrPerson> findPartiesByRoles(EntityRole ... roles) {
        ArrayList<OrgOrPerson> parties = new ArrayList<OrgOrPerson>();
        for (EdiEntity ent : this.curTranEntities) {
            OrgOrPerson party;
            if (!(ent instanceof OrgOrPerson) || (party = (OrgOrPerson)ent).entityRole() == null || !party.entityRole().oneOf(roles)) continue;
            parties.add(party);
        }
        return parties;
    }

    private void removeAllEntsOfClass(Class<?> clazz) {
        ArrayList<EdiEntity> newEnts = new ArrayList<EdiEntity>();
        for (EdiEntity ent : this.curTranEntities) {
            if (ent.getClass() != clazz) continue;
            newEnts.add(ent);
        }
        this.curTranEntities.removeAll(newEnts);
    }

    public List<OrgOrPerson> providers() {
        List<OrgOrPerson> names = EdiParsingResults.findEntitiesForClass(this, OrgOrPerson.class);
        return names.stream().filter(n -> n.entityRole().isProvider()).collect(Collectors.toList());
    }

    public static <T> List<T> findEntitiesForClass(EdiParsingResults results, Class<T> clazz) {
        ArrayList<EdiEntity> foundEnts = new ArrayList<EdiEntity>();
        for (EdiEntity ent : results.curTranEntities) {
            if (!clazz.isInstance(ent)) continue;
            foundEnts.add(ent);
        }
        return foundEnts;
    }

    public static <T> List<T> findTranEntitiesForClass(EdiParsingResults results, Class<T> clazz) {
        ArrayList<EdiEntity> foundEnts = new ArrayList<EdiEntity>();
        for (EdiEntity ent : results.curTranEntities) {
            if (!clazz.isInstance(ent)) continue;
            foundEnts.add(ent);
        }
        return foundEnts;
    }

    public OwnerIdHolder createOwner() {
        OwnerIdHolder owner = new OwnerIdHolder().fileInfoId(this.fileInfo.id()).fileUrl(this.fileInfo.url());
        if (this.curTransaction != null) {
            owner.transactionId(this.curTransactionId);
            owner.transactionCreationDateTime(this.curTransaction.getCreationDateTime());
        }
        return owner;
    }

    public List<EdiSeg> flatSegList() {
        if (this.flatSegList == null) {
            this.flatSegList = this.segTreeHelper.toFlatList(this.segs);
        }
        return this.flatSegList;
    }

    public int segCount() {
        return this.flatSegList().size();
    }

    public int unknownSegCount() {
        return this.unknownSegTypes().size();
    }

    public Collection<String> unknownSegTypes() {
        LinkedHashSet<String> unknownSegs = new LinkedHashSet<String>();
        for (EdiSeg seg : this.flatSegList()) {
            if (!seg.isUnknown()) continue;
            unknownSegs.add(seg.typeAsString());
        }
        return unknownSegs;
    }

    void mapEntities(EdiSeg seg) {
        for (EdiEntity ent : this.curTranEntities) {
            ent.populateFromSeg(seg, this);
        }
    }

    public void addCodeEntities(List<CodeEntity> codeEntities) {
        for (CodeEntity codeEntity : codeEntities) {
            this.addCodeEntity(codeEntity);
            for (EdiEntity ent : this.curTranEntities) {
                ent.addCodeEntityForTransaction(codeEntity);
            }
        }
    }

    public void addCodeEntity(CodeEntity codeEntity) {
        if (codeEntity != null) {
            this.codeEntityHolder.add(codeEntity);
        }
    }

    public EdiSeg findFirstSegByType(SegmentType ... types) {
        return this.segMatcher.findFirstByType(this.segs, types);
    }

    public List<EdiSeg> findSegsByType(SegmentType ... types) {
        return this.segMatcher.findByType(this.segs, types);
    }

    public List<EdiSeg> findSegsByLoopAndType(String loopNumber, SegmentType ... types) {
        SegMatchingCriteria filterMeta = new SegMatchingCriteria().inclLoopNumbers(loopNumber).inclSegTypes(types);
        return this.segMatcher.match(this.segs, filterMeta);
    }

    public EdiSeg findFirstSegByName(String ... names) {
        return this.segMatcher.findFirstByName(this.segs, names);
    }

    public EdiSeg findFirstSegByTypeAndQualifier(SegmentType type, EdiQualifier qualifier) {
        SegMatchingCriteria filterConfig = new SegMatchingCriteria().inclSegTypes(type).ediQualifier(qualifier);
        return this.segMatcher.findFirst(this.segs, filterConfig);
    }

    public EdiSeg getRequiredLastSeg() {
        if (this.segs.isEmpty()) {
            throw new IllegalStateException("Segs list is empty");
        }
        return this.segs.get(this.segs.size() - 1);
    }

    public String segsToString() {
        return EdiSeg.toFormattedStringWithChildren(this.segs);
    }

    public void addParsingIssues(List<ParsingIssue> issues) {
        for (ParsingIssue issue : issues) {
            if (this.parsingIssues.size() > 5000) break;
            this.parsingIssues.add(issue);
        }
    }

    public List<ClaimStatus> claimStatuses() {
        return this.statuses.stream().filter(status -> status instanceof ClaimStatus).map(status -> (ClaimStatus)status).collect(Collectors.toList());
    }

    public void addParsingIssue(ParsingIssue issue) {
        if (this.parsingIssues.size() <= 5000) {
            this.parsingIssues.add(issue);
        }
    }

    @Generated
    public boolean isDone() {
        return this.isDone;
    }

    @Generated
    public FileInfo fileInfo() {
        return this.fileInfo;
    }

    @Generated
    public List<EdiSeg> segs() {
        return this.segs;
    }

    @Generated
    public List<RootObj> rootObjs() {
        return this.rootObjs;
    }

    @Generated
    public List<EdiTransaction> ediTransactions() {
        return this.ediTransactions;
    }

    @Generated
    public List<Claim> claims() {
        return this.claims;
    }

    @Generated
    public List<ClaimTransaction> claimTransactions() {
        return this.claimTransactions;
    }

    @Generated
    public List<Payment> payments() {
        return this.payments;
    }

    @Generated
    public List<ProviderAdjustment> providerAdjustments() {
        return this.providerAdjustments;
    }

    @Generated
    public List<MemberCoverage> memberCoverages() {
        return this.memberCoverages;
    }

    @Generated
    public List<ReceiverProviderClaimStatus> statuses() {
        return this.statuses;
    }

    @Generated
    public List<ParsingIssue> parsingIssues() {
        return this.parsingIssues;
    }

    @Generated
    public CodeEntityHolder codeEntityHolder() {
        return this.codeEntityHolder;
    }

    @Generated
    public EdiTransaction curTransaction() {
        return this.curTransaction;
    }

    @Generated
    public String curTransactionId() {
        return this.curTransactionId;
    }

    @Generated
    public List<EdiEntity> curTranEntities() {
        return this.curTranEntities;
    }

    @Generated
    public EdiParsingResults(FileInfo fileInfo) {
        this.fileInfo = fileInfo;
    }

    @Generated
    EdiParsingResults isDone(boolean isDone) {
        this.isDone = isDone;
        return this;
    }

    @Generated
    EdiParsingResults segs(List<EdiSeg> segs) {
        this.segs = segs;
        return this;
    }

    @Generated
    EdiParsingResults ediSeparators(EdiSeparators ediSeparators) {
        this.ediSeparators = ediSeparators;
        return this;
    }

    @Generated
    EdiSeparators ediSeparators() {
        return this.ediSeparators;
    }

    @Generated
    EdiParsingResults curClaim(Claim curClaim) {
        this.curClaim = curClaim;
        return this;
    }

    @Generated
    Claim curClaim() {
        return this.curClaim;
    }

    @Generated
    EdiParsingResults curTransaction(EdiTransaction curTransaction) {
        this.curTransaction = curTransaction;
        return this;
    }

    @Generated
    EdiParsingResults curTransactionId(String curTransactionId) {
        this.curTransactionId = curTransactionId;
        return this;
    }

    @Generated
    EdiParsingResults parsedSegIndex(int parsedSegIndex) {
        this.parsedSegIndex = parsedSegIndex;
        return this;
    }

    @Generated
    int parsedSegIndex() {
        return this.parsedSegIndex;
    }

    @Generated
    EdiParsingResults isPreserveTransaction(boolean isPreserveTransaction) {
        this.isPreserveTransaction = isPreserveTransaction;
        return this;
    }

    @Generated
    boolean isPreserveTransaction() {
        return this.isPreserveTransaction;
    }
}

