/*
 * Decompiled with CFR 0.152.
 */
package hdi.edi.parser;

import com.fasterxml.jackson.annotation.JsonIgnore;
import hdi.codeent.CodeEntity;
import hdi.edi.legacyparser.EdiElement;
import hdi.edi.legacyparser.EdiSegment;
import hdi.edi.legacyparser.EltValHolder;
import hdi.edi.parser.DataType;
import hdi.edi.parser.EdiParsingResults;
import hdi.edi.parser.EdiSeg;
import hdi.edi.parser.Elt;
import hdi.edi.parser.NameUtils;
import hdi.edi.parser.ParsingIssue;
import hdi.edi.qualifier.EdiQualifier;
import hdi.model.enumtype.DateFormatType;
import hdi.util.Loggers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EltSet {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EltSet.class);
    public static final String RAW_VALUE_NAME = "value";
    private final List<Elt> elts = new ArrayList<Elt>();
    private EdiSeg parentSeg;
    private CodeEntity codeEntity;
    private Elt parentElt;

    public EltSet(EdiSeg parentSeg) {
        this.parentSeg = parentSeg;
    }

    public EltSet add(Elt elt) {
        this.elts.add(elt);
        elt.index(this.elts.size() - 1);
        return this;
    }

    public Elt eltByName(String name) {
        for (Elt elt : this.elts) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)elt.name(), (CharSequence)name)) continue;
            return elt;
        }
        return null;
    }

    public Elt eltByIndex(int i) {
        if (i >= this.elts.size()) {
            return null;
        }
        return this.elts.get(i);
    }

    public Elt eltByPosition(int pos) {
        for (Elt elt : this.elts) {
            if (elt.position() != pos) continue;
            return elt;
        }
        return null;
    }

    public void removeEltByPosition(int pos) {
        Elt elt = this.eltByPosition(pos);
        if (elt != null) {
            this.elts.remove(elt);
        }
    }

    public boolean containsEltsWithId() {
        for (Elt elt : this.elts) {
            if (elt.ncpdpId() == null) continue;
            return true;
        }
        return false;
    }

    public Object eltVal(String name) {
        Elt elt = this.eltByName(name);
        if (elt != null) {
            return elt.val();
        }
        return null;
    }

    private void addAll(Collection<Elt> elts) {
        for (Elt elt : elts) {
            this.add(elt);
        }
    }

    @JsonIgnore
    public String getRawValue() {
        for (Elt elt : this.elts) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)RAW_VALUE_NAME, (CharSequence)elt.name())) continue;
            return elt.valAsStr();
        }
        return null;
    }

    private void populateFromEltHolders(List<EltValHolder> eltHolders, EdiParsingResults parsingResults) {
        for (EltValHolder eltHolder : eltHolders) {
            List<Elt> eltsFromRawVal = this.createEltsFromRawVal(this.parentSeg, eltHolder, parsingResults);
            this.addAll(eltsFromRawVal);
        }
    }

    private List<Elt> createEltsFromRawVal(EdiSeg seg, EltValHolder valHolder, EdiParsingResults parsingResults) {
        Object rawVal = valHolder.value();
        String name = valHolder.eltMeta().getJsonName();
        name = NameUtils.fixupLegacyName(seg, name);
        valHolder.eltMeta().jsonName(name);
        ArrayList<Elt> elts = new ArrayList<Elt>();
        if (rawVal instanceof EdiElement) {
            EltSet childEdiSet = this.fromLegacyEdiElement(valHolder, (EdiElement)rawVal, parsingResults);
            Elt containerElt = Elt.fromEltSet(name, childEdiSet);
            containerElt.position(valHolder.eltMeta().getIndex());
            containerElt.rawEdiString(valHolder.rawValue());
            elts.add(containerElt);
        } else {
            List<Elt> transformedElts = this.transformSimpleValToElts(seg, valHolder, parsingResults);
            elts.addAll(transformedElts);
        }
        return elts;
    }

    private List<Elt> transformSimpleValToElts(EdiSeg seg, EltValHolder valHolder, EdiParsingResults parsingResults) {
        ArrayList<Elt> elts = new ArrayList<Elt>();
        Object val = valHolder.value();
        if (val == null || StringUtils.isBlank((CharSequence)val.toString())) {
            return elts;
        }
        Elt lastElt = this.getLastElt();
        EdiQualifier currentQualifier = null;
        if (lastElt != null && lastElt.dataType() == DataType.QUALIFIER) {
            currentQualifier = lastElt.qualifier();
        }
        if (DateFormatType.DATE_PERIOD.equals(currentQualifier)) {
            this.processDatePeriod(elts, valHolder, currentQualifier, parsingResults);
        } else {
            Elt elt = Elt.fromEltHolder(this, valHolder, currentQualifier, parsingResults);
            elts.add(elt);
        }
        return elts;
    }

    private void processDatePeriod(List<Elt> elts, EltValHolder valHolder, EdiQualifier currentQualifier, EdiParsingResults parsingResults) {
        String dateStr = valHolder.value().toString();
        String name = valHolder.eltMeta().getJsonName();
        String[] periodDatesStr = StringUtils.splitPreserveAllTokens((String)dateStr, (char)'-');
        if (periodDatesStr.length == 2) {
            String dateFrom = periodDatesStr[0];
            String dateTo = periodDatesStr[1];
            Elt dateElt = Elt.fromSimpleVal(this, name, dateFrom, currentQualifier, parsingResults, valHolder);
            dateElt.rawEdiString(dateStr);
            dateElt.position(valHolder.eltMeta().getIndex());
            elts.add(dateElt);
            if (StringUtils.isNotBlank((CharSequence)dateTo)) {
                Elt dateToElt = Elt.fromSimpleVal(this, name + "_to", dateTo, currentQualifier, parsingResults, valHolder);
                elts.add(dateToElt);
                dateToElt.isDerived(true);
                dateToElt.position(valHolder.eltMeta().getIndex() + 1);
            }
        } else if (dateStr.length() == 8) {
            Elt dateElt = Elt.fromSimpleVal(this, name, dateStr, currentQualifier);
            dateElt.rawEdiString(dateStr);
            dateElt.position(valHolder.eltMeta().getIndex());
            elts.add(dateElt);
        } else {
            Elt elt = Elt.fromEltHolder(this, valHolder, null, parsingResults);
            elt.isFailedConversion(true);
            elts.add(elt);
            String msg = String.format("Element: %s: Date period must have a separator '-'. Found the value %s without the separator and it is not a valid date.", valHolder.eltMeta().getDesignatorNameForLogging(), dateStr);
            if (parsingResults != null) {
                ParsingIssue parsingIssue = new ParsingIssue(valHolder.segmentNumber(), msg).lineNumber(valHolder.lineNumber());
                parsingResults.addParsingIssue(parsingIssue);
                Loggers.ediParsingIssuesLogger.warn(parsingIssue.toFormattedString());
            } else {
                Loggers.ediParsingIssuesLogger.warn(msg);
            }
        }
    }

    private Elt getLastElt() {
        if (this.elts.isEmpty()) {
            return null;
        }
        return this.elts.get(this.elts.size() - 1);
    }

    private EltSet fromLegacyEdiElement(EltValHolder valHolder, EdiElement legacyEdiElement, EdiParsingResults parsingResults) {
        EltSet childEltSet = new EltSet(this.parentSeg);
        childEltSet.populateFromEltHolders(legacyEdiElement.getEltHolders(), parsingResults);
        for (Elt elt : childEltSet.elts()) {
            elt.position(elt.position() + 1);
        }
        return childEltSet;
    }

    public static EltSet fromLegacySegment(EdiSeg parentSeg, EdiSegment legacySegment, EdiParsingResults parsingResults) {
        EltSet eltSet = new EltSet(parentSeg);
        eltSet.populateFromEltHolders(legacySegment.eltHolders(), parsingResults);
        return eltSet;
    }

    public String toString() {
        return this.elts.stream().map(Objects::toString).collect(Collectors.joining(", ", "{ ", " }"));
    }

    public List<List<Elt>> getRepeating(Collection<String> repeatingNames) {
        List<Elt> row;
        ArrayList<List<Elt>> rows = new ArrayList<List<Elt>>();
        int i = 1;
        while (!(row = this.getRowForSuffix(repeatingNames, i)).isEmpty()) {
            rows.add(row);
            ++i;
        }
        return rows;
    }

    private List<Elt> getRowForSuffix(Collection<String> repeatingNames, int suffixI) {
        ArrayList<Elt> row = new ArrayList<Elt>();
        for (String name : repeatingNames) {
            String nameWithSuffix = NameUtils.nameWithIndex(name, suffixI);
            Elt elt = this.eltByName(nameWithSuffix);
            if (elt == null) continue;
            row.add(new Elt(name, elt));
        }
        return row;
    }

    @Generated
    public List<Elt> elts() {
        return this.elts;
    }

    @Generated
    public EdiSeg parentSeg() {
        return this.parentSeg;
    }

    @Generated
    public CodeEntity codeEntity() {
        return this.codeEntity;
    }

    @Generated
    public Elt parentElt() {
        return this.parentElt;
    }

    @Generated
    public EltSet() {
    }

    @Generated
    public EltSet parentSeg(EdiSeg parentSeg) {
        this.parentSeg = parentSeg;
        return this;
    }

    @Generated
    public EltSet codeEntity(CodeEntity codeEntity) {
        this.codeEntity = codeEntity;
        return this;
    }

    @Generated
    public EltSet parentElt(Elt parentElt) {
        this.parentElt = parentElt;
        return this;
    }
}

