/*
 * Decompiled with CFR 0.152.
 */
package hdi.edi.parser;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import hdi.edi.parser.ParsingIssueSeverity;
import hdi.model.ErrorInfo;
import hdi.model.ObjectType;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
public class ParsingIssue {
    private int lineNumber = -1;
    private final int segmentNumber;
    @JsonIgnore
    private ParsingIssueSeverity severity = ParsingIssueSeverity.WARNING;
    private final String message;
    private String ediString;
    private String loop;
    private String fileName;

    public String toFormattedStringForCsv() {
        return this.severity.name() + ": " + this.toFormattedString();
    }

    public String toFormattedString() {
        StringBuilder buf = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)this.fileName)) {
            buf.append(this.fileName).append(" ");
        }
        buf.append(this.toFormattedStringNoFile());
        return buf.toString();
    }

    public String toFormattedStringNoFile() {
        StringBuilder buf = new StringBuilder();
        buf.append("Seg. number:").append(this.segmentNumber);
        if (this.lineNumber > 0) {
            buf.append(" Line:").append(this.lineNumber + 1);
        }
        if (StringUtils.isNotBlank((CharSequence)this.loop)) {
            buf.append(" Loop:").append(this.loop);
        }
        buf.append(": ").append(this.message);
        if (StringUtils.isNotBlank((CharSequence)this.ediString)) {
            buf.append(". EDI string: ").append(StringUtils.abbreviate((String)this.ediString, (int)100));
        }
        return buf.toString();
    }

    public ErrorInfo toErrorInfo() {
        ObjectType objType = this.severity == ParsingIssueSeverity.WARNING ? ObjectType.WARNING : ObjectType.ERROR;
        return new ErrorInfo(objType, this.toFormattedStringNoFile()).fileName(this.fileName);
    }

    @Generated
    public int lineNumber() {
        return this.lineNumber;
    }

    @Generated
    public int segmentNumber() {
        return this.segmentNumber;
    }

    @JsonIgnore
    @Generated
    public ParsingIssueSeverity severity() {
        return this.severity;
    }

    @Generated
    public String message() {
        return this.message;
    }

    @Generated
    public String ediString() {
        return this.ediString;
    }

    @Generated
    public String loop() {
        return this.loop;
    }

    @Generated
    public String fileName() {
        return this.fileName;
    }

    @Generated
    public ParsingIssue lineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
        return this;
    }

    @JsonIgnore
    @Generated
    public ParsingIssue severity(ParsingIssueSeverity severity) {
        this.severity = severity;
        return this;
    }

    @Generated
    public ParsingIssue ediString(String ediString) {
        this.ediString = ediString;
        return this;
    }

    @Generated
    public ParsingIssue loop(String loop) {
        this.loop = loop;
        return this;
    }

    @Generated
    public ParsingIssue fileName(String fileName) {
        this.fileName = fileName;
        return this;
    }

    @Generated
    public String toString() {
        return "ParsingIssue(lineNumber=" + this.lineNumber() + ", segmentNumber=" + this.segmentNumber() + ", severity=" + String.valueOf((Object)this.severity()) + ", message=" + this.message() + ", ediString=" + this.ediString() + ", loop=" + this.loop() + ", fileName=" + this.fileName() + ")";
    }

    @Generated
    public ParsingIssue(int segmentNumber, String message) {
        this.segmentNumber = segmentNumber;
        this.message = message;
    }
}

