/*
 * Decompiled with CFR 0.152.
 */
package hdi.edi.parser;

import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;

public enum SegmentType {
    ISA,
    AMT,
    BHT,
    BGN,
    CAS,
    CLM,
    CLP,
    CN1,
    CTP,
    DMG,
    DN1,
    DN2,
    DTP,
    GS,
    HCP,
    HI,
    HL,
    K3,
    LIN,
    LX,
    N3,
    N4,
    NM1,
    N1,
    NTE,
    PAT,
    PRV,
    QTY,
    REF,
    SBR,
    SE,
    ST,
    SV1,
    SV2,
    SV3,
    SVC,
    SVD,
    TOO,
    CL1,
    OI,
    MIA,
    MOA,
    PWK,
    PER,
    DTM,
    FRM,
    CRC,
    CR1,
    CR2,
    LQ,
    BPR,
    TRN,
    PLB,
    GE,
    IEA,
    LOOP,
    AM01,
    AM02,
    AM03,
    AM08,
    INS,
    AAA,
    BIG,
    ITD,
    IT1,
    IT2,
    IT3,
    YNQ,
    FOB,
    PKG,
    L7,
    BAL,
    INC,
    PAM,
    LM,
    MSG,
    V1,
    R4,
    FA1,
    FA2,
    TXI,
    MEA,
    PID,
    PO4,
    SDQ,
    SR,
    SAC,
    SLN,
    TC2,
    CAD,
    TDS,
    ISS,
    CTT,
    HD,
    IDC,
    DSB,
    COB,
    HLH,
    PLA,
    ACT,
    ICM,
    LUI,
    EC,
    STC;


    public static SegmentType fromTag(String tag) {
        for (SegmentType v : SegmentType.values()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)tag, (CharSequence)v.name())) continue;
            return v;
        }
        return null;
    }

    public boolean isControlSegment() {
        return this == ISA || this == GS || this == GE || this == IEA;
    }

    public boolean isOneOf(SegmentType ... segmentTypes) {
        return this.isOneOf(Arrays.asList(segmentTypes));
    }

    public boolean isOneOf(Collection<SegmentType> segmentTypes) {
        for (SegmentType segmentType : segmentTypes) {
            if (segmentType != this) continue;
            return true;
        }
        return false;
    }
}

