/*
 * Decompiled with CFR 0.152.
 */
package hdi.edi.parser;

import hdi.edi.legacyparser.EdiSegment;
import hdi.edi.parser.SegmentType;
import hdi.model.enumtype.TransactionSetType;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public enum TransactionType {
    PROF("Professional", "Claim - EDI 837P", "Prof", "837P", "222", "HC", true),
    DENTAL("Dental", "Dental Claim - EDI 837D", "Dent", "837D", "224", "HC", false),
    INST("Institutional", "Claim - EDI 837I", "Inst", "837I", "223", "HC", true),
    PAYMENT("Payment", "Payment - EDI 835", "Pmt", "835", null, "HP", true),
    PHARMACY("Pharmacy", null, "Ph", "B1", null, null, false),
    MEMBER_COVERAGE("Benefit Enrollment and Maintenance", "EDI 834", "Coverage", "834", null, null, true),
    CLAIM_ACK("Claim Acknowledgement", "EDI 277CA", "Coverage", "277CA", "212", null, false),
    ALL("All", null, "All", null, null, null, false),
    UNKNOWN("Unknown", null, "Unkn", null, null, null, false);

    private final String description;
    private final String ediDesc;
    private final String shortDesc;
    private final String ediCode;
    private final String subTypeCode;
    private final String functionalIdentifierCode;
    private final boolean isCsvSupported;
    public static final List<String> SUPPORTED_TRAN_TYPES;

    public static TransactionType fromName(String name) {
        for (TransactionType v : TransactionType.values()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)v.name())) continue;
            return v;
        }
        return null;
    }

    public static TransactionType fromEdiCode(String ediCode) {
        for (TransactionType v : TransactionType.values()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)ediCode, (CharSequence)v.ediCode())) continue;
            return v;
        }
        return null;
    }

    public static String getListOfCsvSupportedEdiCodes() {
        return Arrays.stream(TransactionType.values()).filter(TransactionType::isCsvSupported).map(TransactionType::ediCode).collect(Collectors.joining(", "));
    }

    public static TransactionType fromDescription(String desc) {
        for (TransactionType v : TransactionType.values()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)desc, (CharSequence)v.description())) continue;
            return v;
        }
        return null;
    }

    public boolean isClaim() {
        return this == DENTAL || this == PROF || this == INST;
    }

    public boolean isObjectModel() {
        return this.isClaim() || this == PAYMENT || this == MEMBER_COVERAGE || this == CLAIM_ACK;
    }

    public String fileNameForExport() {
        String fileName = this.isClaim() ? "claim" : (this == PAYMENT ? "payment" : (this == MEMBER_COVERAGE ? "member" : "exported-item"));
        return fileName;
    }

    public static TransactionType fromST(EdiSegment seg) {
        if (seg.type() != SegmentType.ST) {
            return null;
        }
        String mainType = seg.getRawElt(1);
        String tranIdentifier = seg.getRawElt(3);
        return TransactionType.fromStElements(mainType, tranIdentifier);
    }

    public static TransactionType fromStElements(String transactionSetIdentifierCode, String implementationConventionReference) {
        if (StringUtils.equals((CharSequence)transactionSetIdentifierCode, (CharSequence)TransactionSetType.PAYMENT.ediValue()) || StringUtils.equals((CharSequence)transactionSetIdentifierCode, (CharSequence)TransactionSetType.PAYMENT.name())) {
            return PAYMENT;
        }
        if (StringUtils.equals((CharSequence)transactionSetIdentifierCode, (CharSequence)TransactionSetType.MEMBER_COVERAGE.ediValue()) || StringUtils.equals((CharSequence)transactionSetIdentifierCode, (CharSequence)TransactionSetType.MEMBER_COVERAGE.name())) {
            return MEMBER_COVERAGE;
        }
        if (StringUtils.equalsAnyIgnoreCase((CharSequence)transactionSetIdentifierCode, (CharSequence[])new CharSequence[]{TransactionSetType.CLAIM_STATUS.ediValue(), TransactionSetType.CLAIM_STATUS.name()}) && StringUtils.containsAnyIgnoreCase((CharSequence)implementationConventionReference, (CharSequence[])new CharSequence[]{"214"})) {
            return CLAIM_ACK;
        }
        if (StringUtils.equals((CharSequence)transactionSetIdentifierCode, (CharSequence)TransactionSetType.CLAIM.ediValue()) || StringUtils.equals((CharSequence)transactionSetIdentifierCode, (CharSequence)TransactionSetType.CLAIM.name())) {
            if (StringUtils.containsAnyIgnoreCase((CharSequence)implementationConventionReference, (CharSequence[])new CharSequence[]{"222", "291", "298"})) {
                return PROF;
            }
            if (StringUtils.containsAnyIgnoreCase((CharSequence)implementationConventionReference, (CharSequence[])new CharSequence[]{"223", "292", "299"})) {
                return INST;
            }
            if (StringUtils.containsIgnoreCase((CharSequence)implementationConventionReference, (CharSequence)"224")) {
                return DENTAL;
            }
        }
        return UNKNOWN;
    }

    public String implementationConventionReference() {
        if (this.subTypeCode == null) {
            return null;
        }
        return "005010X" + this.subTypeCode;
    }

    public static List<String> descriptions() {
        return Arrays.stream(TransactionType.values()).map(TransactionType::description).collect(Collectors.toList());
    }

    public static List<String> descriptions(Collection<TransactionType> transactionTypes) {
        return transactionTypes.stream().map(TransactionType::description).collect(Collectors.toList());
    }

    @Generated
    public String description() {
        return this.description;
    }

    @Generated
    public String ediDesc() {
        return this.ediDesc;
    }

    @Generated
    public String shortDesc() {
        return this.shortDesc;
    }

    @Generated
    public String ediCode() {
        return this.ediCode;
    }

    @Generated
    public String subTypeCode() {
        return this.subTypeCode;
    }

    @Generated
    public String functionalIdentifierCode() {
        return this.functionalIdentifierCode;
    }

    @Generated
    public boolean isCsvSupported() {
        return this.isCsvSupported;
    }

    @Generated
    private TransactionType(String description, String ediDesc, String shortDesc, String ediCode, String subTypeCode, String functionalIdentifierCode, boolean isCsvSupported) {
        this.description = description;
        this.ediDesc = ediDesc;
        this.shortDesc = shortDesc;
        this.ediCode = ediCode;
        this.subTypeCode = subTypeCode;
        this.functionalIdentifierCode = functionalIdentifierCode;
        this.isCsvSupported = isCsvSupported;
    }

    static {
        SUPPORTED_TRAN_TYPES = List.of(INST.description(), PROF.description());
    }
}

