/*
 * Decompiled with CFR 0.152.
 */
package hdi.edi.parserhelper;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import hdi.edi.parser.DataType;
import hdi.edi.parser.EdiSeg;
import hdi.edi.parser.Elt;
import hdi.edi.parser.EltSet;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class EdiSegJsonConverter {
    private final JsonNodeFactory nodeFactory = JsonNodeFactory.instance;

    public ArrayNode convert(List<EdiSeg> segs) {
        ArrayNode rootSegsArrNode = this.nodeFactory.arrayNode();
        this.convertSegs(rootSegsArrNode, segs);
        return rootSegsArrNode;
    }

    public JsonNode convertNcpdpSegs(List<EdiSeg> segs) {
        ObjectNode rootNode = this.nodeFactory.objectNode();
        ArrayNode tranArrayNode = this.nodeFactory.arrayNode();
        rootNode.set("transactions", (JsonNode)tranArrayNode);
        for (EdiSeg tranSeg : segs) {
            ObjectNode tranNode = JsonNodeFactory.instance.objectNode();
            this.convertSeg(tranNode, tranSeg, false);
            this.convertSegs(tranNode, tranSeg.childSegs());
            tranArrayNode.add((JsonNode)tranNode);
        }
        return rootNode;
    }

    private void convertSegs(ObjectNode parentNode, List<EdiSeg> segs) {
        LinkedHashMap<String, List> segByName = new LinkedHashMap<String, List>();
        for (EdiSeg ediSeg : segs) {
            List existingSegList = segByName.computeIfAbsent(ediSeg.name(), k -> new ArrayList());
            existingSegList.add(ediSeg);
        }
        for (Map.Entry entry : segByName.entrySet()) {
            List segList = (List)entry.getValue();
            EdiSeg firstSeg = (EdiSeg)segList.get(0);
            if (firstSeg.isArray() || segList.size() > 1) {
                ArrayNode jsonArr = this.nodeFactory.arrayNode();
                parentNode.set((String)entry.getKey(), (JsonNode)jsonArr);
                this.convertSegs(jsonArr, (List<EdiSeg>)segList);
                continue;
            }
            ObjectNode node = this.convertSeg(firstSeg, true);
            parentNode.set((String)entry.getKey(), (JsonNode)node);
        }
    }

    private void convertSegs(ArrayNode arrayNode, List<EdiSeg> ediSegs) {
        for (EdiSeg seg : ediSegs) {
            ObjectNode node = this.convertSeg(seg, true);
            arrayNode.add((JsonNode)node);
        }
    }

    private void convertSeg(ObjectNode parentNode, EdiSeg seg, boolean isAddChildren) {
        ObjectNode node = this.convertSeg(seg, isAddChildren);
        parentNode.set(seg.name(), (JsonNode)node);
    }

    private ObjectNode convertSeg(EdiSeg seg, boolean isAddChildren) {
        ObjectNode node = this.nodeFactory.objectNode();
        node.set("segment_id", (JsonNode)this.nodeFactory.textNode(seg.typeAsString()));
        if (StringUtils.isNotBlank((CharSequence)seg.loop())) {
            node.set("loop_id", (JsonNode)this.nodeFactory.textNode(seg.loop()));
        }
        this.convertElts(node, seg.eltSet());
        if (isAddChildren) {
            this.convertSegs(node, seg.childSegs());
        }
        return node;
    }

    private void convertElts(ObjectNode parentNode, EltSet eltSet) {
        for (Elt elt : eltSet.elts()) {
            if (elt.dataType() == DataType.ELT_SET) {
                ObjectNode objNode = this.nodeFactory.objectNode();
                this.convertElts(objNode, elt.eltSet());
                parentNode.set(elt.name(), (JsonNode)objNode);
                continue;
            }
            parentNode.set(elt.name(), elt.toJsonNode());
        }
    }
}

