/*
 * Decompiled with CFR 0.152.
 */
package hdi.edi.parserhelper;

import hdi.edi.parser.EdiSeg;
import hdi.edi.parser.LoopType;
import hdi.edi.parser.SegmentType;
import hdi.edi.qualifier.EdiQualifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class SegMatchingCriteria {
    private String label;
    private final Collection<SegmentType> includeSegTypes = new HashSet<SegmentType>();
    private final Collection<SegmentType> excludeSegTypes = new HashSet<SegmentType>();
    private final Collection<String> includeSegNames = new HashSet<String>();
    private final Collection<LoopType> includeLoopTypes = new HashSet<LoopType>();
    private final Collection<LoopMatch> includeLoopNumbers = new HashSet<LoopMatch>();
    private EdiQualifier ediQualifier;

    public SegMatchingCriteria inclSegTypes(SegmentType ... segTypesToInclude) {
        this.includeSegTypes.addAll(Arrays.asList(segTypesToInclude));
        return this;
    }

    public SegMatchingCriteria exclSegTypes(SegmentType ... segTypesToExclude) {
        this.excludeSegTypes.addAll(Arrays.asList(segTypesToExclude));
        return this;
    }

    public SegMatchingCriteria inclSegNames(String ... names) {
        this.includeSegNames.addAll(Arrays.asList(names));
        return this;
    }

    public SegMatchingCriteria inclLoopTypes(LoopType ... loopTypes) {
        for (LoopType lt : loopTypes) {
            this.includeLoopNumbers.add(new LoopMatch(lt.loopNumber(), lt.isPrefix()));
        }
        return this;
    }

    public SegMatchingCriteria inclLoopNumbers(String ... loopNumber) {
        for (String ln : loopNumber) {
            this.includeLoopNumbers.add(new LoopMatch(ln, false));
        }
        return this;
    }

    public boolean isInLoop(EdiSeg seg) {
        if (this.includeLoopNumbers.isEmpty()) {
            return true;
        }
        for (LoopMatch l : this.includeLoopNumbers) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)l.loopNumber(), (CharSequence)seg.loop()) && (!l.isPrefix() || !StringUtils.startsWithIgnoreCase((CharSequence)seg.loop(), (CharSequence)l.loopNumber()))) continue;
            return true;
        }
        return false;
    }

    @Generated
    String label() {
        return this.label;
    }

    @Generated
    Collection<SegmentType> includeSegTypes() {
        return this.includeSegTypes;
    }

    @Generated
    Collection<SegmentType> excludeSegTypes() {
        return this.excludeSegTypes;
    }

    @Generated
    Collection<String> includeSegNames() {
        return this.includeSegNames;
    }

    @Generated
    Collection<LoopType> includeLoopTypes() {
        return this.includeLoopTypes;
    }

    @Generated
    Collection<LoopMatch> includeLoopNumbers() {
        return this.includeLoopNumbers;
    }

    @Generated
    EdiQualifier ediQualifier() {
        return this.ediQualifier;
    }

    @Generated
    public String toString() {
        return "SegMatchingCriteria(label=" + this.label() + ", includeSegTypes=" + String.valueOf(this.includeSegTypes()) + ", excludeSegTypes=" + String.valueOf(this.excludeSegTypes()) + ", includeSegNames=" + String.valueOf(this.includeSegNames()) + ", includeLoopTypes=" + String.valueOf(this.includeLoopTypes()) + ", includeLoopNumbers=" + String.valueOf(this.includeLoopNumbers()) + ", ediQualifier=" + String.valueOf(this.ediQualifier()) + ")";
    }

    @Generated
    public SegMatchingCriteria label(String label) {
        this.label = label;
        return this;
    }

    @Generated
    public SegMatchingCriteria ediQualifier(EdiQualifier ediQualifier) {
        this.ediQualifier = ediQualifier;
        return this;
    }

    public record LoopMatch(String loopNumber, boolean isPrefix) {
    }
}

