/*
 * Decompiled with CFR 0.152.
 */
package hdi.edi.parserhelper;

import hdi.edi.parser.EdiSeg;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import lombok.Generated;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegTreeHelper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SegTreeHelper.class);

    public List<EdiSeg> toFlatList(List<EdiSeg> segs) {
        ArrayList<EdiSeg> flatList = new ArrayList<EdiSeg>();
        this.populateFlatList(flatList, segs);
        return flatList;
    }

    private void populateFlatList(List<EdiSeg> flatList, List<EdiSeg> segs) {
        for (EdiSeg ediSeg : segs) {
            flatList.add(ediSeg);
            if (ediSeg.childSegs().isEmpty()) continue;
            ediSeg.isParent(true);
            this.populateFlatList(flatList, ediSeg.childSegs());
        }
    }

    public List<EdiSeg> toTree(List<EdiSeg> flatSegList) {
        ArrayList<EdiSeg> rootSegs = new ArrayList<EdiSeg>();
        LinkedHashMap<ObjectId, EdiSeg> parentByObjectId = new LinkedHashMap<ObjectId, EdiSeg>();
        for (EdiSeg seg : flatSegList) {
            if (!seg.isParent()) continue;
            parentByObjectId.put(seg.objId(), seg);
        }
        for (EdiSeg seg : flatSegList) {
            EdiSeg parentSeg = (EdiSeg)parentByObjectId.get(seg.parentObjId());
            if (seg.parentObjId() != null && parentSeg != null) {
                seg.parentSeg(parentSeg);
                parentSeg.childSegs().add(seg);
                continue;
            }
            rootSegs.add(seg);
        }
        return rootSegs;
    }
}

