/*
 * Decompiled with CFR 0.152.
 */
package hdi.edi.qualifier;

import hdi.codeent.CodeEntity;
import hdi.codeent.PrimaryCodeType;
import hdi.util.FormattingUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.StringUtils;

public interface EdiQualifier {
    public String ediValue();

    public String desc();

    public String name();

    default public PrimaryCodeType primaryCodeType() {
        return PrimaryCodeType.NONE;
    }

    default public void setDesc(String desc) {
    }

    default public String ediEltId() {
        return null;
    }

    default public String codeSource() {
        return null;
    }

    default public String toSummaryString() {
        return this.desc();
    }

    default public String descAndCode() {
        return FormattingUtils.formatDescCode(this.ediValue(), this.desc());
    }

    default public String qualifierType() {
        return this.getClass().getName();
    }

    default public String qualifierShortType() {
        return this.getClass().getSimpleName();
    }

    default public boolean isMedicalCode() {
        return false;
    }

    default public String shortDesc() {
        return StringUtils.substringBefore((String)this.desc(), (String)" ");
    }

    default public CodeEntity toCodeEntity() {
        return null;
    }

    public static <E extends Enum<E>> List<CodeEntity> toCodeEntities(Class<E> enumClass) {
        List enumList = EnumUtils.getEnumList(enumClass);
        ArrayList<CodeEntity> codeEntities = new ArrayList<CodeEntity>();
        for (Enum enumVal : enumList) {
            if (!(enumVal instanceof EdiQualifier)) continue;
            EdiQualifier ediQualifier = (EdiQualifier)((Object)enumVal);
            if (StringUtils.equals((CharSequence)"NONE", (CharSequence)enumVal.toString())) continue;
            codeEntities.add(ediQualifier.toCodeEntity());
        }
        return codeEntities;
    }

    public static Set<String> enumsToVals(Collection<? extends Enum<?>> enums) {
        HashSet<String> vals = new HashSet<String>();
        for (Enum<?> enm : enums) {
            vals.add(enm.name());
        }
        return vals;
    }

    public static boolean isOneOf(Enum<?> enumToCheck, Enum<?> ... allowedValues) {
        if (enumToCheck == null) {
            return false;
        }
        for (Enum<?> allowedValue : allowedValues) {
            if (!enumToCheck.name().equals(allowedValue.name())) continue;
            return true;
        }
        return false;
    }

    public static String enumNameToNameWithDashes(String enumName) {
        return StringUtils.replace((String)enumName, (String)"_", (String)"-").toLowerCase();
    }

    public static Set<String> classesToStrings(Collection<Class<?>> enumClasses) {
        HashSet<String> vals = new HashSet<String>();
        for (Class<?> clazz : enumClasses) {
            vals.add(clazz.getName());
        }
        return vals;
    }

    default public String toNameAndCode() {
        return this.name() + " (" + this.ediValue() + ")";
    }
}

