/*
 * Decompiled with CFR 0.152.
 */
package hdi.edi.stats;

import hdi.edi.parser.DataType;
import hdi.edi.parser.EdiSeg;
import hdi.edi.parser.Elt;
import hdi.edi.parser.EltSet;
import lombok.Generated;

public class SegStats {
    private int totalNumberOfElements = 0;
    private int numberOfCompoundElements = 0;
    private int numberOfTopLevelElements = 0;

    public SegStats populateStats(EdiSeg seg, EltSet eltSet, int depth) {
        if (seg.eltSet() == null) {
            return this;
        }
        if (eltSet == null) {
            eltSet = seg.eltSet();
        }
        for (Elt elt : eltSet.elts()) {
            if (depth == 0) {
                ++this.numberOfTopLevelElements;
            }
            ++this.totalNumberOfElements;
            if (elt.dataType() == DataType.ELT_SET) {
                ++this.numberOfCompoundElements;
                this.populateStats(seg, elt.eltSet(), ++depth);
                continue;
            }
            if (elt.dataType() != DataType.LIST) continue;
            for (EltSet childEltSet : elt.eltSets()) {
                ++this.numberOfCompoundElements;
                this.populateStats(seg, childEltSet, ++depth);
            }
        }
        return this;
    }

    @Generated
    public SegStats() {
    }

    @Generated
    public int totalNumberOfElements() {
        return this.totalNumberOfElements;
    }

    @Generated
    public int numberOfCompoundElements() {
        return this.numberOfCompoundElements;
    }

    @Generated
    public int numberOfTopLevelElements() {
        return this.numberOfTopLevelElements;
    }

    @Generated
    public SegStats totalNumberOfElements(int totalNumberOfElements) {
        this.totalNumberOfElements = totalNumberOfElements;
        return this;
    }

    @Generated
    public SegStats numberOfCompoundElements(int numberOfCompoundElements) {
        this.numberOfCompoundElements = numberOfCompoundElements;
        return this;
    }

    @Generated
    public SegStats numberOfTopLevelElements(int numberOfTopLevelElements) {
        this.numberOfTopLevelElements = numberOfTopLevelElements;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SegStats)) {
            return false;
        }
        SegStats other = (SegStats)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.totalNumberOfElements() != other.totalNumberOfElements()) {
            return false;
        }
        if (this.numberOfCompoundElements() != other.numberOfCompoundElements()) {
            return false;
        }
        return this.numberOfTopLevelElements() == other.numberOfTopLevelElements();
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SegStats;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.totalNumberOfElements();
        result = result * 59 + this.numberOfCompoundElements();
        result = result * 59 + this.numberOfTopLevelElements();
        return result;
    }

    @Generated
    public String toString() {
        return "SegStats(totalNumberOfElements=" + this.totalNumberOfElements() + ", numberOfCompoundElements=" + this.numberOfCompoundElements() + ", numberOfTopLevelElements=" + this.numberOfTopLevelElements() + ")";
    }
}

