/*
 * Decompiled with CFR 0.152.
 */
package hdi.edi.validation;

import hdi.FieldNames;
import hdi.edi.parser.TransactionType;
import hdi.edi.validation.BaseValidator;
import hdi.edi.validation.IssueType;
import hdi.edi.validation.ParentType;
import hdi.edi.validation.ValidationIssue;
import hdi.model.orgperson.ContactInfo;
import hdi.model.orgperson.EntityRole;
import hdi.model.orgperson.OrgOrPerson;
import java.util.ArrayList;
import java.util.List;

public class PartyValidator
extends BaseValidator
implements FieldNames {
    public List<ValidationIssue> validate(OrgOrPerson party, TransactionType transactionType) {
        return this.validate(party, transactionType, null);
    }

    public List<ValidationIssue> validate(OrgOrPerson party, TransactionType transactionType, ParentType parentType) {
        ArrayList<ValidationIssue> issues = new ArrayList<ValidationIssue>();
        if (!this.validateEntityRole(issues, party)) {
            return issues;
        }
        this.checkRequired(issues, "entityType", party.entityType());
        EntityRole entityRole = party.entityRole();
        if (transactionType.isClaim() && entityRole.isProvider()) {
            issues.addAll(this.validate837Provider(party, transactionType));
        }
        if (entityRole.oneOf(EntityRole.SUBMITTER)) {
            this.checkRequired(issues, "contacts", party.contacts());
        }
        return issues;
    }

    private void validatePartyWithRequiredAddressAndTaxId(List<ValidationIssue> issues, OrgOrPerson party) {
    }

    private void validatePatientOrSubscriber(List<ValidationIssue> issues, OrgOrPerson party) {
    }

    private void validateBusinessWithRequiredAddress(List<ValidationIssue> issues, OrgOrPerson party) {
    }

    private void validateBusinessWithRequiredAddressNoName(List<ValidationIssue> issues, OrgOrPerson party) {
    }

    public List<ValidationIssue> validate837Provider(OrgOrPerson party, TransactionType tranType) {
        ArrayList<ValidationIssue> issues = new ArrayList<ValidationIssue>();
        if (!this.validateEntityRole(issues, party)) {
            return issues;
        }
        this.checkRequired(issues, "entityType", party.entityType());
        EntityRole entityRole = party.entityRole();
        this.validateName(issues, party);
        if (!entityRole.oneOf(EntityRole.RENDERING, EntityRole.ATTENDING)) {
            this.checkNotAllowed(issues, "taxonomy", party.providerTaxonomy());
        }
        if (entityRole.oneOf(EntityRole.ORDERING, EntityRole.SERVICE_FACILITY)) {
            this.checkRequired(issues, "address", party.address());
        } else {
            this.checkNotAllowed(issues, "address", party.address());
        }
        if (!entityRole.oneOf(EntityRole.ORDERING)) {
            this.checkNotAllowed(issues, "contacts", party.contacts());
        }
        this.validateContacts(issues, party.contacts());
        return issues;
    }

    private boolean validateEntityRole(List<ValidationIssue> issues, OrgOrPerson party) {
        ValidationIssue issue = this.checkRequired(issues, "entityRole", party.entityRole());
        return issue == null;
    }

    private void validateContacts(List<ValidationIssue> issues, List<ContactInfo> contacts) {
    }

    private void validateNameOnlyWithOptionalTaxonomy(List<ValidationIssue> issues, OrgOrPerson party) {
    }

    private void validateName(List<ValidationIssue> issues, OrgOrPerson party) {
        this.checkRequired(issues, "identifier", party.identifier());
        this.checkRequired(issues, "identificationType", party.identificationType());
        this.checkRequired(issues, "lastNameOrOrgName", party.lastNameOrOrgName());
    }

    private ValidationIssue createIssue(IssueType issueType, String fieldName, OrgOrPerson party) {
        return null;
    }
}

