/*
 * Decompiled with CFR 0.152.
 */
package hdi.job;

import hdi.edi.parser.ParsingIssue;
import hdi.job.JobStatus;
import hdi.job.JobType;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.bson.types.ObjectId;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.LastModifiedDate;

public class JobStat {
    public static final String TOTAL_ITEM_COUNT = "totalItemCount";
    public static final String PROCESSED_ITEM_COUNT = "processedItemCount";
    public static final String NEW_ITEM_COUNT = "newItemCount";
    public static final String STATUS_FIELD = "status";
    public static final String TYPE_FIELD = "type";
    private AtomicInteger numberOfWorkers = new AtomicInteger(1);
    @Id
    private String id = ObjectId.get().toHexString();
    private JobType type;
    private JobStatus status;
    private String name;
    private int totalItemCount = 0;
    private int processedItemCount = 0;
    private int newItemCount = -1;
    private String error;
    private String warningsStr;
    private String statusMessage;
    private String lastItemProcessed;
    private String dataSetName;
    @CreatedDate
    private LocalDateTime createTimestamp;
    @LastModifiedDate
    private LocalDateTime updateTimestamp;
    private LocalDateTime endTimestamp;

    private JobStat() {
    }

    public JobStat(JobType jobType, JobStatus status, String dataSetName) {
        this(jobType, null, status, dataSetName, 1);
    }

    public JobStat(JobType jobType, String name, String dataSetName) {
        this(jobType, name, JobStatus.IN_PROCESS, dataSetName, 1);
    }

    public JobStat(JobType jobType, String name, JobStatus status, String dataSetName, int initialNumberOfWorkers) {
        this.createTimestamp = LocalDateTime.now();
        this.type = jobType;
        this.name = name;
        this.status = status;
        this.numberOfWorkers = new AtomicInteger(initialNumberOfWorkers);
        this.dataSetName = dataSetName;
    }

    public void incrementTotalCount(int count) {
        this.totalItemCount += count;
    }

    public void incrementProcessedCount(int count) {
        this.processedItemCount += count;
    }

    public String friendlyId() {
        Object s = this.genFriendlyId();
        s = (String)s + " (" + String.valueOf((Object)this.status) + ")";
        return s;
    }

    private String genFriendlyId() {
        Object s = this.type.name();
        if (this.name != null) {
            s = (String)s + "-" + this.name;
        }
        if (StringUtils.isNotBlank((CharSequence)this.dataSetName)) {
            s = (String)s + "-" + this.dataSetName;
        }
        return s;
    }

    public long getElapsedTime() {
        if (this.createTimestamp == null) {
            return -1L;
        }
        LocalDateTime start = this.createTimestamp;
        LocalDateTime stop = this.endTimestamp;
        if (stop == null) {
            stop = LocalDateTime.now();
        }
        return Duration.between(start, stop).toMillis();
    }

    public void addWarnings(List<ParsingIssue> issues) {
        if (issues == null || issues.isEmpty()) {
            return;
        }
        if (this.warningsStr == null) {
            this.warningsStr = "";
        }
        for (ParsingIssue issue : issues) {
            this.warningsStr = this.warningsStr + issue.toFormattedString() + "\n";
        }
    }

    public String errorAndWarnings() {
        StringBuilder buf = new StringBuilder();
        if (this.error != null) {
            buf.append(this.error).append("\n");
        }
        if (this.warningsStr != null) {
            buf.append(this.warningsStr).append("\n");
        }
        return buf.toString();
    }

    @Generated
    public AtomicInteger numberOfWorkers() {
        return this.numberOfWorkers;
    }

    @Generated
    public String id() {
        return this.id;
    }

    @Generated
    public JobType type() {
        return this.type;
    }

    @Generated
    public JobStatus status() {
        return this.status;
    }

    @Generated
    public String name() {
        return this.name;
    }

    @Generated
    public int totalItemCount() {
        return this.totalItemCount;
    }

    @Generated
    public int processedItemCount() {
        return this.processedItemCount;
    }

    @Generated
    public int newItemCount() {
        return this.newItemCount;
    }

    @Generated
    public String error() {
        return this.error;
    }

    @Generated
    public String warningsStr() {
        return this.warningsStr;
    }

    @Generated
    public String statusMessage() {
        return this.statusMessage;
    }

    @Generated
    public String lastItemProcessed() {
        return this.lastItemProcessed;
    }

    @Generated
    public String dataSetName() {
        return this.dataSetName;
    }

    @Generated
    public LocalDateTime createTimestamp() {
        return this.createTimestamp;
    }

    @Generated
    public LocalDateTime updateTimestamp() {
        return this.updateTimestamp;
    }

    @Generated
    public LocalDateTime endTimestamp() {
        return this.endTimestamp;
    }

    @Generated
    public JobStat numberOfWorkers(AtomicInteger numberOfWorkers) {
        this.numberOfWorkers = numberOfWorkers;
        return this;
    }

    @Generated
    public JobStat id(String id) {
        this.id = id;
        return this;
    }

    @Generated
    public JobStat type(JobType type) {
        this.type = type;
        return this;
    }

    @Generated
    public JobStat status(JobStatus status) {
        this.status = status;
        return this;
    }

    @Generated
    public JobStat name(String name) {
        this.name = name;
        return this;
    }

    @Generated
    public JobStat totalItemCount(int totalItemCount) {
        this.totalItemCount = totalItemCount;
        return this;
    }

    @Generated
    public JobStat processedItemCount(int processedItemCount) {
        this.processedItemCount = processedItemCount;
        return this;
    }

    @Generated
    public JobStat newItemCount(int newItemCount) {
        this.newItemCount = newItemCount;
        return this;
    }

    @Generated
    public JobStat error(String error) {
        this.error = error;
        return this;
    }

    @Generated
    public JobStat warningsStr(String warningsStr) {
        this.warningsStr = warningsStr;
        return this;
    }

    @Generated
    public JobStat statusMessage(String statusMessage) {
        this.statusMessage = statusMessage;
        return this;
    }

    @Generated
    public JobStat lastItemProcessed(String lastItemProcessed) {
        this.lastItemProcessed = lastItemProcessed;
        return this;
    }

    @Generated
    public JobStat dataSetName(String dataSetName) {
        this.dataSetName = dataSetName;
        return this;
    }

    @Generated
    public JobStat createTimestamp(LocalDateTime createTimestamp) {
        this.createTimestamp = createTimestamp;
        return this;
    }

    @Generated
    public JobStat updateTimestamp(LocalDateTime updateTimestamp) {
        this.updateTimestamp = updateTimestamp;
        return this;
    }

    @Generated
    public JobStat endTimestamp(LocalDateTime endTimestamp) {
        this.endTimestamp = endTimestamp;
        return this;
    }

    @Generated
    public String toString() {
        return "JobStat(numberOfWorkers=" + String.valueOf(this.numberOfWorkers()) + ", id=" + this.id() + ", type=" + String.valueOf((Object)this.type()) + ", status=" + String.valueOf((Object)this.status()) + ", name=" + this.name() + ", totalItemCount=" + this.totalItemCount() + ", processedItemCount=" + this.processedItemCount() + ", newItemCount=" + this.newItemCount() + ", error=" + this.error() + ", warningsStr=" + this.warningsStr() + ", statusMessage=" + this.statusMessage() + ", lastItemProcessed=" + this.lastItemProcessed() + ", dataSetName=" + this.dataSetName() + ", createTimestamp=" + String.valueOf(this.createTimestamp()) + ", updateTimestamp=" + String.valueOf(this.updateTimestamp()) + ", endTimestamp=" + String.valueOf(this.endTimestamp()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JobStat)) {
            return false;
        }
        JobStat other = (JobStat)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.id();
        String other$id = other.id();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof JobStat;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.id();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }
}

