/*
 * Decompiled with CFR 0.152.
 */
package hdi.license;

import hdi.license.LicenseException;
import hdi.license.LicenseInfo;
import hdi.license.LicenseReader;
import java.io.File;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CliLicenseReader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CliLicenseReader.class);
    private final LicenseReader licenseReader = new LicenseReader();

    public void checkLicense() {
        LicenseInfo licenseInfo = this.readLicense();
        if (licenseInfo == null) {
            throw new LicenseException("Did not find the license file or the key. Set environment variables %s or %s and try again. Request your license at https://datainsight.health/products/license-request", "EDI_LICENSE_FILE", "EDI_LICENSE_KEY");
        }
        log.debug("License: {}", (Object)licenseInfo);
        if (licenseInfo.isExpired()) {
            throw new LicenseException("Your license has expired. Request your license at https://datainsight.health/products/license-request", new Object[0]);
        }
        if (licenseInfo.expiresSoon()) {
            long nDays = licenseInfo.expirationInDays();
            System.err.println("Your license will expire in " + nDays);
        }
    }

    public LicenseInfo readLicense() {
        String licenseEnv;
        LicenseInfo licenseInfo = null;
        String licensePropVal = System.getProperty("edi-license-file");
        if (licensePropVal != null) {
            licenseInfo = this.licenseReader.loadLicenseFromFile(licensePropVal, "edi-license-file");
        }
        if (licenseInfo == null && (licensePropVal = System.getProperty("edi-license-key")) != null) {
            licenseInfo = this.licenseReader.readAndVerifyLicenseFromString(licensePropVal);
        }
        if (licenseInfo == null && (licenseEnv = System.getenv("EDI_LICENSE_KEY")) != null) {
            licenseInfo = this.licenseReader.readAndVerifyLicenseFromString(licenseEnv);
        }
        if (licenseInfo == null && (licenseEnv = System.getenv("EDI_LICENSE_FILE")) != null) {
            licenseInfo = this.licenseReader.loadLicenseFromFile(licenseEnv, "EDI_LICENSE_FILE");
        }
        if (licenseInfo == null && (licenseEnv = System.getenv("EDI_LICENSE")) != null) {
            licenseInfo = this.licenseReader.loadLicenseFromFile(licenseEnv, "EDI_LICENSE");
        }
        if (licenseInfo == null) {
            licenseInfo = this.checkDefaultLocation(new File("edi-license.txt"));
        }
        if (licenseInfo == null) {
            licenseInfo = this.checkDefaultLocation(new File("etc", "edi-license.txt"));
        }
        return licenseInfo;
    }

    private LicenseInfo checkDefaultLocation(File licenseFile) {
        String appHomeEnv = System.getenv("APP_HOME");
        if (appHomeEnv != null) {
            licenseFile = new File(appHomeEnv, "edi-license.txt");
        }
        licenseFile = this.licenseReader.findWithLicenseFileExtensions(licenseFile);
        LicenseInfo licenseInfo = null;
        if (licenseFile != null) {
            licenseInfo = this.licenseReader.readAndVerifyLicenseFromFile(licenseFile);
        }
        return licenseInfo;
    }
}

