/*
 * Decompiled with CFR 0.152.
 */
package hdi.license;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import hdi.license.Entitlement;
import java.io.File;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.List;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
public record LicenseInfo(LocalDate expiration, List<Entitlement> entitlements, boolean isSignatureValid, File licenseFile) {
    public static final int EXPIRES_SOON_DAYS = 10;
    public static final String INVALID_LICENSE_EXPIRATION_DATE = "1970-01-01";

    public boolean isExpired() {
        return LocalDate.now().isAfter(this.expiration);
    }

    public boolean expiresSoon() {
        return this.expirationInDays() < 10L;
    }

    public long expirationInDays() {
        return ChronoUnit.DAYS.between(LocalDate.now(), this.expiration);
    }
}

