/*
 * Decompiled with CFR 0.152.
 */
package hdi.model;

import hdi.edi.parser.TransactionType;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public enum PlaceOfServiceType {
    INPATIENT("Hospital Inpatient", "21,61", "11,12"),
    OUTPATIENT("Hospital Outpatient", "22", "13,14"),
    OFFICE("Office", "11", null),
    HOME("Home Health", "12", "32,34"),
    TELE("Telehealth", "10,02", null),
    HOSPICE("Hospice", "34", "81,22"),
    URGENT_CARE("Urgent Care Facility", "20", null),
    EMERGENCY("Emergency Room", "23", "78"),
    SNF("Skilled Nursing Facility", "31", "21,22,23"),
    NURSING("Nursing Facility", "32", null),
    ASC("Ambulatory Surgical Center", "24", "83"),
    OTHER("Other", "", "");

    private final String description;
    private final String profCodes;
    private final String instCodes;
    public static final int MAX_LENGTH = 2;

    public static List<String> descriptionsForSelection() {
        return Arrays.stream(PlaceOfServiceType.values()).filter(v -> v != OTHER).map(PlaceOfServiceType::description).collect(Collectors.toList());
    }

    public static PlaceOfServiceType fromCode(TransactionType claimType, String code) {
        for (PlaceOfServiceType t : PlaceOfServiceType.values()) {
            if (!t.matchesCode(claimType, code)) continue;
            return t;
        }
        return OTHER;
    }

    private boolean matchesCode(TransactionType claimType, String code) {
        String codeListToMatchAgainst = this.profCodes;
        if (claimType == TransactionType.INST) {
            codeListToMatchAgainst = this.instCodes;
        }
        if (codeListToMatchAgainst == null) {
            return false;
        }
        return this.matchesCode(codeListToMatchAgainst, code);
    }

    private boolean matchesCode(String codeListStr, String code) {
        String[] codes;
        code = PlaceOfServiceType.cleanupCode(code);
        for (String codeCandidate : codes = StringUtils.split((String)codeListStr, (String)",")) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)codeCandidate, (CharSequence)code)) continue;
            return true;
        }
        return false;
    }

    public static String cleanupCode(String rawCode) {
        String code = StringUtils.stripToNull((String)rawCode);
        if (code == null) {
            return null;
        }
        code = StringUtils.remove((String)code, (char)' ');
        if ((code = StringUtils.stripStart((String)code, (String)"0")).length() < 2 && StringUtils.isNumeric((CharSequence)code)) {
            code = StringUtils.rightPad((String)code, (int)2, (char)'0');
        }
        code = code.toUpperCase();
        return code;
    }

    @Generated
    public String description() {
        return this.description;
    }

    @Generated
    public String profCodes() {
        return this.profCodes;
    }

    @Generated
    public String instCodes() {
        return this.instCodes;
    }

    @Generated
    private PlaceOfServiceType(String description, String profCodes, String instCodes) {
        this.description = description;
        this.profCodes = profCodes;
        this.instCodes = instCodes;
    }
}

