/*
 * Decompiled with CFR 0.152.
 */
package hdi.model;

import hdi.model.ServiceLine;
import hdi.model.claim.ClaimTransaction;
import hdi.model.orgperson.EntityRole;
import hdi.model.orgperson.OrgOrPerson;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ProvidersUtils {
    public static OrgOrPerson findLineOrClaimProvider(EntityRole entityRole, ServiceLine serviceLine, ClaimTransaction claim) {
        OrgOrPerson provider = ProvidersUtils.findProvider(entityRole, serviceLine.providers());
        if (provider == null) {
            provider = ProvidersUtils.findClaimProvider(entityRole, claim);
        }
        return provider;
    }

    public static OrgOrPerson findClaimProvider(EntityRole entityRole, ClaimTransaction claim) {
        if (claim == null) {
            return null;
        }
        return ProvidersUtils.findProvider(entityRole, claim.providers());
    }

    public static OrgOrPerson findProvider(EntityRole entityRole, Collection<OrgOrPerson> providers) {
        if (providers == null) {
            return null;
        }
        for (OrgOrPerson orgOrPerson : providers) {
            if (orgOrPerson.entityRole() != entityRole) continue;
            return orgOrPerson;
        }
        return null;
    }

    public static List<OrgOrPerson> findClaimProviders(EntityRole entityRole, ClaimTransaction claim) {
        ArrayList<OrgOrPerson> providers = new ArrayList<OrgOrPerson>();
        if (claim.providers() != null) {
            for (OrgOrPerson orgOrPerson : claim.providers()) {
                if (orgOrPerson.entityRole() != entityRole) continue;
                providers.add(orgOrPerson);
            }
        }
        return providers;
    }
}

